/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.evilcraft.blockentity;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerBossEvent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.BossEvent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.capabilities.Capabilities;
import org.apache.commons.lang3.tuple.Triple;
import org.cyclops.cyclopscore.blockentity.BlockEntityTickerDelayed;
import org.cyclops.cyclopscore.capability.registrar.BlockEntityCapabilityRegistrar;
import org.cyclops.cyclopscore.helper.CraftingHelpers;
import org.cyclops.cyclopscore.helper.EntityHelpers;
import org.cyclops.cyclopscore.helper.Helpers;
import org.cyclops.cyclopscore.helper.LocationHelpers;
import org.cyclops.cyclopscore.helper.MinecraftHelpers;
import org.cyclops.cyclopscore.inventory.SimpleInventory;
import org.cyclops.cyclopscore.persist.IDirtyMarkListener;
import org.cyclops.evilcraft.RegistryEntries;
import org.cyclops.evilcraft.api.degradation.IDegradable;
import org.cyclops.evilcraft.block.BlockEnvironmentalAccumulatorConfig;
import org.cyclops.evilcraft.client.particle.ParticleBlurTargettedData;
import org.cyclops.evilcraft.client.particle.ParticleBubbleExtendedData;
import org.cyclops.evilcraft.core.blockentity.BlockEntityBeacon;
import org.cyclops.evilcraft.core.degradation.DegradationExecutor;
import org.cyclops.evilcraft.core.recipe.type.RecipeEnvironmentalAccumulator;
import org.cyclops.evilcraft.core.weather.WeatherType;
import org.joml.Vector4f;

public class BlockEntityEnvironmentalAccumulator
extends BlockEntityBeacon
implements IDegradable {
    public static final int MAX_AGE = 50;
    public static final int SPREAD = 25;
    private static final int ITEM_MOVE_COOLDOWN_DURATION = 1;
    private static final double WEATHER_CONTAINER_MIN_DROP_HEIGHT = 0.0;
    private static final double WEATHER_CONTAINER_MAX_DROP_HEIGHT = 2.0;
    private static final double WEATHER_CONTAINER_SPAWN_HEIGHT = (double)BlockEnvironmentalAccumulatorConfig.defaultProcessItemTickCount * BlockEnvironmentalAccumulatorConfig.defaultProcessItemSpeed + 1.0;
    private static final float ITEM_MIN_SPAWN_HEIGHT = 1.0f;
    private static final int DEGRADATION_RADIUS_BASE = 5;
    private static final int DEGRADATION_TICK_INTERVAL = 100;
    private DegradationExecutor degradationExecutor;
    private int degradation = 0;
    private BlockPos location = null;
    private static final BlockPos[] waterOffsets = new BlockPos[]{new BlockPos(-2, -1, -2), new BlockPos(-2, -1, 2), new BlockPos(2, -1, -2), new BlockPos(2, -1, 2)};
    private ServerBossEvent bossInfo = null;
    private int state = 0;
    private int tick = 0;
    private Inventory inventory;
    @Nullable
    private RecipeHolder<RecipeEnvironmentalAccumulator> recipe;
    private String recipeId;

    public BlockEntityEnvironmentalAccumulator(BlockPos blockPos, BlockState blockState) {
        super((BlockEntityType)RegistryEntries.BLOCK_ENTITY_ENVIRONMENTAL_ACCUMULATOR.get(), blockPos, blockState);
        this.recreateBossInfo();
        this.degradationExecutor = new DegradationExecutor(this);
        this.inventory = new Inventory(this);
        this.inventory.addDirtyMarkListener((IDirtyMarkListener)this);
        if (MinecraftHelpers.isClientSide()) {
            this.setBeamColor(this.getOuterColorByState(this.state));
        }
    }

    public Inventory getInventory() {
        return this.inventory;
    }

    protected void recreateBossInfo() {
        this.bossInfo = (ServerBossEvent)new ServerBossEvent((Component)Component.translatable((String)"chat.evilcraft.boss_display.charge"), BossEvent.BossBarColor.PURPLE, BossEvent.BossBarOverlay.PROGRESS).setDarkenScreen(false);
    }

    protected Triple<Float, Float, Float> getBaseBeamColor() {
        if (this.getLevel() == null) {
            return Triple.of((Object)Float.valueOf(0.0f), (Object)Float.valueOf(0.0f), (Object)Float.valueOf(0.0f));
        }
        Biome biome = (Biome)this.getLevel().getBiome(this.getBlockPos()).value();
        return Helpers.intToRGB((int)biome.getGrassColor((double)this.getBlockPos().getX(), (double)this.getBlockPos().getZ()));
    }

    @OnlyIn(value=Dist.CLIENT)
    private Vector4f getOuterColorByState(int state) {
        Triple<Float, Float, Float> baseColor = this.getBaseBeamColor();
        float coolFactor = (float)(this.getMaxCooldownTick() - this.tick) / (float)this.getMaxCooldownTick();
        if (state == 1) {
            return new Vector4f(((Float)baseColor.getLeft()).floatValue(), ((Float)baseColor.getMiddle()).floatValue(), ((Float)baseColor.getRight()).floatValue(), 0.05f);
        }
        if (state == 0) {
            return new Vector4f(((Float)baseColor.getLeft()).floatValue(), ((Float)baseColor.getMiddle()).floatValue(), ((Float)baseColor.getRight()).floatValue(), 0.13f);
        }
        return new Vector4f(((Float)baseColor.getLeft()).floatValue() * coolFactor, ((Float)baseColor.getMiddle()).floatValue() * coolFactor, ((Float)baseColor.getRight()).floatValue() * coolFactor, 0.13f);
    }

    public int getMaxCooldownTick() {
        return this.recipe == null ? BlockEnvironmentalAccumulatorConfig.defaultTickCooldown : ((RecipeEnvironmentalAccumulator)this.recipe.value()).getCooldownTime();
    }

    @OnlyIn(value=Dist.CLIENT)
    public float getMovingItemY() {
        if (this.state == 1) {
            return 1.0f + (float)(this.getItemMoveDuration() - this.tick) * this.getItemMoveSpeed();
        }
        return -1.0f;
    }

    public RecipeHolder<RecipeEnvironmentalAccumulator> getRecipe() {
        return this.recipe;
    }

    private int getItemMoveDuration() {
        if (this.recipe == null) {
            return BlockEnvironmentalAccumulatorConfig.defaultProcessItemTickCount;
        }
        return ((RecipeEnvironmentalAccumulator)this.recipe.value()).getDuration();
    }

    private float getItemMoveSpeed() {
        if (this.recipe == null) {
            return (float)BlockEnvironmentalAccumulatorConfig.defaultProcessItemSpeed;
        }
        return ((RecipeEnvironmentalAccumulator)this.recipe.value()).getProcessingSpeed();
    }

    public void setRemoved() {
        super.setRemoved();
        this.getBossInfo().removeAllPlayers();
    }

    @OnlyIn(value=Dist.CLIENT)
    protected void showWaterBeams() {
        RandomSource random = this.level.random;
        BlockPos target = this.getBlockPos();
        for (int j = 0; j < waterOffsets.length; ++j) {
            BlockPos offset = waterOffsets[j];
            BlockPos location = target.offset((Vec3i)offset);
            double x = (double)location.getX() + 0.5;
            double y = (double)location.getY() + 0.5;
            double z = (double)location.getZ() + 0.5;
            float rotationYaw = (float)LocationHelpers.getYaw((BlockPos)location, (BlockPos)target);
            float rotationPitch = (float)LocationHelpers.getPitch((BlockPos)location, (BlockPos)target);
            for (int i = 0; i < random.nextInt(2); ++i) {
                double particleX = x - 0.2 + random.nextDouble() * 0.4;
                double particleY = y - 0.2 + random.nextDouble() * 0.4;
                double particleZ = z - 0.2 + random.nextDouble() * 0.4;
                double speed = 2.0;
                double particleMotionX = (double)(Mth.sin((float)(rotationPitch / 180.0f * (float)Math.PI)) * Mth.cos((float)(rotationYaw / 180.0f * (float)Math.PI))) * speed;
                double particleMotionY = (double)Mth.cos((float)(rotationPitch / 180.0f * (float)Math.PI)) * speed * 5.0;
                double particleMotionZ = (double)(Mth.sin((float)(rotationPitch / 180.0f * (float)Math.PI)) * Mth.sin((float)(rotationYaw / 180.0f * (float)Math.PI))) * speed;
                Minecraft.getInstance().levelRenderer.addParticle((ParticleOptions)new ParticleBubbleExtendedData(0.02f), false, particleX, particleY, particleZ, particleMotionX, particleMotionY, particleMotionZ);
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    protected void showAccumulatingParticles() {
        BlockEntityEnvironmentalAccumulator.showAccumulatingParticles(this.level, (float)this.getBlockPos().getX() + 0.5f, (float)this.getBlockPos().getY() + 0.5f, (float)this.getBlockPos().getZ() + 0.5f, 25.0f);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void showAccumulatingParticles(Level world, float centerX, float centerY, float centerZ, float spread) {
        RandomSource rand = world.random;
        for (int j = 0; j < rand.nextInt(20); ++j) {
            float scale = 0.6f - rand.nextFloat() * 0.4f;
            float red = rand.nextFloat() * 0.1f + 0.2f;
            float green = rand.nextFloat() * 0.1f + 0.3f;
            float blue = rand.nextFloat() * 0.1f + 0.2f;
            float ageMultiplier = 60.0f;
            float motionX = spread - rand.nextFloat() * 2.0f * spread;
            float motionY = spread - rand.nextFloat() * 2.0f * spread;
            float motionZ = spread - rand.nextFloat() * 2.0f * spread;
            Minecraft.getInstance().levelRenderer.addParticle((ParticleOptions)new ParticleBlurTargettedData(red, green, blue, scale, ageMultiplier, centerX, centerY, centerZ), false, (double)centerX, (double)centerY, (double)centerZ, (double)motionX, (double)motionY, (double)motionZ);
        }
    }

    protected RecipeType<RecipeEnvironmentalAccumulator> getRegistry() {
        return (RecipeType)RegistryEntries.RECIPETYPE_ENVIRONMENTAL_ACCUMULATOR.get();
    }

    private void updateEnvironmentalAccumulatorIdle() {
        List entityItems = this.level.getEntitiesOfClass(ItemEntity.class, new AABB((double)this.getBlockPos().getX(), (double)this.getBlockPos().getY() + 0.0, (double)this.getBlockPos().getZ(), (double)this.getBlockPos().getX() + 1.0, (double)this.getBlockPos().getY() + 2.0, (double)this.getBlockPos().getZ() + 1.0));
        for (RecipeHolder recipe : CraftingHelpers.findRecipes((Level)this.level, this.getRegistry())) {
            Ingredient recipeIngredient = ((RecipeEnvironmentalAccumulator)recipe.value()).getInputIngredient();
            WeatherType weatherType = ((RecipeEnvironmentalAccumulator)recipe.value()).getInputWeather();
            for (Object obj : entityItems) {
                ItemEntity entityItem = (ItemEntity)obj;
                ItemStack stack = entityItem.getItem();
                if (!recipeIngredient.test(stack) || weatherType != null && !weatherType.isActive(this.level)) continue;
                this.getInventory().setItem(0, stack.copy());
                this.recipe = recipe;
                if (!this.level.isClientSide()) {
                    this.decreaseStackSize(entityItem, 1);
                }
                this.activateProcessingItemState();
                return;
            }
        }
    }

    private void decreaseStackSize(ItemEntity entityItem, int count) {
        entityItem.getItem().shrink(count);
        if (entityItem.getItem().getCount() == 0) {
            entityItem.remove(Entity.RemovalReason.DISCARDED);
        }
    }

    private void dropItemStack() {
        if (!this.level.isClientSide()) {
            ItemEntity entity = new ItemEntity(this.level, (double)this.getBlockPos().getX(), (double)this.getBlockPos().getY() + WEATHER_CONTAINER_SPAWN_HEIGHT, (double)this.getBlockPos().getZ(), ItemStack.EMPTY);
            if (this.recipe == null) {
                entity.setItem(this.getInventory().getItem(0));
            } else {
                WeatherType weatherResult;
                entity.setItem(((RecipeEnvironmentalAccumulator)this.recipe.value()).assemble(this.getInventory(), (HolderLookup.Provider)this.level.registryAccess()));
                WeatherType weatherSource = ((RecipeEnvironmentalAccumulator)this.recipe.value()).getInputWeather();
                if (weatherSource != null) {
                    weatherSource.deactivate((ServerLevel)this.level);
                }
                if ((weatherResult = ((RecipeEnvironmentalAccumulator)this.recipe.value()).getOutputWeather()) != null) {
                    weatherResult.activate((ServerLevel)this.level);
                }
            }
            this.level.addFreshEntity((Entity)entity);
        }
    }

    private void activateIdleState() {
        this.tick = 0;
        this.state = 0;
        if (!this.level.isClientSide()) {
            this.sendUpdate();
            this.setChanged();
        }
    }

    private void activateProcessingItemState() {
        this.tick = this.recipe == null ? BlockEnvironmentalAccumulatorConfig.defaultProcessItemTickCount : ((RecipeEnvironmentalAccumulator)this.recipe.value()).getDuration();
        this.state = 1;
        if (!this.level.isClientSide()) {
            this.sendUpdate();
            this.setChanged();
        }
    }

    private void activateFinishedProcessingItemState() {
        this.tick = 1;
        this.state = 3;
        if (!this.level.isClientSide()) {
            this.sendUpdate();
            this.setChanged();
        }
    }

    private void activateCooldownState() {
        ++this.degradation;
        this.degradationExecutor.setTickInterval(100 / this.degradation);
        this.tick = this.getMaxCooldownTick();
        this.state = 2;
        this.recipe = null;
        if (!this.level.isClientSide()) {
            this.sendUpdate();
            this.setChanged();
        }
    }

    public void onUpdateReceived() {
        if (this.level.isClientSide() && this.state == 3) {
            this.level.globalLevelEvent(2002, this.getBlockPos().offset(0, (int)WEATHER_CONTAINER_SPAWN_HEIGHT, 0), 16428);
        }
        this.setBeamColor(this.state);
    }

    public void setBeamColor(int state) {
        if (this.level.isClientSide()) {
            this.setBeamColor(this.getOuterColorByState(state));
        }
    }

    public int getState() {
        return this.state;
    }

    public void read(CompoundTag compound, HolderLookup.Provider holderLookupProvider) {
        super.read(compound, holderLookupProvider);
        this.inventory.readFromNBT(holderLookupProvider, compound, "inventory");
        this.degradation = compound.getInt("degradation");
        this.tick = compound.getInt("tick");
        this.state = compound.getInt("state");
        this.recipeId = compound.getString("recipe");
        this.degradationExecutor.read(compound);
        if (this.getLevel() != null && this.getLevel().isClientSide()) {
            this.setBeamColor(this.getOuterColorByState(this.state));
        }
    }

    public void saveAdditional(CompoundTag tag, HolderLookup.Provider holderLookupProvider) {
        super.saveAdditional(tag, holderLookupProvider);
        this.inventory.writeToNBT(holderLookupProvider, tag, "inventory");
        tag.putInt("degradation", this.degradation);
        tag.putInt("tick", this.tick);
        tag.putInt("state", this.state);
        if (this.recipe != null) {
            tag.putString("recipe", this.recipe.id().toString());
        }
        this.degradationExecutor.write(tag);
    }

    public float getMaxHealth() {
        if (this.state == 1) {
            return this.getItemMoveDuration();
        }
        if (this.state == 3) {
            return 0.0f;
        }
        return this.getMaxCooldownTick();
    }

    public float getHealth() {
        if (this.state == 1) {
            return this.tick;
        }
        if (this.state == 2) {
            return this.getMaxCooldownTick() - this.tick;
        }
        return this.getMaxCooldownTick();
    }

    @Override
    public BlockPos getLocation() {
        return this.getBlockPos();
    }

    @Override
    public int getRadius() {
        return 5 + this.degradation / 10;
    }

    @Override
    public List<Entity> getAreaEntities() {
        return EntityHelpers.getEntitiesInArea((Level)this.getDegradationWorld(), (BlockPos)this.getBlockPos(), (int)this.getRadius());
    }

    @Override
    public double getDegradation() {
        return this.degradation;
    }

    @Override
    public Level getDegradationWorld() {
        return this.getLevel();
    }

    public ServerBossEvent getBossInfo() {
        return this.bossInfo;
    }

    public static class Inventory
    extends SimpleInventory
    implements RecipeEnvironmentalAccumulator.Inventory {
        private final BlockEntityEnvironmentalAccumulator tile;

        public Inventory(BlockEntityEnvironmentalAccumulator tile) {
            super(1, 64);
            this.tile = tile;
        }

        @Override
        public Level getWorld() {
            return this.tile.getLevel();
        }

        @Override
        public BlockPos getPos() {
            return this.tile.getBlockPos();
        }

        public int size() {
            return this.getContainerSize();
        }
    }

    public static class Ticker
    extends BlockEntityTickerDelayed<BlockEntityEnvironmentalAccumulator> {
        protected void update(Level level, BlockPos pos, BlockState blockState, BlockEntityEnvironmentalAccumulator blockEntity) {
            super.update(level, pos, blockState, (BlockEntity)blockEntity);
            if (blockEntity.recipeId != null && level != null) {
                blockEntity.recipe = level.getRecipeManager().byKey(ResourceLocation.parse((String)blockEntity.recipeId)).orElse(null);
                blockEntity.recipeId = null;
            }
            if (blockEntity.tick > 0) {
                --blockEntity.tick;
            }
            if (blockEntity.state == 0) {
                blockEntity.updateEnvironmentalAccumulatorIdle();
            } else if (blockEntity.state == 1) {
                if (level.isClientSide()) {
                    blockEntity.showWaterBeams();
                    if (blockEntity.tick > 50) {
                        blockEntity.showAccumulatingParticles();
                    }
                }
                if (blockEntity.tick == 0) {
                    blockEntity.dropItemStack();
                    blockEntity.activateFinishedProcessingItemState();
                    blockEntity.getBossInfo().removeAllPlayers();
                    blockEntity.recreateBossInfo();
                } else {
                    blockEntity.sendUpdate();
                }
            } else if (blockEntity.state == 3) {
                if (blockEntity.tick == 0) {
                    blockEntity.activateCooldownState();
                    blockEntity.getInventory().removeItem(0, blockEntity.getInventory().getMaxStackSize());
                } else {
                    blockEntity.sendUpdate();
                }
            } else if (blockEntity.state == 2) {
                blockEntity.setBeamColor(blockEntity.state);
                blockEntity.degradationExecutor.runRandomEffect(level.isClientSide());
                if (blockEntity.tick == 0) {
                    blockEntity.activateIdleState();
                } else {
                    blockEntity.sendUpdate();
                }
            }
            if (!level.isClientSide()) {
                blockEntity.getBossInfo().setProgress(blockEntity.getHealth() / blockEntity.getMaxHealth());
                HashSet playerIds = Sets.newHashSet();
                if (blockEntity.getHealth() != blockEntity.getMaxHealth()) {
                    for (Player player : level.getEntitiesOfClass(Player.class, new AABB(pos).inflate(32.0))) {
                        blockEntity.getBossInfo().addPlayer((ServerPlayer)player);
                        playerIds.add(player.getId());
                    }
                }
                ArrayList players = Lists.newArrayList((Iterable)blockEntity.getBossInfo().getPlayers());
                for (ServerPlayer playerMP : players) {
                    if (playerIds.contains(playerMP.getId()) && blockEntity.getHealth() != 0.0f) continue;
                    blockEntity.getBossInfo().removePlayer(playerMP);
                }
            }
        }
    }

    public static class CapabilityRegistrar
    extends BlockEntityCapabilityRegistrar<BlockEntityEnvironmentalAccumulator> {
        public CapabilityRegistrar(Supplier<BlockEntityType<? extends BlockEntityEnvironmentalAccumulator>> blockEntityType) {
            super(blockEntityType);
        }

        public void populate() {
            this.add(Capabilities.ItemHandler.BLOCK, (blockEntity, direction) -> blockEntity.getInventory().getItemHandler());
        }
    }
}

