/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.evilcraft.blockentity;

import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import org.cyclops.cyclopscore.blockentity.CyclopsBlockEntity;
import org.cyclops.cyclopscore.capability.registrar.BlockEntityCapabilityRegistrar;
import org.cyclops.cyclopscore.helper.BlockHelpers;
import org.cyclops.cyclopscore.inventory.SimpleInventory;
import org.cyclops.cyclopscore.persist.IDirtyMarkListener;
import org.cyclops.cyclopscore.persist.nbt.NBTPersist;
import org.cyclops.evilcraft.RegistryEntries;
import org.cyclops.evilcraft.block.BlockDisplayStand;

public class BlockEntityDisplayStand
extends CyclopsBlockEntity {
    @NBTPersist
    private ItemStack displayStandType;
    @NBTPersist
    private boolean directionPositive = false;
    private final SimpleInventory inventory = new SimpleInventory(1, 1);

    public BlockEntityDisplayStand(BlockPos blockPos, BlockState blockState) {
        super((BlockEntityType)RegistryEntries.BLOCK_ENTITY_DISPLAY_STAND.get(), blockPos, blockState);
        this.inventory.addDirtyMarkListener((IDirtyMarkListener)this);
    }

    public SimpleInventory getInventory() {
        return this.inventory;
    }

    public void onDirty() {
        super.onDirty();
        this.sendUpdate();
    }

    public Direction.AxisDirection getDirection() {
        return this.directionPositive ? Direction.AxisDirection.POSITIVE : Direction.AxisDirection.NEGATIVE;
    }

    public void setDirection(Direction.AxisDirection direction) {
        this.directionPositive = direction == Direction.AxisDirection.POSITIVE;
        this.sendUpdate();
    }

    public void setDisplayStandType(ItemStack displayStandType) {
        this.displayStandType = displayStandType;
        this.sendUpdate();
    }

    public ItemStack getDisplayStandType() {
        return this.displayStandType;
    }

    protected Direction getFacing() {
        return (Direction)BlockHelpers.getSafeBlockStateProperty((BlockState)this.getLevel().getBlockState(this.getBlockPos()), (Property)BlockDisplayStand.FACING, (Comparable)Direction.NORTH);
    }

    protected ItemStack getContents() {
        return this.inventory.getItem(0);
    }

    public void read(CompoundTag tag, HolderLookup.Provider holderLookupProvider) {
        super.read(tag, holderLookupProvider);
        this.inventory.readFromNBT(holderLookupProvider, tag, "inventory");
    }

    public void saveAdditional(CompoundTag tag, HolderLookup.Provider holderLookupProvider) {
        this.inventory.writeToNBT(holderLookupProvider, tag, "inventory");
        super.saveAdditional(tag, holderLookupProvider);
    }

    public void onUpdateReceived() {
        super.onUpdateReceived();
        BlockHelpers.markForUpdate((Level)this.level, (BlockPos)this.worldPosition);
    }

    public static class CapabilityRegistrar
    extends BlockEntityCapabilityRegistrar<BlockEntityDisplayStand> {
        public CapabilityRegistrar(Supplier<BlockEntityType<? extends BlockEntityDisplayStand>> blockEntityType) {
            super(blockEntityType);
        }

        public void populate() {
            this.add(Capabilities.ItemHandler.BLOCK, (blockEntity, direction) -> blockEntity.getInventory().getItemHandler());
            this.add(Capabilities.FluidHandler.BLOCK, (blockEntity, direction) -> (IFluidHandler)blockEntity.getContents().getCapability(Capabilities.FluidHandler.ITEM));
        }
    }
}

