/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.evilcraft.block;

import com.mojang.serialization.MapCodec;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.cyclops.cyclopscore.helper.BlockHelpers;
import org.cyclops.evilcraft.RegistryEntries;
import org.cyclops.evilcraft.blockentity.BlockEntitySpiritReanimator;
import org.cyclops.evilcraft.client.particle.ParticleBloodBubble;
import org.cyclops.evilcraft.core.block.BlockWithEntityGuiTank;
import org.cyclops.evilcraft.core.blockentity.BlockEntityTickingTankInventory;
import org.cyclops.evilcraft.core.blockentity.BlockEntityWorking;

public class BlockSpiritReanimator
extends BlockWithEntityGuiTank {
    public static final MapCodec<BlockSpiritReanimator> CODEC = BlockSpiritReanimator.simpleCodec(BlockSpiritReanimator::new);
    public static final DirectionProperty FACING = DirectionProperty.create((String)"facing", (Predicate)Direction.Plane.HORIZONTAL);
    public static final BooleanProperty ON = BooleanProperty.create((String)"on");

    public BlockSpiritReanimator(BlockBehaviour.Properties properties) {
        super(properties, BlockEntitySpiritReanimator::new);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)FACING, (Comparable)Direction.NORTH)).setValue((Property)ON, (Comparable)Boolean.valueOf(false)));
    }

    protected MapCodec<? extends BaseEntityBlock> codec() {
        return CODEC;
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level level, BlockState blockState, BlockEntityType<T> blockEntityType) {
        return BlockSpiritReanimator.createTickerHelper(blockEntityType, (BlockEntityType)((BlockEntityType)RegistryEntries.BLOCK_ENTITY_SPIRIT_REANIMATOR.get()), (BlockEntityTicker)(level.isClientSide ? new BlockEntityTickingTankInventory.TickerClient() : new BlockEntityWorking.TickerServer()));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FACING, ON});
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        return (BlockState)((BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)context.getHorizontalDirection())).setValue((Property)ON, (Comparable)Boolean.valueOf(false));
    }

    @Override
    public int getDefaultCapacity() {
        return 10000;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void animateTick(BlockState blockState, Level world, BlockPos blockPos, RandomSource random) {
        ParticleBloodBubble.randomDisplayTick((BlockEntityWorking)world.getBlockEntity(blockPos), world, blockPos, random, (Direction)BlockHelpers.getSafeBlockStateProperty((BlockState)blockState, (Property)FACING, (Comparable)Direction.NORTH));
        super.animateTick(blockState, world, blockPos, random);
    }
}

