/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.evilcraft.block;

import com.mojang.serialization.MapCodec;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.bus.api.EventPriority;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.entity.living.LivingDeathEvent;
import org.cyclops.cyclopscore.block.BlockWithEntity;
import org.cyclops.cyclopscore.helper.BlockEntityHelpers;
import org.cyclops.evilcraft.block.BlockBloodStainConfig;
import org.cyclops.evilcraft.blockentity.BlockEntityBloodStain;
import org.cyclops.evilcraft.client.particle.ParticleBloodSplash;
import org.cyclops.evilcraft.entity.monster.EntityVengeanceSpirit;

public class BlockBloodStain
extends BlockWithEntity {
    public static final MapCodec<BlockBloodStain> CODEC = BlockBloodStain.simpleCodec(BlockBloodStain::new);
    private static final VoxelShape SHAPE = Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)1.0, (double)16.0);

    public BlockBloodStain(BlockBehaviour.Properties properties) {
        super(properties, BlockEntityBloodStain::new);
        NeoForge.EVENT_BUS.register((Object)this);
    }

    protected MapCodec<? extends BaseEntityBlock> codec() {
        return CODEC;
    }

    public boolean canBeReplaced(BlockState state, BlockPlaceContext useContext) {
        return true;
    }

    public boolean canBeReplaced(BlockState p_225541_1_, Fluid p_225541_2_) {
        return true;
    }

    public VoxelShape getShape(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        return SHAPE;
    }

    public boolean canSurvive(BlockState state, LevelReader worldIn, BlockPos pos) {
        BlockPos blockpos = pos.below();
        BlockState blockstate = worldIn.getBlockState(blockpos);
        if (!BlockBloodStainConfig.spawnOnBlockEntities && worldIn.getBlockEntity(blockpos) != null) {
            return false;
        }
        String blockName = BuiltInRegistries.BLOCK.getKey((Object)blockstate.getBlock()).toString();
        for (String blacklistedRegex : BlockBloodStainConfig.spawnBlacklist) {
            if (!blockName.matches(blacklistedRegex)) continue;
            return false;
        }
        return blockstate.isFaceSturdy((BlockGetter)worldIn, blockpos, Direction.UP) && blockstate.isValidSpawn((BlockGetter)worldIn, blockpos, EntityType.CHICKEN) || blockstate.getBlock() == Blocks.HOPPER;
    }

    public void neighborChanged(BlockState state, Level worldIn, BlockPos pos, Block blockIn, BlockPos fromPos, boolean isMoving) {
        if (!worldIn.isClientSide && !state.canSurvive((LevelReader)worldIn, pos)) {
            worldIn.removeBlock(pos, false);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void attack(BlockState state, Level worldIn, BlockPos pos, Player player) {
        BlockBloodStain.splash(worldIn, pos);
        super.attack(state, worldIn, pos, player);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void entityInside(BlockState state, Level worldIn, BlockPos pos, Entity entityIn) {
        if (entityIn.getDeltaMovement().length() > 0.1) {
            BlockBloodStain.splash(worldIn, pos);
        }
        super.entityInside(state, worldIn, pos, entityIn);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void splash(Level world, BlockPos blockPos) {
        if (world.isClientSide()) {
            ParticleBloodSplash.spawnParticles(world, blockPos, 1, 1 + world.random.nextInt(1));
        }
    }

    public void handlePrecipitation(BlockState blockState, Level world, BlockPos blockPos, Biome.Precipitation precipitation) {
        world.removeBlock(blockPos, false);
    }

    @SubscribeEvent(priority=EventPriority.NORMAL)
    public void bloodStainedBlockEvent(LivingDeathEvent event) {
        if (event.getSource() == event.getEntity().damageSources().fall() && !(event.getEntity() instanceof EntityVengeanceSpirit)) {
            int x = Mth.floor((double)event.getEntity().getX());
            int y = Mth.floor((double)event.getEntity().getY());
            int z = Mth.floor((double)event.getEntity().getZ());
            if (!event.getEntity().level().isClientSide()) {
                event.getEntity().getServer().execute(() -> {
                    BlockPos pos = new BlockPos(x, y - 1, z);
                    Block block = event.getEntity().level().getBlockState(pos).getBlock();
                    int amount = (int)((float)BlockBloodStainConfig.bloodMBPerHP * event.getEntity().getMaxHealth());
                    if (block != this) {
                        pos = pos.offset(0, 1, 0);
                        if (event.getEntity().getCommandSenderWorld().isEmptyBlock(pos) && this.canSurvive(this.defaultBlockState(), (LevelReader)event.getEntity().getCommandSenderWorld(), pos)) {
                            event.getEntity().getCommandSenderWorld().setBlockAndUpdate(pos, this.defaultBlockState());
                        }
                    }
                    BlockEntityHelpers.get((BlockGetter)event.getEntity().getCommandSenderWorld(), (BlockPos)pos, BlockEntityBloodStain.class).ifPresent(tile -> tile.addAmount(amount));
                });
            } else {
                Random random = new Random();
                BlockPos pos = new BlockPos(x, y, z);
                ParticleBloodSplash.spawnParticles(event.getEntity().level(), pos.offset(0, 1, 0), (int)event.getEntity().getMaxHealth() + random.nextInt(15), 5 + random.nextInt(5));
            }
        }
    }
}

