/*
 * Decompiled with CFR 0.152.
 */
package com.strawberry.gaze.common.spiritrite.effect;

import com.sammy.malum.common.entity.activator.BlockRiteEffectActivatorEntity;
import com.sammy.malum.core.systems.rite.effect.SpiritRiteBlockEffect;
import com.sammy.malum.core.systems.rite.effect.SpiritRiteEffectTag;
import com.sammy.malum.registry.common.magic.MalumSpiritTypes;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CampfireBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class GazeLesserAqueousCorruptedRiteEffect
extends SpiritRiteBlockEffect {
    public GazeLesserAqueousCorruptedRiteEffect() {
        super(new SpiritRiteEffectTag[]{SpiritRiteEffectTag.LESSER_RITE});
    }

    public void applyEffect(ServerLevel level, BlockRiteEffectActivatorEntity activator, BlockState state, BlockPos pos, float v) {
        int radius = Math.max(0, (int)v - 1);
        BlockPos center = activator.blockPosition();
        for (int dx = -radius; dx <= radius; ++dx) {
            for (int dy = -radius; dy <= radius; ++dy) {
                for (int dz = -radius; dz <= radius; ++dz) {
                    BlockPos targetPos = center.offset(dx, dy, dz);
                    BlockState targetState = level.getBlockState(targetPos);
                    if (targetState.is(Blocks.FIRE)) {
                        level.removeBlock(targetPos, false);
                    }
                    if (targetState.getBlock() instanceof CampfireBlock && ((Boolean)targetState.getValue((Property)CampfireBlock.LIT)).booleanValue()) {
                        level.setBlock(targetPos, (BlockState)targetState.setValue((Property)CampfireBlock.LIT, (Comparable)Boolean.valueOf(false)), 3);
                    }
                    if (targetState.is(Blocks.LAVA)) {
                        level.setBlock(targetPos, Blocks.OBSIDIAN.defaultBlockState(), 3);
                    }
                    this.createEffect(level, targetPos, List.of(MalumSpiritTypes.ELDRITCH_SPIRIT, MalumSpiritTypes.AERIAL_SPIRIT, MalumSpiritTypes.AQUEOUS_SPIRIT));
                }
            }
        }
    }
}

