/*
 * Decompiled with CFR 0.152.
 */
package com.strawberry.gaze.common.spiritrite.effect;

import com.sammy.malum.common.block.storage.jar.SpiritJarBlockEntity;
import com.sammy.malum.common.entity.activator.BlockRiteEffectActivatorEntity;
import com.sammy.malum.common.item.spirit.SpiritShardItem;
import com.sammy.malum.core.systems.rite.effect.SpiritRiteBlockEffect;
import com.sammy.malum.core.systems.rite.effect.SpiritRiteEffect;
import com.sammy.malum.core.systems.rite.effect.SpiritRiteEffectTag;
import com.sammy.malum.core.systems.spirit.type.SpiritArcanaType;
import com.sammy.malum.core.systems.spirit.type.SpiritLike;
import com.sammy.malum.registry.common.magic.MalumSpiritTypes;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.ChestBlockEntity;
import net.minecraft.world.level.block.entity.RandomizableContainerBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;

public class GazeGreaterArcaneRiteEffect
extends SpiritRiteBlockEffect {
    private List<BlockPos> cachedChests = new ArrayList<BlockPos>();
    private List<BlockPos> cachedJars = new ArrayList<BlockPos>();

    public GazeGreaterArcaneRiteEffect() {
        super(new SpiritRiteEffectTag[]{SpiritRiteEffectTag.GREATER_RITE});
    }

    private ItemStack insertIntoChest(ChestBlockEntity chest, ItemStack stack) {
        for (int i = 0; i < chest.getContainerSize(); ++i) {
            ItemStack slot = chest.getItem(i);
            if (slot.isEmpty()) {
                chest.setItem(i, stack);
                return ItemStack.EMPTY;
            }
            if (!ItemStack.isSameItemSameComponents((ItemStack)slot, (ItemStack)stack) || slot.getCount() >= slot.getMaxStackSize()) continue;
            int transferable = Math.min(stack.getCount(), slot.getMaxStackSize() - slot.getCount());
            slot.grow(transferable);
            stack.shrink(transferable);
            if (!stack.isEmpty()) continue;
            return ItemStack.EMPTY;
        }
        return stack;
    }

    private List<BlockPos> getNearbyBlocks(ServerLevel level, BlockPos origin, int radius, Class<?> blockClass) {
        ArrayList<BlockPos> result = new ArrayList<BlockPos>();
        for (int dx = -radius; dx <= radius; ++dx) {
            for (int dy = 0; dy <= 5; ++dy) {
                for (int dz = -radius; dz <= radius; ++dz) {
                    BlockPos current = origin.offset(dx, dy, dz);
                    BlockEntity be = level.getBlockEntity(current);
                    if (be != null && blockClass.isAssignableFrom(be.getClass())) {
                        result.add(current);
                        continue;
                    }
                    if (be == null || !SpiritJarBlockEntity.class.isAssignableFrom(be.getClass())) continue;
                    this.cachedJars.add(current);
                }
            }
        }
        return result;
    }

    public boolean triggerRiteEffect(ServerLevel level, BlockPos pos, SpiritArcanaType definingSpirit, SpiritRiteEffect.RiteParameters parameters) {
        this.cachedChests = this.getNearbyBlocks(level, pos, 5, RandomizableContainerBlockEntity.class);
        if (this.cachedChests.isEmpty() && this.cachedJars.isEmpty()) {
            return false;
        }
        return super.triggerRiteEffect(level, pos, definingSpirit, parameters);
    }

    public void applyEffect(ServerLevel level, BlockRiteEffectActivatorEntity activator, BlockState blockState, BlockPos pos, float v) {
        int radius = (int)(v - 1.0f);
        BlockPos effectCenter = activator.blockPosition();
        List itemEntities = level.getEntitiesOfClass(ItemEntity.class, new AABB(effectCenter).inflate((double)radius), e -> e.isAlive() && !e.getItem().isEmpty());
        block0: for (ItemEntity itemEntity : itemEntities) {
            ItemStack remaining;
            BlockEntity be;
            ItemStack stack = itemEntity.getItem();
            boolean inserted = false;
            for (BlockPos jarPos : this.cachedJars) {
                be = level.getBlockEntity(jarPos);
                if (!(be instanceof SpiritJarBlockEntity)) continue;
                SpiritJarBlockEntity jar = (SpiritJarBlockEntity)be;
                if (!(stack.getItem() instanceof SpiritShardItem) || !jar.getInventory(Direction.NORTH).isItemValid(1, stack)) continue;
                remaining = jar.getInventory(Direction.NORTH).insertItem(1, stack, false);
                if (remaining.isEmpty()) {
                    itemEntity.discard();
                    inserted = true;
                    break;
                }
                itemEntity.setItem(remaining);
                inserted = true;
            }
            if (inserted) continue;
            for (BlockPos chestPos : this.cachedChests) {
                be = level.getBlockEntity(chestPos);
                if (!(be instanceof ChestBlockEntity)) continue;
                ChestBlockEntity chest = (ChestBlockEntity)be;
                remaining = this.insertIntoChest(chest, stack.copy());
                chest.setChanged();
                if (remaining.isEmpty()) {
                    itemEntity.discard();
                    continue block0;
                }
                itemEntity.setItem(remaining);
            }
        }
        this.createEffect(level, effectCenter, new SpiritLike[]{MalumSpiritTypes.ELDRITCH_SPIRIT, MalumSpiritTypes.ELDRITCH_SPIRIT, MalumSpiritTypes.SACRED_SPIRIT, MalumSpiritTypes.ARCANE_SPIRIT, MalumSpiritTypes.ARCANE_SPIRIT});
    }
}

