/*
 * Decompiled with CFR 0.152.
 */
package com.strawberry.gaze.common.item.curiosities.curios.runes;

import com.google.common.collect.Multimap;
import com.sammy.malum.common.item.IMalumEventResponder;
import com.sammy.malum.common.item.curiosities.curios.runes.madness.MadnessRuneCurioItem;
import com.sammy.malum.core.helpers.ComponentHelper;
import com.sammy.malum.registry.common.MalumAttributes;
import com.sammy.malum.registry.common.magic.MalumSpiritTypes;
import com.strawberry.gaze.GazeMod;
import java.util.WeakHashMap;
import java.util.function.Consumer;
import java.util.logging.Logger;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import top.theillusivec4.curios.api.SlotContext;

public class RuneFafnirItem
extends MadnessRuneCurioItem
implements IMalumEventResponder {
    private static final ResourceLocation EIR_BOOST_ID = GazeMod.gazePath("eir_rune");
    private static final WeakHashMap<LivingEntity, Integer> boostTimers = new WeakHashMap();

    public RuneFafnirItem(Item.Properties builder) {
        super(builder, MalumSpiritTypes.AERIAL_SPIRIT);
    }

    public void addExtraTooltipLines(Consumer<Component> consumer) {
        consumer.accept(ComponentHelper.positiveCurioEffect((String)"rune_of_fafnir", (Object[])new Object[0]));
    }

    public void addAttributeModifiers(Multimap<Holder<Attribute>, AttributeModifier> map, SlotContext slotContext, ItemStack stack) {
        LivingEntity entity = slotContext.entity();
        if (entity == null) {
            this.addAttributeModifier(map, (Holder)MalumAttributes.MALIGNANT_CONVERSION, new AttributeModifier(GazeMod.gazePath("fafnir_conversion"), (double)0.1f, AttributeModifier.Operation.ADD_VALUE));
            return;
        }
        double added = 0.1;
        double current = entity.getAttributeValue((Holder)MalumAttributes.MALIGNANT_CONVERSION);
        double newValue = current + added;
        double overflow = Math.max(0.0, newValue - 1.0);
        ResourceLocation id = GazeMod.gazePath("fafnir_conversion");
        this.addAttributeModifier(map, (Holder)MalumAttributes.MALIGNANT_CONVERSION, new AttributeModifier(id, added, AttributeModifier.Operation.ADD_VALUE));
        if (overflow <= 0.0) {
            return;
        }
        Logger.getGlobal().info("[Fafnir Rune] Overflow detected for {}: current={} added={} newValue={} overflow={}" + entity.getName().getString() + current + added + newValue + overflow);
        double scale = overflow;
        this.addAttributeModifier(map, (Holder)MalumAttributes.MALIGNANT_AEGIS_CAPACITY, new AttributeModifier(GazeMod.gazePath("fafnir_overflow_cap"), scale, AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL));
        this.addAttributeModifier(map, (Holder)MalumAttributes.MALIGNANT_AEGIS_RECOVERY_GAIN, new AttributeModifier(GazeMod.gazePath("fafnir_overflow_gain"), scale, AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL));
        this.addAttributeModifier(map, (Holder)MalumAttributes.MALIGNANT_AEGIS_RECOVERY_RATE, new AttributeModifier(GazeMod.gazePath("fafnir_overflow_rate"), scale, AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL));
    }
}

