/*
 * Decompiled with CFR 0.152.
 */
package com.strawberry.gaze.common.entity;

import com.sammy.malum.common.item.curiosities.TemporarilyDisabledItem;
import com.sammy.malum.common.worldevent.DelayedDamageWorldEvent;
import com.sammy.malum.core.systems.registry.SpiritHolder;
import com.sammy.malum.core.systems.spirit.type.SpiritLike;
import com.sammy.malum.registry.common.MalumDamageTypes;
import com.sammy.malum.registry.common.MalumParticleEffectTypes;
import com.sammy.malum.registry.common.MalumParticles;
import com.sammy.malum.registry.common.MalumSoundEvents;
import com.sammy.malum.registry.common.magic.MalumSpiritTypes;
import com.sammy.malum.visual_effects.SpiritLightSpecs;
import com.sammy.malum.visual_effects.networked.MalumNetworkedParticleEffectColorData;
import com.strawberry.gaze.GazeMod;
import com.strawberry.gaze.common.item.curiosities.weapons.VeilDaggerItem;
import com.strawberry.gaze.registry.GazeEntityRegistry;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.ThrowableItemProjectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;
import team.lodestar.lodestone.handlers.LodestoneRenderHandler;
import team.lodestar.lodestone.handlers.WorldEventHandler;
import team.lodestar.lodestone.helpers.DamageTypeHelper;
import team.lodestar.lodestone.helpers.RandomHelper;
import team.lodestar.lodestone.helpers.SoundHelper;
import team.lodestar.lodestone.systems.easing.Easing;
import team.lodestar.lodestone.systems.network.particle.NetworkedParticleEffectType;
import team.lodestar.lodestone.systems.particle.ParticleEffectSpawner;
import team.lodestar.lodestone.systems.particle.SimpleParticleOptions;
import team.lodestar.lodestone.systems.particle.builder.WorldParticleBuilder;
import team.lodestar.lodestone.systems.particle.data.GenericParticleData;
import team.lodestar.lodestone.systems.particle.data.GenericParticleDataWrapper;
import team.lodestar.lodestone.systems.particle.data.color.ColorParticleDataWrapper;
import team.lodestar.lodestone.systems.particle.data.spin.SpinParticleData;
import team.lodestar.lodestone.systems.particle.data.spin.SpinParticleDataWrapper;
import team.lodestar.lodestone.systems.particle.render_types.LodestoneWorldParticleRenderType;
import team.lodestar.lodestone.systems.particle.world.LodestoneWorldParticle;
import team.lodestar.lodestone.systems.particle.world.behaviors.DirectionalParticleBehavior;
import team.lodestar.lodestone.systems.particle.world.behaviors.LodestoneParticleBehavior;
import team.lodestar.lodestone.systems.rendering.trail.TrailPointBuilder;
import team.lodestar.lodestone.systems.worldevent.WorldEventInstance;

public class VeilDaggerProjectileEntity
extends ThrowableItemProjectile {
    public TrailPointBuilder trailPointBuilder = TrailPointBuilder.create((int)60);
    public TrailPointBuilder spinningTrailPointBuilder = TrailPointBuilder.create((int)8);
    public float spinOffset = (float)((double)this.random.nextFloat() * Math.PI * 2.0);
    protected float damage;
    protected float magicDamage;
    public int age;
    public int targetSelectionTimer;
    public int bounceCount;
    public int returnTimer;
    public int slot;
    private List<Entity> hitEntities = new ArrayList<Entity>();
    private LivingEntity forcedTarget;

    public VeilDaggerProjectileEntity(Level level) {
        super((EntityType)GazeEntityRegistry.VEILS_EDGE.get(), level);
        this.noPhysics = false;
    }

    public VeilDaggerProjectileEntity(Level level, double pX, double pY, double pZ) {
        this(level);
        this.setPos(pX, pY, pZ);
        this.noPhysics = true;
    }

    public void setData(LivingEntity owner, float damage, float magicDamage, int slot) {
        this.setOwner((Entity)owner);
        this.damage = damage;
        this.magicDamage = magicDamage;
        this.slot = slot;
    }

    protected Item getDefaultItem() {
        return (Item)GazeMod.VEIL_DAGGER.get();
    }

    public void addAdditionalSaveData(CompoundTag compound) {
        super.addAdditionalSaveData(compound);
        if (this.damage != 0.0f) {
            compound.putFloat("damage", this.damage);
        }
        if (this.magicDamage != 0.0f) {
            compound.putFloat("magicDamage", this.magicDamage);
        }
        if (this.age != 0) {
            compound.putInt("age", this.age);
        }
        if (this.targetSelectionTimer != 0) {
            compound.putInt("secondBounceDelay", this.targetSelectionTimer);
        }
        if (this.bounceCount != 0) {
            compound.putInt("bounceCount", this.bounceCount);
        }
        if (this.slot != 0) {
            compound.putInt("slot", this.slot);
        }
        if (this.returnTimer != 0) {
            compound.putInt("returnTimer", this.returnTimer);
        }
    }

    public void readAdditionalSaveData(CompoundTag compound) {
        super.readAdditionalSaveData(compound);
        this.damage = compound.getFloat("damage");
        this.magicDamage = compound.getFloat("magicDamage");
        this.age = compound.getInt("age");
        this.targetSelectionTimer = compound.getInt("secondBounceDelay");
        this.bounceCount = compound.getInt("bounceCount");
        this.slot = compound.getInt("slot");
        this.returnTimer = compound.getInt("returnTimer");
    }

    protected void onHit(HitResult result) {
        super.onHit(result);
        this.bounce();
    }

    protected void onHitBlock(BlockHitResult result) {
        if (!(this.isReturning() || this.forcedTarget != null && this.forcedTarget.isAlive() && this.position().distanceTo(this.forcedTarget.position()) < 2.0)) {
            super.onHitBlock(result);
            if (result.getDirection().getAxis().isVertical()) {
                this.setDeltaMovement(this.getDeltaMovement().multiply(1.0, -1.0, 1.0));
            } else if (result.getDirection().getAxis().equals((Object)Direction.Axis.X)) {
                this.setDeltaMovement(this.getDeltaMovement().multiply(-1.0, 1.0, 1.0));
            } else if (result.getDirection().getAxis().equals((Object)Direction.Axis.Z)) {
                this.setDeltaMovement(this.getDeltaMovement().multiply(1.0, 1.0, -1.0));
            }
            this.jumbleMovement(0.2f);
        }
    }

    protected void onHitEntity(EntityHitResult result) {
        Level var3 = this.level();
        if (var3 instanceof ServerLevel) {
            ServerLevel level = (ServerLevel)var3;
            Entity target = result.getEntity();
            Entity owner = this.getOwner();
            if (this.hitEntities.contains(target)) {
                return;
            }
            if (owner instanceof LivingEntity) {
                target.invulnerableTime = 0;
                DamageSource source = DamageTypeHelper.create((Level)this.level(), (ResourceKey)MalumDamageTypes.VOODOO, (Entity)this, (Entity)this.getOwner());
                boolean success = target.hurt(source, this.magicDamage / 2.0f);
                if (success) {
                    this.hitEntities.add(target);
                    if (target instanceof LivingEntity) {
                        LivingEntity livingEntity = (LivingEntity)target;
                        int slashCount = 3;
                        ResourceKey physicalDamageType = MalumDamageTypes.SUNDERING_ANCHOR_PHYSICAL_COMBO;
                        ResourceKey magicDamageType = MalumDamageTypes.SUNDERING_ANCHOR_MAGIC_COMBO;
                        int delay = 8;
                        float pitch = RandomHelper.randomBetween((RandomSource)level.getRandom(), (float)1.5f, (float)2.0f);
                        SoundHelper.playSound((Entity)this, (SoundEvent)((SoundEvent)MalumSoundEvents.SUNDERING_ANCHOR_SWING.get()), (float)2.0f, (float)pitch);
                        int comboDelay = delay + 1;
                        WorldEventHandler.addWorldEvent((Level)level, (WorldEventInstance)new DelayedDamageWorldEvent(target).setAttacker(this.getOwner()).setDamageData(physicalDamageType, this.damage / (float)slashCount, magicDamageType, this.magicDamage / (float)slashCount, comboDelay).setImpactParticleEffect((NetworkedParticleEffectType)MalumParticleEffectTypes.ETHERIC_NITRATE_IMPACT, new MalumNetworkedParticleEffectColorData((SpiritLike[])new SpiritHolder[]{VeilDaggerItem.getVeilDaggerSpirit()})).setSound((Holder)MalumSoundEvents.SUSPICIOUS_DEVICE_DETONATES_AGAIN, 1.25f, 1.5f, 0.7f));
                        this.selectNearbyTarget(level);
                        this.jumbleMovement(0.8f);
                        this.returnTimer = 81;
                        this.bounceCount = 10;
                    }
                }
            }
        }
    }

    protected boolean canHitEntity(Entity target) {
        if (target == null || target == this.getOwner()) {
            return false;
        }
        if (target instanceof VeilDaggerProjectileEntity) {
            return false;
        }
        if (this.hitEntities.contains(target)) {
            return false;
        }
        return super.canHitEntity(target);
    }

    protected boolean canHitEntityStupidCopy(Entity pTarget) {
        if (pTarget.equals((Object)this.getOwner())) {
            return false;
        }
        if (pTarget instanceof VeilDaggerProjectileEntity) {
            return false;
        }
        return this.hitEntities.contains(pTarget) ? false : super.canHitEntity(pTarget);
    }

    public void tick() {
        Vec3 deltaMovement = this.getDeltaMovement();
        super.tick();
        this.setDeltaMovement(this.getDeltaMovement().normalize().scale(deltaMovement.length()));
        ++this.age;
        ++this.returnTimer;
        Level var3 = this.level();
        if (var3 instanceof ServerLevel) {
            Entity ownerPos;
            ServerLevel level = (ServerLevel)var3;
            AABB aabb = this.getBoundingBox().inflate(2.0);
            for (Entity target : level.getEntities((Entity)this, aabb, this::canHitEntityStupidCopy)) {
                this.onHit((HitResult)new EntityHitResult(target));
            }
            if (this.age % 20 == 0) {
                this.selectNearbyTarget(level);
            }
            if ((ownerPos = this.getOwner()) instanceof LivingEntity) {
                LivingEntity owner = (LivingEntity)ownerPos;
                if (this.isReturning()) {
                    Vec3 ownerPosVec = owner.position().add(0.0, (double)(owner.getBbHeight() * 0.6f), 0.0);
                    float velocityLimit = 3.0f;
                    Vec3 motion = this.getDeltaMovement();
                    double velocity = Mth.clamp((double)(motion.length() * 1.25), (double)0.5, (double)velocityLimit);
                    Vec3 returnMotion = ownerPosVec.subtract(this.position()).normalize().scale(velocity);
                    this.setDeltaMovement(motion.lerp(returnMotion, (double)0.3f));
                    if (this.isAlive() && this.distanceTo((Entity)owner) < 2.5f) {
                        SoundHelper.playSound((Entity)owner, (SoundEvent)((SoundEvent)MalumSoundEvents.SUNDERING_ANCHOR_CATCH.get()), (float)0.5f, (float)RandomHelper.randomBetween((RandomSource)this.level().getRandom(), (float)1.5f, (float)2.0f));
                        if (owner instanceof ServerPlayer) {
                            ServerPlayer player = (ServerPlayer)owner;
                            TemporarilyDisabledItem.enable((ServerPlayer)player, (int)this.slot);
                            if (!player.isCreative()) {
                                int cooldown = 120;
                                player.getCooldowns().addCooldown(this.getItem().getItem(), cooldown);
                            }
                        }
                        this.remove(Entity.RemovalReason.DISCARDED);
                    }
                }
            }
            if (!this.isReturning()) {
                if (this.targetSelectionTimer > 0) {
                    --this.targetSelectionTimer;
                    if (this.targetSelectionTimer == 0) {
                        this.selectNearbyTarget(level);
                    }
                }
                this.homeIn(level);
            }
        } else {
            if (this.level().isClientSide) {
                this.spawnParticles();
            }
            Vec3 projectileDirection = this.getDeltaMovement().normalize();
            float yRot = (float)(Mth.atan2((double)projectileDirection.x, (double)projectileDirection.z) * 57.2957763671875);
            float yaw = (float)Math.toRadians(yRot);
            Vec3 left = new Vec3(-Math.cos(yaw), 0.0, Math.sin(yaw));
            Vec3 up = left.cross(projectileDirection);
            float offsetScale = Mth.clampedLerp((float)0.1f, (float)0.3f, (float)this.getVisualEffectScalar());
            for (int i = 0; i < 2; ++i) {
                float progress = (float)(i + 1) * 0.5f;
                Vec3 position = this.getPosition(progress);
                float scalar = ((float)this.age + progress) / 2.0f;
                double xOffset = Math.cos(this.spinOffset + scalar) * (double)offsetScale;
                double zOffset = Math.sin(this.spinOffset + scalar) * (double)offsetScale;
                this.trailPointBuilder.addTrailPoint(position);
                this.spinningTrailPointBuilder.addTrailPoint(position.add(left.scale(xOffset)).add(up.scale(zOffset)));
            }
            this.trailPointBuilder.tickTrailPoints();
            this.spinningTrailPointBuilder.tickTrailPoints();
        }
    }

    @NotNull
    public SoundSource getSoundSource() {
        return this.getOwner() != null ? this.getOwner().getSoundSource() : SoundSource.PLAYERS;
    }

    public void shootFromRotation(@NotNull Entity shooter, float rotationPitch, float rotationYaw, float pitchOffset, float velocity, float innacuracy) {
        float f = -Mth.sin((float)(rotationYaw * ((float)Math.PI / 180))) * Mth.cos((float)(rotationPitch * ((float)Math.PI / 180)));
        float f1 = -Mth.sin((float)((rotationPitch + pitchOffset) * ((float)Math.PI / 180)));
        float f2 = Mth.cos((float)(rotationYaw * ((float)Math.PI / 180))) * Mth.cos((float)(rotationPitch * ((float)Math.PI / 180)));
        this.shoot(f, f1, f2, velocity, innacuracy);
    }

    public boolean isReturning() {
        return this.returnTimer > 30 || this.bounceCount >= 5;
    }

    public void jumbleMovement(float weight) {
        float randomRotationX = (float)(Math.random() * Math.PI * 2.0);
        float randomRotationY = (float)(Math.random() * Math.PI * 2.0);
        float randomRotationZ = (float)(Math.random() * Math.PI * 2.0);
        Vec3 motion = this.getDeltaMovement();
        Vec3 newMotion = motion.xRot(randomRotationX).yRot(randomRotationY);
        double cosZ = Math.cos(randomRotationZ);
        double sinZ = Math.sin(randomRotationZ);
        double x = newMotion.x * cosZ - newMotion.y * sinZ;
        double y = newMotion.x * sinZ + newMotion.y * cosZ;
        double z = newMotion.z;
        Vec3 lerp = motion.lerp(new Vec3(x, y, z), (double)weight);
        this.setDeltaMovement(lerp.normalize().scale(motion.length()));
    }

    public void bounce() {
        ++this.bounceCount;
        this.targetSelectionTimer = 3;
        this.returnTimer -= 10;
    }

    public void selectNearbyTarget(ServerLevel level) {
        Entity owner = this.getOwner();
        if (owner != null) {
            List entities = level.getEntitiesOfClass(LivingEntity.class, this.getBoundingBox().inflate(30.0), target -> target != owner && target.isAlive() && !target.isAlliedTo(owner) && this.hasLineOfSight(level, (Entity)target));
            if (!entities.isEmpty() && this.forcedTarget != null) {
                this.forcedTarget = entities.stream().min(Comparator.comparingDouble(e -> e.distanceToSqr((Entity)this))).get();
            }
            if (this.forcedTarget != null) {
                double speed = this.getDeltaMovement().length();
                for (int i = 0; i < 3; ++i) {
                    Vec3 distance = this.forcedTarget.position().subtract(this.position());
                    Vec3 newMotion = this.getDeltaMovement().lerp(distance.normalize(), (double)0.3f);
                    this.setDeltaMovement(newMotion.normalize());
                }
                this.setDeltaMovement(this.getDeltaMovement().scale(speed));
            }
        }
    }

    public void homeIn(ServerLevel level) {
        Vec3 motion = this.getDeltaMovement();
        Entity owner = this.getOwner();
        if (owner != null && this.forcedTarget != null && this.forcedTarget.isAlive()) {
            LivingEntity target = this.forcedTarget;
            Vec3 targetPos = target.position().add(0.0, (double)target.getBbHeight() / 2.0, 0.0);
            Vec3 toTarget = targetPos.subtract(this.position());
            double speed = motion.length();
            Vec3 nextPosition = this.position().add(motion);
            double currentDistSq = target.distanceToSqr(this.position());
            double nextDistSq = target.distanceToSqr(nextPosition);
            if (nextDistSq > currentDistSq) {
                return;
            }
            Vec3 newDirection = toTarget.normalize();
            double dot = motion.normalize().dot(newDirection);
            if (dot < 0.1) {
                return;
            }
            if (newDirection.lengthSqr() == 0.0) {
                newDirection = newDirection.add(0.01, 0.0, 0.0);
            }
            float angleScalar = Math.max((Math.abs(0.5f - (float)dot) - 0.2f) * 2.5f, 0.4f);
            float factor = 0.125f * angleScalar;
            double x = Mth.clampedLerp((double)motion.x, (double)newDirection.x, (double)factor);
            double y = Mth.clampedLerp((double)motion.y, (double)newDirection.y, (double)factor);
            double z = Mth.clampedLerp((double)motion.z, (double)newDirection.z, (double)factor);
            this.setDeltaMovement(new Vec3(x, y, z).normalize().scale(speed));
        }
    }

    public boolean hasLineOfSight(ServerLevel level, Entity target) {
        Vec3 wrathPosition = new Vec3(this.getX(), this.getEyeY(), this.getZ());
        Vec3 targetPosition = new Vec3(target.getX(), target.getEyeY(), target.getZ());
        BlockHitResult clipResult = level.clip(new ClipContext(wrathPosition, targetPosition, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)this));
        return clipResult.getType().equals((Object)HitResult.Type.MISS);
    }

    public float getVisualEffectScalar() {
        float effectScalar = 1.0f;
        if (this.age < 8) {
            effectScalar = (float)this.age / 8.0f;
        }
        return effectScalar;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void spawnParticles() {
        Level level = this.level();
        float scalar = this.getVisualEffectScalar();
        Vec3 norm = this.getDeltaMovement().normalize().scale((double)0.05f);
        SpiritHolder spirit = VeilDaggerItem.getVeilDaggerSpirit();
        ParticleEffectSpawner lightSpecs = SpiritLightSpecs.spiritLightSpecs((Level)level, (Vec3)this.position(), (SpiritLike)spirit);
        lightSpecs.getBuilder().setRenderTarget(LodestoneRenderHandler.LATE_DEFERRED_RENDER).multiplyLifetime(5.0f).setMotion(norm);
        lightSpecs.getBloomBuilder().setRenderTarget(LodestoneRenderHandler.LATE_DEFERRED_RENDER).multiplyLifetime(5.0f).setMotion(norm);
        lightSpecs.spawnParticles();
        Consumer<LodestoneWorldParticle> behavior = p -> p.setParticleSpeed(p.getParticleSpeed().scale((double)0.95f));
        float count = 1.0f + (float)this.getDeltaMovement().length() * 3.0f;
        int i = 0;
        while ((float)i < count) {
            spirit = MalumSpiritTypes.INFERNAL_SPIRIT;
            Vec3 position = this.getPosition((float)i / count);
            int r = RandomHelper.randomBetween((RandomSource)this.random, (int)30, (int)100);
            int g = RandomHelper.randomBetween((RandomSource)this.random, (int)0, (int)20);
            int b = RandomHelper.randomBetween((RandomSource)this.random, (int)0, (int)20);
            Color redBlack = new Color(r, g, b);
            WorldParticleBuilder.create((Supplier)MalumParticles.SHINE).setBehavior((LodestoneParticleBehavior)DirectionalParticleBehavior.directional((Vec3)this.getDeltaMovement().normalize())).setTransparencyData((GenericParticleDataWrapper)GenericParticleData.create((float)(0.9f * scalar), (float)(0.7f * scalar), (float)0.0f).setEasing(Easing.SINE_IN_OUT, Easing.SINE_IN).build()).setSpinData((SpinParticleDataWrapper)SpinParticleData.createRandomDirection((RandomSource)this.random, (float)RandomHelper.randomBetween((RandomSource)this.random, (float)0.25f, (float)0.5f)).randomSpinOffset(this.random).build()).setScaleData((GenericParticleDataWrapper)GenericParticleData.create((float)(0.2f * scalar), (float)(0.4f * scalar)).setEasing(Easing.SINE_IN_OUT).build()).setSpritePicker(SimpleParticleOptions.ParticleSpritePicker.WITH_AGE).setRenderTarget(LodestoneRenderHandler.LATE_DEFERRED_RENDER).setColorData((ColorParticleDataWrapper)spirit.createColorData().build()).setLifetime(Math.min(5 + this.age * 2, 20)).addTickActor(behavior).enableForcedSpawn().enableNoClip().spawn(level, position.x, position.y, position.z).setScaleData((GenericParticleDataWrapper)GenericParticleData.create((float)(0.3f * scalar), (float)(0.5f * scalar)).setEasing(Easing.SINE_IN_OUT).build()).setTransparencyData((GenericParticleDataWrapper)GenericParticleData.create((float)(0.6f * scalar), (float)(0.5f * scalar), (float)0.0f).setEasing(Easing.SINE_IN_OUT, Easing.SINE_IN).build()).setRenderType((ParticleRenderType)LodestoneWorldParticleRenderType.LUMITRANSPARENT).setColorData((ColorParticleDataWrapper)VeilDaggerItem.getVeilDaggerSpirit().createColorData().build()).spawn(level, position.x, position.y, position.z);
            ++i;
        }
    }

    public boolean isNoGravity() {
        return false;
    }

    public float getPickRadius() {
        return 4.0f;
    }

    public boolean fireImmune() {
        return true;
    }

    public boolean ignoreExplosion(Explosion explosion) {
        return true;
    }
}

