/*
 * Decompiled with CFR 0.152.
 */
package com.strawberry.gaze.client.screen.codex.pages;

import com.mojang.blaze3d.vertex.PoseStack;
import com.sammy.malum.client.screen.codex.helper.CodexItemHelper;
import com.sammy.malum.client.screen.codex.helper.CodexTextHelper;
import com.sammy.malum.client.screen.codex.pages.BookPage;
import com.sammy.malum.client.screen.codex.screens.AbstractMalumCodexScreen;
import com.sammy.malum.client.screen.codex.screens.CodexEntryScreen;
import com.strawberry.gaze.Config;
import com.strawberry.gaze.GazeMod;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.InventoryScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.stats.Stats;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import org.joml.Quaternionf;
import org.joml.Vector3f;

public class MobSpiritPage
extends BookPage {
    private final LivingEntity mobType;
    private final List<ItemStack> spiritDrops;

    public MobSpiritPage(LivingEntity mobType, List<ItemStack> spiritDrops) {
        super(GazeMod.gazePath("textures/gui/book/pages/mob_spirit_page.png"));
        this.mobType = mobType;
        this.spiritDrops = spiritDrops;
    }

    public void render(CodexEntryScreen screen, GuiGraphics guiGraphics, int left, int top, int mouseX, int mouseY, float partialTicks, boolean isRepeat) {
        Minecraft mc = Minecraft.getInstance();
        PoseStack poseStack = guiGraphics.pose();
        int kills = mc.player.getStats().getValue(Stats.ENTITY_KILLED.get((Object)this.mobType.getType()));
        if (!Config.bestiary) {
            kills = 1;
        }
        MutableComponent headline = kills > 0 ? this.mobType.getType().getDescription() : Component.translatable((String)"gaze.gui.bestiary.unknown");
        CodexTextHelper.renderHeadline((GuiGraphics)guiGraphics, (Component)headline, (int)left, (int)top);
        if (kills > 0) {
            assert (mc.level != null);
            LivingEntity entity = (LivingEntity)this.mobType.getType().create((Level)mc.level);
            if (entity != null) {
                entity.yBodyRot = 0.0f;
                entity.yBodyRotO = 0.0f;
                entity.yHeadRot = 0.0f;
                entity.yHeadRotO = 0.0f;
                entity.xRotO = 0.0f;
                entity.setYRot(0.0f);
                entity.yRotO = 0.0f;
                Quaternionf rotation = new Quaternionf().rotateY((float)Math.toRadians(10.0)).rotateX((float)Math.toRadians(180.0));
                float entityHeight = entity.getBbHeight();
                float entityWidth = entity.getBbWidth();
                float scale = 40.0f;
                if (entityHeight > 3.0f) {
                    scale = 40.0f / (entityHeight / 2.0f);
                }
                float baseX = left + 70;
                float baseY = top + 90;
                float yOffset = entityHeight * 10.0f;
                float xOffset = entityWidth * 5.0f;
                if (entityHeight > 3.0f) {
                    yOffset = entityHeight * scale / 2.0f;
                }
                InventoryScreen.renderEntityInInventory((GuiGraphics)guiGraphics, (float)(baseX - xOffset), (float)(baseY + yOffset), (float)scale, (Vector3f)new Vector3f(0.0f, 0.0f, 0.0f), (Quaternionf)rotation, null, (LivingEntity)entity);
            }
        } else {
            guiGraphics.drawCenteredString(mc.font, "???", left + 70, top + 80, 0x555555);
        }
        if (kills > 0) {
            int dropX = left + 15;
            int dropY = top + 152;
            for (ItemStack stack : this.spiritDrops) {
                CodexItemHelper.renderItem((AbstractMalumCodexScreen)screen, (GuiGraphics)guiGraphics, (ItemStack)stack, (int)dropX, (int)dropY, (int)mouseX, (int)mouseY);
                dropX += 20;
            }
        }
    }

    public boolean isValid() {
        return this.mobType != null;
    }
}

