/*
 * Decompiled with CFR 0.152.
 */
package dev.corgitaco.featurerecycler;

import com.mojang.logging.LogUtils;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import it.unimi.dsi.fastutil.objects.Reference2ObjectLinkedOpenHashMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.FeatureSorter;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import org.slf4j.Logger;

public class FeatureRecycler {
    public static final String MOD_ID = "featurerecycler";
    public static final Logger LOGGER = LogUtils.getLogger();

    public static void init() {
    }

    public static <T extends Holder<Biome>> List<FeatureSorter.StepFeatureData> recycle(List<T> biomes, Function<T, List<HolderSet<PlacedFeature>>> toFeatueSetFunction) {
        long startTime = System.currentTimeMillis();
        LOGGER.info("Starting feature recycler...");
        int crashesPrevented = 0;
        ArrayList<Reference2ObjectLinkedOpenHashMap> biomeTracker = new ArrayList<Reference2ObjectLinkedOpenHashMap>();
        GenerationStep.Decoration[] values = GenerationStep.Decoration.values();
        for (int i = 0; i < values.length; ++i) {
            biomeTracker.add(new Reference2ObjectLinkedOpenHashMap());
        }
        for (Holder holder : biomes) {
            List<HolderSet<PlacedFeature>> features = toFeatueSetFunction.apply(holder);
            for (int i = 0; i < features.size(); ++i) {
                HolderSet<PlacedFeature> feature = features.get(i);
                ((Map)biomeTracker.get(i)).put(holder, new ArrayList(feature.stream().toList()));
            }
        }
        for (Map map : biomeTracker) {
            for (int biomeIdx = 0; biomeIdx < biomes.size(); ++biomeIdx) {
                Holder biome = (Holder)biomes.get(biomeIdx);
                List currentList = (List)map.get(biome);
                if (currentList == null) continue;
                for (int currentHolderIndex = 0; currentHolderIndex < currentList.size(); ++currentHolderIndex) {
                    Holder currentHolder = (Holder)currentList.get(currentHolderIndex);
                    for (int nextHolderIndex = currentHolderIndex + 1; nextHolderIndex < currentList.size(); ++nextHolderIndex) {
                        Holder nextHolder = (Holder)currentList.get(nextHolderIndex);
                        int currentFeatureIDX = -1;
                        int nextFeatureIDX = -1;
                        Holder biomeRuleSetter = null;
                        for (int previousBiomeIdx = 0; previousBiomeIdx < biomeIdx - 1; ++previousBiomeIdx) {
                            Holder previousBiome = (Holder)biomes.get(previousBiomeIdx);
                            List previousBiomeStageData = (List)map.get(previousBiome);
                            if (previousBiomeStageData == null) continue;
                            if (currentFeatureIDX >= 0 && nextFeatureIDX >= 0) break;
                            int previousBiomeCurrentFeatureIDX = -1;
                            int previousBiomeNextFeatureIDX = -1;
                            for (int previousBiomeHolderIdx = 0; previousBiomeHolderIdx < previousBiomeStageData.size(); ++previousBiomeHolderIdx) {
                                Holder previousBiomePlacedFeatureHolder = (Holder)previousBiomeStageData.get(previousBiomeHolderIdx);
                                if (previousBiomePlacedFeatureHolder == currentHolder) {
                                    previousBiomeCurrentFeatureIDX = previousBiomeHolderIdx;
                                }
                                if (previousBiomePlacedFeatureHolder == nextHolder) {
                                    previousBiomeNextFeatureIDX = previousBiomeHolderIdx;
                                }
                                if (previousBiomeCurrentFeatureIDX >= 0 && previousBiomeNextFeatureIDX >= 0) break;
                            }
                            currentFeatureIDX = previousBiomeCurrentFeatureIDX;
                            nextFeatureIDX = previousBiomeNextFeatureIDX;
                            biomeRuleSetter = previousBiome;
                        }
                        if (currentFeatureIDX < 0 || nextFeatureIDX < 0 || currentFeatureIDX <= nextFeatureIDX) continue;
                        ResourceLocation currentBiomeLocation = biome.unwrapKey().isEmpty() ? null : ((ResourceKey)biome.unwrapKey().orElseThrow()).location();
                        String currentBiomeName = currentBiomeLocation == null ? "???" : currentBiomeLocation.toString();
                        String currentFeatureName = currentHolder.unwrapKey().isEmpty() ? "???" : ((ResourceKey)currentHolder.unwrapKey().orElseThrow()).location().toString();
                        String nextFeatureName = nextHolder.unwrapKey().isEmpty() ? "???" : ((ResourceKey)nextHolder.unwrapKey().orElseThrow()).location().toString();
                        ResourceLocation ruleSetterLocation = biomeRuleSetter.unwrapKey().isEmpty() ? null : ((ResourceKey)biomeRuleSetter.unwrapKey().orElseThrow()).location();
                        String biomeRuleSetterName = ruleSetterLocation == null ? "???" : ruleSetterLocation.toString();
                        LOGGER.warn("Moved placed feature \"%s\" from index %d to index %d for biome \"%s\". Placed Feature index rules set by biome \"%s\".".formatted(currentFeatureName, currentHolderIndex, nextHolderIndex, currentBiomeName, biomeRuleSetterName));
                        LOGGER.warn("Moved placed feature \"%s\" from index %d to index %d for biome \"%s\". Placed Feature index rules set by biome \"%s\".".formatted(nextFeatureName, nextHolderIndex, currentHolderIndex, currentBiomeName, biomeRuleSetterName));
                        LOGGER.warn("Just prevented a crash between %s and %s! Please report the issues to their respective issue trackers.".formatted(currentBiomeLocation == null ? "???" : currentBiomeLocation.getNamespace(), ruleSetterLocation == null ? "???" : ruleSetterLocation.getNamespace()));
                        ++crashesPrevented;
                        currentList.set(currentHolderIndex, nextHolder);
                        currentList.set(nextHolderIndex, currentHolder);
                    }
                }
            }
        }
        ArrayList<FeatureSorter.StepFeatureData> steps = new ArrayList<FeatureSorter.StepFeatureData>();
        biomeTracker.forEach(stepData -> {
            ArrayList<PlacedFeature> organizedFeatures = new ArrayList<PlacedFeature>();
            Object2IntOpenHashMap indexGetter = new Object2IntOpenHashMap();
            int idx = 0;
            for (List value : stepData.values()) {
                for (Holder holder : value) {
                    organizedFeatures.add((PlacedFeature)holder.value());
                    indexGetter.put((Object)((PlacedFeature)holder.value()), idx);
                    ++idx;
                }
            }
            steps.add(new FeatureSorter.StepFeatureData(organizedFeatures, arg_0 -> ((Object2IntOpenHashMap)indexGetter).getInt(arg_0)));
        });
        LOGGER.info("Finished recycling features. Took %dms".formatted(System.currentTimeMillis() - startTime));
        if (crashesPrevented > 0) {
            LOGGER.info("Feature Recycler just prevented %d crashes!".formatted(crashesPrevented));
        }
        return steps;
    }
}

