/*
 * Decompiled with CFR 0.152.
 */
package fuzs.stoneworks.data;

import fuzs.puzzleslib.api.data.v2.AbstractRecipeProvider;
import fuzs.puzzleslib.api.data.v2.core.DataProviderContext;
import fuzs.stoneworks.world.block.variant.StoneBlockVariant;
import fuzs.stoneworks.world.block.variant.StoneVariantsProvider;
import java.util.Arrays;
import java.util.stream.Collectors;
import net.minecraft.advancements.Criterion;
import net.minecraft.advancements.critereon.InventoryChangeTrigger;
import net.minecraft.advancements.critereon.ItemPredicate;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.data.recipes.RecipeProvider;
import net.minecraft.data.recipes.SingleItemRecipeBuilder;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;

public class ModRecipeProvider
extends AbstractRecipeProvider {
    public ModRecipeProvider(DataProviderContext context) {
        super(context);
    }

    public void addRecipes(RecipeOutput recipeOutput) {
        for (StoneBlockVariant variant : StoneVariantsProvider.getStoneBlockVariants().toList()) {
            Block baseBlock = variant.stoneType().getBaseBlock(variant.blockVariant());
            ModRecipeProvider.stonecutterResultFromBase((RecipeOutput)recipeOutput, (RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)variant.block(), (ItemLike)baseBlock);
            if (!variant.blockVariant().supportsAdditionalBlocks()) continue;
            Ingredient ingredient = baseBlock != variant.block() ? Ingredient.of((ItemLike[])new ItemLike[]{baseBlock, variant.block()}) : Ingredient.of((ItemLike[])new ItemLike[]{baseBlock});
            ModRecipeProvider.stonecutterResultFromBase(recipeOutput, RecipeCategory.BUILDING_BLOCKS, (ItemLike)variant.stairs(), ingredient);
            ModRecipeProvider.stonecutterResultFromBase(recipeOutput, RecipeCategory.BUILDING_BLOCKS, (ItemLike)variant.slab(), ingredient, 2);
            ModRecipeProvider.stonecutterResultFromBase(recipeOutput, RecipeCategory.BUILDING_BLOCKS, (ItemLike)variant.wall(), ingredient);
        }
    }

    public static void stonecutterResultFromBase(RecipeOutput recipeOutput, RecipeCategory category, ItemLike result, Ingredient material) {
        ModRecipeProvider.stonecutterResultFromBase(recipeOutput, category, result, material, 1);
    }

    public static void stonecutterResultFromBase(RecipeOutput recipeOutput, RecipeCategory category, ItemLike result, Ingredient material, int resultCount) {
        SingleItemRecipeBuilder.stonecutting((Ingredient)material, (RecipeCategory)category, (ItemLike)result, (int)resultCount).unlockedBy(ModRecipeProvider.getHasName(material), ModRecipeProvider.has(material)).save(recipeOutput, ModRecipeProvider.getConversionRecipeName(result, material) + "_stonecutting");
    }

    public static String getHasName(Ingredient ingredient) {
        return "has_" + ModRecipeProvider.getItemName(ingredient);
    }

    public static Criterion<InventoryChangeTrigger.TriggerInstance> has(Ingredient ingredient) {
        return ModRecipeProvider.inventoryTrigger((ItemPredicate[])new ItemPredicate[]{ItemPredicate.Builder.item().of((ItemLike[])Arrays.stream(ingredient.getItems()).map(ItemStack::getItem).toArray(ItemLike[]::new)).build()});
    }

    public static String getConversionRecipeName(ItemLike result, Ingredient ingredient) {
        return ModRecipeProvider.getItemName((ItemLike)result) + "_from_" + ModRecipeProvider.getItemName(ingredient);
    }

    public static String getItemName(Ingredient ingredient) {
        return Arrays.stream(ingredient.getItems()).map(ItemStack::getItem).map(RecipeProvider::getItemName).collect(Collectors.joining("_or_"));
    }
}

