/*
 * Decompiled with CFR 0.152.
 */
package net.acetheeldritchking.aces_spell_utils.utils;

import io.redspace.ironsspellbooks.api.magic.SpellSelectionManager;
import io.redspace.ironsspellbooks.api.registry.SpellRegistry;
import io.redspace.ironsspellbooks.api.spells.AbstractSpell;
import io.redspace.ironsspellbooks.api.spells.CastSource;
import io.redspace.ironsspellbooks.api.spells.CastType;
import io.redspace.ironsspellbooks.api.spells.SpellData;
import io.redspace.ironsspellbooks.capabilities.magic.MagicManager;
import io.redspace.ironsspellbooks.player.ClientMagicData;
import io.redspace.ironsspellbooks.util.TooltipsUtils;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import net.acetheeldritchking.aces_spell_utils.utils.ASTags;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TextColor;
import net.minecraft.tags.TagKey;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import org.joml.Vector3f;
import top.theillusivec4.curios.api.CuriosApi;

public class ASUtils {
    public static boolean hasCurio(Player player, Item item) {
        return CuriosApi.getCuriosHelper().findEquippedCurio(item, (LivingEntity)player).isPresent();
    }

    public static boolean isLongAnimCast(AbstractSpell spell) {
        return spell.getCastType() == CastType.LONG;
    }

    public static boolean isContAnimCast(AbstractSpell spell) {
        return spell.getCastType() == CastType.CONTINUOUS;
    }

    public static List<AbstractSpell> getSpellsFromTag(TagKey<AbstractSpell> tag) {
        ArrayList<AbstractSpell> list = new ArrayList<AbstractSpell>();
        for (AbstractSpell spell : SpellRegistry.getEnabledSpells()) {
            SpellRegistry.REGISTRY.getHolder(spell.getSpellResource()).ifPresent(s -> {
                if (s.is(tag)) {
                    list.add(spell);
                }
            });
        }
        return list;
    }

    public static void spawnParticlesInCircle(int count, float radius, float yHeight, float particleSpeed, LivingEntity entity, ParticleOptions particleTypes) {
        for (int i = 0; i < count; ++i) {
            double theta = Math.toRadians(360 / count) * (double)i;
            double x = Math.cos(theta) * (double)radius;
            double z = Math.sin(theta) * (double)radius;
            MagicManager.spawnParticles((Level)entity.level(), (ParticleOptions)particleTypes, (double)(entity.position().x + x), (double)(entity.position().y + (double)yHeight), (double)(entity.position().z + z), (int)1, (double)0.0, (double)0.0, (double)0.0, (double)particleSpeed, (boolean)false);
        }
    }

    public static void spawnParticlesInRing(int count, float radius1, float radius2, float radius3, float yHeight, float particleSpeed, LivingEntity entity, ParticleOptions particleTypes) {
        double z;
        double x;
        double theta;
        int i;
        for (i = 0; i < count; ++i) {
            theta = Math.toRadians(360 / count) * (double)i;
            x = Math.cos(theta) * (double)radius1;
            z = Math.sin(theta) * (double)radius1;
            MagicManager.spawnParticles((Level)entity.level(), (ParticleOptions)particleTypes, (double)(entity.position().x + x), (double)(entity.position().y + (double)yHeight), (double)(entity.position().z + z), (int)1, (double)0.0, (double)0.0, (double)0.0, (double)particleSpeed, (boolean)false);
        }
        for (i = 0; i < count; ++i) {
            theta = Math.toRadians(360 / count) * (double)i;
            x = Math.cos(theta) * (double)radius2;
            z = Math.sin(theta) * (double)radius2;
            MagicManager.spawnParticles((Level)entity.level(), (ParticleOptions)particleTypes, (double)(entity.position().x + x), (double)(entity.position().y + (double)yHeight), (double)(entity.position().z + z), (int)1, (double)0.0, (double)0.0, (double)0.0, (double)particleSpeed, (boolean)false);
        }
        for (i = 0; i < count; ++i) {
            theta = Math.toRadians(360 / count) * (double)i;
            x = Math.cos(theta) * (double)radius3;
            z = Math.sin(theta) * (double)radius3;
            MagicManager.spawnParticles((Level)entity.level(), (ParticleOptions)particleTypes, (double)(entity.position().x + x), (double)(entity.position().y + (double)yHeight), (double)(entity.position().z + z), (int)1, (double)0.0, (double)0.0, (double)0.0, (double)particleSpeed, (boolean)false);
        }
    }

    public static String convertTicksToTime(int ticks) {
        int totalSeconds = ticks / 20;
        int minutes = totalSeconds / 60;
        int seconds = totalSeconds % 60;
        return String.format("%02d:%02d", minutes, seconds);
    }

    public static double getEyeHeight(LivingEntity entity) {
        return entity.getY() + (double)entity.getEyeHeight() - 0.2;
    }

    public static boolean isValidUnlockItemInInventory(Item item, Player player) {
        for (int i = 0; i < player.getInventory().getContainerSize(); ++i) {
            ItemStack itemStack = player.getInventory().getItem(i);
            if (itemStack.getItem() != item) continue;
            return true;
        }
        return false;
    }

    public static boolean isValidConsumableUnlockItemInInventory(Item item, Player player) {
        for (int i = 0; i < player.getInventory().getContainerSize(); ++i) {
            ItemStack itemStack = player.getInventory().getItem(i);
            if (itemStack.getItem() != item) continue;
            itemStack.shrink(1);
            return true;
        }
        return false;
    }

    public static float getDamageForAttributes(AbstractSpell spell, LivingEntity entity, int spellLevel, Holder<Attribute> attr1, float modifier) {
        double attrValue1 = entity.getAttributeValue(attr1);
        float damage = (float)((double)modifier * ((double)spell.getSpellPower(spellLevel, (Entity)entity) + attrValue1));
        return damage;
    }

    public static float getDamageForAttributes(AbstractSpell spell, LivingEntity entity, int spellLevel, Holder<Attribute> attr1, Holder<Attribute> attr2, float modifier) {
        double attrValue1 = entity.getAttributeValue(attr1);
        double attrValue2 = entity.getAttributeValue(attr2);
        float damage = (float)((double)modifier * ((double)spell.getSpellPower(spellLevel, (Entity)entity) + attrValue1 + attrValue2));
        return damage;
    }

    public static float getDamageForAttributes(AbstractSpell spell, LivingEntity entity, int spellLevel, Holder<Attribute> attr1, Holder<Attribute> attr2, Holder<Attribute> attr3, float modifier) {
        double attrValue1 = entity.getAttributeValue(attr1);
        double attrValue2 = entity.getAttributeValue(attr2);
        double attrValue3 = entity.getAttributeValue(attr3);
        float damage = (float)((double)modifier * ((double)spell.getSpellPower(spellLevel, (Entity)entity) + attrValue1 + attrValue2 + attrValue3));
        return damage;
    }

    public static boolean isUnderTheSun(Level level, LivingEntity entity) {
        if (level.isDay() && !level.isClientSide) {
            boolean flag;
            float light = entity.getLightLevelDependentMagicValue();
            BlockPos blockPos = BlockPos.containing((double)entity.getX(), (double)entity.getEyeY(), (double)entity.getZ());
            boolean bl = flag = entity.isInWaterRainOrBubble() || entity.isInPowderSnow || entity.wasInPowderSnow;
            if (light > 0.5f && !flag && level.canSeeSky(blockPos)) {
                return true;
            }
        }
        return false;
    }

    public static boolean isBossEntity(EntityType<?> entity) {
        return entity.is(ASTags.BOSS_LIKE_ENTITES);
    }

    public static Component rainbowName(String baseName, float speed) {
        MutableComponent rainbowName = Component.literal((String)"");
        Minecraft mc = Minecraft.getInstance();
        long ticks = mc.level != null ? mc.level.getGameTime() : 0L;
        for (int i = 0; i < baseName.length(); ++i) {
            float hue = ((float)(i * 40) + (float)ticks * speed) % 360.0f / 360.0f;
            int rgb = Color.HSBtoRGB(hue, 1.0f, 1.0f);
            String hex = String.format("#%06X", 0xFFFFFF & rgb);
            TextColor color = (TextColor)TextColor.parseColor((String)hex).getOrThrow();
            rainbowName = rainbowName.append((Component)Component.literal((String)String.valueOf(baseName.charAt(i))).withStyle(style -> style.withColor(color)));
        }
        return rainbowName;
    }

    public static Vector3f rbgToVector3F(int r, int g, int b) {
        float rf = (float)r / 255.0f;
        float gf = (float)g / 255.0f;
        float bf = (float)b / 255.0f;
        Vector3f colorRGB = new Vector3f(rf, gf, bf);
        return colorRGB;
    }

    public static float basicDamageCap(float amount, float min, float max) {
        return Mth.clamp((float)amount, (float)min, (float)max);
    }

    public static void handleCastingImplementTooltip(ItemStack stack, LocalPlayer player, List<Component> lines, boolean advanced) {
        SpellSelectionManager.SelectionOption spellSlot = ClientMagicData.getSpellSelectionManager().getSelection();
        if (spellSlot != null && spellSlot.spellData != SpellData.EMPTY) {
            List addLines = TooltipsUtils.formatActiveSpellTooltip((ItemStack)stack, (SpellData)spellSlot.spellData, (CastSource)spellSlot.getCastSource(), (LocalPlayer)player);
            addLines.add(1, Component.translatable((String)"tooltip.irons_spellbooks.casting_implement_tooltip").withStyle(ChatFormatting.GRAY));
            addLines.set(2, Component.literal((String)" ").append((Component)addLines.get(2)));
            addLines.add(Component.literal((String)" ").append((Component)Component.translatable((String)"tooltip.irons_spellbooks.press_to_cast_active", (Object[])new Object[]{Component.keybind((String)"key.use")}).withStyle(ChatFormatting.GOLD)));
            int i = advanced ? TooltipsUtils.indexOfAdvancedText(lines, (ItemStack)stack) : lines.size();
            lines.addAll(i < 0 ? lines.size() : i, addLines);
        }
    }

    public static ChunkPos getChunkPos(BlockPos blockPos) {
        return new ChunkPos(blockPos.getX() >> 4, blockPos.getZ() >> 4);
    }
}

