/*
 * Decompiled with CFR 0.152.
 */
package net.acetheeldritchking.aces_spell_utils.events;

import io.redspace.ironsspellbooks.api.magic.MagicData;
import io.redspace.ironsspellbooks.api.magic.SpellSelectionManager;
import io.redspace.ironsspellbooks.api.registry.AttributeRegistry;
import io.redspace.ironsspellbooks.api.spells.SpellData;
import io.redspace.ironsspellbooks.capabilities.magic.MagicManager;
import io.redspace.ironsspellbooks.damage.SpellDamageSource;
import io.redspace.ironsspellbooks.entity.spells.AbstractMagicProjectile;
import io.redspace.ironsspellbooks.network.SyncManaPacket;
import io.redspace.ironsspellbooks.player.ClientMagicData;
import net.acetheeldritchking.aces_spell_utils.AcesSpellUtils;
import net.acetheeldritchking.aces_spell_utils.items.weapons.MagicGunItem;
import net.acetheeldritchking.aces_spell_utils.registries.ASAttributeRegistry;
import net.acetheeldritchking.aces_spell_utils.utils.ASTags;
import net.acetheeldritchking.aces_spell_utils.utils.ASUtils;
import net.acetheeldritchking.aces_spell_utils.utils.AcesSpellUtilsConfig;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.food.FoodData;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.neoforged.bus.api.EventPriority;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.living.LivingDamageEvent;
import net.neoforged.neoforge.event.entity.living.LivingIncomingDamageEvent;
import net.neoforged.neoforge.event.entity.player.PlayerInteractEvent;
import net.neoforged.neoforge.network.PacketDistributor;

@EventBusSubscriber
public class AcesSpellUtilsServerEvents {
    @SubscribeEvent
    public static void onUseItem(PlayerInteractEvent.RightClickItem event) {
        MagicGunItem gunItem;
        Player player = event.getEntity();
        Level level = player.level();
        InteractionHand hand = event.getHand();
        ItemStack itemStack = player.getItemInHand(hand);
        ItemStack mainHand = player.getMainHandItem();
        Item item = itemStack.getItem();
        if (item instanceof MagicGunItem && !(gunItem = (MagicGunItem)item).isHeavyGun()) {
            String castingSlot;
            spellSelectionManager = new SpellSelectionManager(player);
            SpellSelectionManager.SelectionOption selectionOption = spellSelectionManager.getSelection();
            if (selectionOption == null || selectionOption.spellData.equals((Object)SpellData.EMPTY)) {
                return;
            }
            SpellData spellData = selectionOption.spellData;
            int spellLevel = spellData.getSpell().getLevelFor(spellData.getLevel(), (LivingEntity)player);
            if (level.isClientSide()) {
                if (ClientMagicData.isCasting()) {
                    event.setCancellationResult(InteractionResult.CONSUME);
                } else {
                    if (ClientMagicData.getPlayerMana() < spellData.getSpell().getManaCost(spellLevel) || ClientMagicData.getCooldowns().isOnCooldown(spellData.getSpell()) || !ClientMagicData.getSyncedSpellData((LivingEntity)player).isSpellLearned(spellData.getSpell())) {
                        return;
                    }
                    event.setCancellationResult(InteractionResult.CONSUME);
                }
            }
            String string = castingSlot = hand.ordinal() == 0 ? SpellSelectionManager.MAINHAND : SpellSelectionManager.OFFHAND;
            if (spellData.getSpell().attemptInitiateCast(itemStack, spellLevel, level, player, selectionOption.getCastSource(), true, castingSlot)) {
                event.setCancellationResult(InteractionResult.CONSUME);
            } else {
                event.setCancellationResult(InteractionResult.FAIL);
            }
            event.setCanceled(true);
        } else {
            spellSelectionManager = itemStack.getItem();
            if (spellSelectionManager instanceof MagicGunItem) {
                MagicGunItem gunItem2 = (MagicGunItem)spellSelectionManager;
                if (hand.equals((Object)InteractionHand.MAIN_HAND) && gunItem2.isHeavyGun()) {
                    spellSelectionManager = new SpellSelectionManager(player);
                    SpellSelectionManager.SelectionOption selectionOption = spellSelectionManager.getSelection();
                    if (selectionOption == null || selectionOption.spellData.equals((Object)SpellData.EMPTY)) {
                        return;
                    }
                    SpellData spellData = selectionOption.spellData;
                    int spellLevel = spellData.getSpell().getLevelFor(spellData.getLevel(), (LivingEntity)player);
                    if (level.isClientSide()) {
                        if (ClientMagicData.isCasting()) {
                            event.setCancellationResult(InteractionResult.CONSUME);
                        } else {
                            if (ClientMagicData.getPlayerMana() < spellData.getSpell().getManaCost(spellLevel) || ClientMagicData.getCooldowns().isOnCooldown(spellData.getSpell()) || !ClientMagicData.getSyncedSpellData((LivingEntity)player).isSpellLearned(spellData.getSpell())) {
                                return;
                            }
                            event.setCancellationResult(InteractionResult.CONSUME);
                        }
                    }
                    if (spellData.getSpell().attemptInitiateCast(itemStack, spellLevel, level, player, selectionOption.getCastSource(), true, SpellSelectionManager.MAINHAND)) {
                        event.setCancellationResult(InteractionResult.CONSUME);
                    } else {
                        event.setCancellationResult(InteractionResult.FAIL);
                    }
                    event.setCanceled(true);
                }
            }
        }
    }

    @SubscribeEvent
    public static void manaStealEvent(LivingDamageEvent.Post event) {
        Entity sourceEntity = event.getSource().getEntity();
        LivingEntity target = event.getEntity();
        Entity directEntity = event.getSource().getDirectEntity();
        if (!(sourceEntity instanceof LivingEntity)) {
            return;
        }
        LivingEntity livingEntity = (LivingEntity)sourceEntity;
        if (!(livingEntity instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer serverPlayer = (ServerPlayer)livingEntity;
        if (directEntity == null) {
            return;
        }
        if (!directEntity.getType().is(ASTags.MANA_STEAL_WHITELIST) && !directEntity.is((Entity)serverPlayer)) {
            return;
        }
        AttributeInstance hasManaSteal = serverPlayer.getAttribute(ASAttributeRegistry.MANA_STEAL);
        if (hasManaSteal == null) {
            return;
        }
        float manaStealAttr = (float)serverPlayer.getAttributeValue(ASAttributeRegistry.MANA_STEAL);
        int maxAttackerMana = (int)serverPlayer.getAttributeValue((Holder)AttributeRegistry.MAX_MANA);
        MagicData attackerPlayerMagicData = MagicData.getPlayerMagicData((LivingEntity)serverPlayer);
        if (manaStealAttr <= 0.0f) {
            return;
        }
        int addMana = (int)Math.min(manaStealAttr * event.getOriginalDamage() + attackerPlayerMagicData.getMana(), (float)maxAttackerMana);
        attackerPlayerMagicData.setMana((float)addMana);
        PacketDistributor.sendToPlayer((ServerPlayer)serverPlayer, (CustomPacketPayload)new SyncManaPacket(attackerPlayerMagicData), (CustomPacketPayload[])new CustomPacketPayload[0]);
        if (AcesSpellUtilsConfig.manaStealDrain && target instanceof ServerPlayer) {
            ServerPlayer serverTargetPlayer = (ServerPlayer)target;
            int maxTargetMana = (int)serverTargetPlayer.getAttributeValue((Holder)AttributeRegistry.MAX_MANA);
            MagicData targetPlayerMagicData = MagicData.getPlayerMagicData((LivingEntity)serverTargetPlayer);
            int subMana = (int)Math.min(manaStealAttr * event.getOriginalDamage() - attackerPlayerMagicData.getMana(), (float)maxAttackerMana);
            if (maxTargetMana <= 0) {
                return;
            }
            targetPlayerMagicData.setMana((float)subMana);
            PacketDistributor.sendToPlayer((ServerPlayer)serverPlayer, (CustomPacketPayload)new SyncManaPacket(targetPlayerMagicData), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
    }

    @SubscribeEvent
    public static void manaRendEvent(LivingIncomingDamageEvent event) {
        LivingEntity victim = event.getEntity();
        Entity attacker = event.getSource().getEntity();
        Entity directEntity = event.getSource().getDirectEntity();
        if (!(attacker instanceof LivingEntity)) {
            return;
        }
        LivingEntity livingEntity = (LivingEntity)attacker;
        if (directEntity == null) {
            return;
        }
        if (!directEntity.getType().is(ASTags.MANA_REND_WHITELIST) && !directEntity.is(attacker)) {
            return;
        }
        AttributeInstance hasManaRend = livingEntity.getAttribute(ASAttributeRegistry.MANA_REND);
        AttributeInstance targetHasMana = victim.getAttribute((Holder)AttributeRegistry.MAX_MANA);
        if (hasManaRend == null || targetHasMana == null) {
            return;
        }
        double manaRendAttr = livingEntity.getAttributeValue(ASAttributeRegistry.MANA_REND);
        double victimMaxMana = victim.getAttributeValue((Holder)AttributeRegistry.MAX_MANA);
        double victimBaseMana = victim.getAttributeBaseValue((Holder)AttributeRegistry.MAX_MANA);
        if (manaRendAttr <= 0.0 || victimMaxMana <= 0.0) {
            return;
        }
        double bonusManaFromBase = victimMaxMana / victimBaseMana;
        double step = bonusManaFromBase * 0.01;
        double totalExtraDamagerPercent = 1.0 + step * manaRendAttr;
        event.setAmount((float)((double)event.getAmount() * totalExtraDamagerPercent));
        AcesSpellUtils.LOGGER.debug("Old Damage amount: " + event.getOriginalAmount());
        AcesSpellUtils.LOGGER.debug("New Damage amount: " + event.getAmount());
    }

    @SubscribeEvent
    public static void goliathSlayerEvent(LivingIncomingDamageEvent event) {
        LivingEntity victim = event.getEntity();
        Entity attacker = event.getSource().getEntity();
        if (!(attacker instanceof LivingEntity)) {
            return;
        }
        LivingEntity livingEntity = (LivingEntity)attacker;
        AttributeInstance hasGoliathSlayer = livingEntity.getAttribute(ASAttributeRegistry.GOLIATH_SLAYER);
        if (hasGoliathSlayer == null) {
            return;
        }
        double goliathSlayerAttr = livingEntity.getAttributeValue(ASAttributeRegistry.GOLIATH_SLAYER);
        if (goliathSlayerAttr <= 0.0) {
            return;
        }
        if (!victim.getType().is(ASTags.BOSS_LIKE_ENTITES)) {
            return;
        }
        float baseDamage = event.getOriginalAmount();
        float bonusDamage = (float)((double)baseDamage * goliathSlayerAttr);
        float totalDamage = baseDamage + bonusDamage;
        event.setAmount(totalDamage);
        AcesSpellUtils.LOGGER.debug("OG Damage: " + baseDamage);
        AcesSpellUtils.LOGGER.debug("Bonus Damage: " + bonusDamage);
        AcesSpellUtils.LOGGER.debug("Total Damage: " + event.getAmount());
    }

    @SubscribeEvent
    public static void hungerStealEvent(LivingDamageEvent.Pre event) {
        Entity sourceEntity = event.getSource().getEntity();
        LivingEntity target = event.getEntity();
        if (!(sourceEntity instanceof LivingEntity)) {
            return;
        }
        LivingEntity livingEntity = (LivingEntity)sourceEntity;
        if (!(livingEntity instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer serverPlayer = (ServerPlayer)livingEntity;
        AttributeInstance hasHungerSteal = serverPlayer.getAttribute(ASAttributeRegistry.HUNGER_STEAL);
        if (hasHungerSteal == null) {
            return;
        }
        double hungerStealAttr = serverPlayer.getAttributeValue(ASAttributeRegistry.HUNGER_STEAL);
        if (hungerStealAttr <= 0.0) {
            return;
        }
        FoodData playerFood = serverPlayer.getFoodData();
        int foodLevel = playerFood.getFoodLevel();
        int addFood = (int)Math.max(hungerStealAttr + (double)foodLevel, (double)foodLevel);
        playerFood.setFoodLevel(addFood);
        if (target instanceof Player) {
            Player targetPlayer = (Player)target;
            FoodData targetFood = targetPlayer.getFoodData();
            int targetFoodLevel = playerFood.getFoodLevel();
            int subFood = (int)Math.min(hungerStealAttr - (double)targetFoodLevel, (double)targetFoodLevel);
            targetFood.setFoodLevel(subFood);
        }
    }

    @SubscribeEvent
    public static void spellResPenetrationEvent(LivingIncomingDamageEvent event) {
        LivingEntity victim = event.getEntity();
        Entity attacker = event.getSource().getEntity();
        if (!(attacker instanceof LivingEntity)) {
            return;
        }
        LivingEntity livingEntity = (LivingEntity)attacker;
        AttributeInstance hasSpellResPen = livingEntity.getAttribute(ASAttributeRegistry.SPELL_RES_PENETRATION);
        if (hasSpellResPen == null) {
            return;
        }
        double spellResPenAttr = livingEntity.getAttributeValue(ASAttributeRegistry.SPELL_RES_PENETRATION);
        double spellResAttr = victim.getAttributeValue((Holder)AttributeRegistry.SPELL_RESIST);
        if (spellResPenAttr <= 0.0) {
            return;
        }
        if (event.getSource() instanceof SpellDamageSource) {
            float baseDamage = event.getOriginalAmount();
            float bonusDamage = (float)((double)baseDamage * (spellResPenAttr + spellResAttr));
            float totalDamage = baseDamage + bonusDamage;
            event.setAmount(totalDamage);
            AcesSpellUtils.LOGGER.debug("OG Damage: " + baseDamage);
            AcesSpellUtils.LOGGER.debug("Bonus Damage: " + bonusDamage);
            AcesSpellUtils.LOGGER.debug("Total Damage: " + event.getAmount());
        }
    }

    @SubscribeEvent
    public static void evasiveEvent(LivingIncomingDamageEvent event) {
        LivingEntity victim = event.getEntity();
        Entity attacker = event.getSource().getEntity();
        if (!(victim instanceof LivingEntity)) {
            return;
        }
        LivingEntity livingEntity = victim;
        AttributeInstance hasEvasive = livingEntity.getAttribute(ASAttributeRegistry.EVASIVE);
        if (hasEvasive == null) {
            return;
        }
        double evasiveAttr = livingEntity.getAttributeValue(ASAttributeRegistry.EVASIVE);
        if (evasiveAttr <= 0.0) {
            return;
        }
        int postInvulTicks = event.getContainer().getPostAttackInvulnerabilityTicks();
        event.setInvulnerabilityTicks(postInvulTicks *= (int)evasiveAttr);
        AcesSpellUtils.LOGGER.debug("I Frames: " + livingEntity.invulnerableTime);
        if (!livingEntity.level().isClientSide()) {
            MagicManager.spawnParticles((Level)livingEntity.level(), (ParticleOptions)ParticleTypes.SMOKE, (double)livingEntity.getX(), (double)livingEntity.getY(), (double)livingEntity.getZ(), (int)25, (double)0.4, (double)0.8, (double)0.4, (double)0.03, (boolean)false);
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void magicDamageCriticalStrike(LivingIncomingDamageEvent event) {
        double magicCritDmg;
        LivingEntity victim = event.getEntity();
        Entity attacker = event.getSource().getEntity();
        Entity directEntity = event.getSource().getDirectEntity();
        if (!(attacker instanceof LivingEntity)) {
            return;
        }
        LivingEntity livingEntity = (LivingEntity)attacker;
        AttributeInstance hasMagicCritChance = livingEntity.getAttribute(ASAttributeRegistry.MAGIC_DAMAGE_CRIT_CHANCE);
        AttributeInstance hasMagicCritDmg = livingEntity.getAttribute(ASAttributeRegistry.MAGIC_DAMAGE_CRIT_DAMAGE);
        if (hasMagicCritChance == null) {
            return;
        }
        if (hasMagicCritDmg == null) {
            return;
        }
        double magicCritChance = livingEntity.getAttributeValue(ASAttributeRegistry.MAGIC_DAMAGE_CRIT_CHANCE);
        double baseMagicCritChance = livingEntity.getAttributeValue(ASAttributeRegistry.MAGIC_DAMAGE_CRIT_CHANCE);
        if (magicCritChance <= 0.05) {
            return;
        }
        if (magicCritDmg <= 1.0) {
            return;
        }
        if (event.getSource() instanceof SpellDamageSource) {
            RandomSource random = victim.getRandom();
            float damage = event.getAmount();
            for (magicCritDmg = livingEntity.getAttributeValue(ASAttributeRegistry.MAGIC_DAMAGE_CRIT_DAMAGE); (double)random.nextFloat() <= magicCritChance && magicCritDmg > 1.0; magicCritDmg *= (double)0.85f) {
                magicCritChance -= 1.0;
                damage += (float)((double)event.getAmount() * (magicCritDmg - 1.0));
            }
            if (damage > event.getAmount() && !attacker.level().isClientSide()) {
                AcesSpellUtils.LOGGER.debug("--CRIT!--");
                attacker.level().playLocalSound(victim.getX(), victim.getY(), victim.getZ(), SoundEvents.PLAYER_ATTACK_CRIT, SoundSource.PLAYERS, 1.0f, 1.0f, false);
                if (attacker instanceof Player) {
                    Player player = (Player)attacker;
                    player.crit((Entity)victim);
                } else {
                    ASUtils.spawnParticlesInCircle(16, 0.75f, 1.5f, 0.15f, victim, (ParticleOptions)ParticleTypes.CRIT);
                }
            }
            event.setAmount(damage);
            AcesSpellUtils.LOGGER.debug("OG Damage: " + event.getOriginalAmount());
            AcesSpellUtils.LOGGER.debug("Damage: " + damage);
            AcesSpellUtils.LOGGER.debug("Base Chance: " + baseMagicCritChance);
            AcesSpellUtils.LOGGER.debug("Current Chance: " + magicCritChance);
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void magicProjectileDamageCriticalStrike(LivingIncomingDamageEvent event) {
        double magicCritDmg;
        LivingEntity victim = event.getEntity();
        Entity attacker = event.getSource().getEntity();
        Entity directEntity = event.getSource().getDirectEntity();
        if (!(attacker instanceof LivingEntity)) {
            return;
        }
        LivingEntity livingEntity = (LivingEntity)attacker;
        if (!(directEntity instanceof AbstractMagicProjectile)) {
            return;
        }
        AttributeInstance hasMagicCritChance = livingEntity.getAttribute(ASAttributeRegistry.MAGIC_PROJECTILE_CRIT_CHANCE);
        AttributeInstance hasMagicCritDmg = livingEntity.getAttribute(ASAttributeRegistry.MAGIC_PROJECTILE_CRIT_DAMAGE);
        if (hasMagicCritChance == null) {
            return;
        }
        if (hasMagicCritDmg == null) {
            return;
        }
        double magicCritChance = livingEntity.getAttributeValue(ASAttributeRegistry.MAGIC_PROJECTILE_CRIT_CHANCE);
        double baseMagicCritChance = livingEntity.getAttributeValue(ASAttributeRegistry.MAGIC_PROJECTILE_CRIT_CHANCE);
        if (magicCritChance <= 0.05) {
            return;
        }
        if (magicCritDmg <= 1.0) {
            return;
        }
        if (event.getSource() instanceof SpellDamageSource && directEntity instanceof AbstractMagicProjectile) {
            RandomSource random = victim.getRandom();
            float damage = event.getAmount();
            for (magicCritDmg = livingEntity.getAttributeValue(ASAttributeRegistry.MAGIC_PROJECTILE_CRIT_DAMAGE); (double)random.nextFloat() <= magicCritChance && magicCritDmg > 1.0; magicCritDmg *= (double)0.85f) {
                magicCritChance -= 1.0;
                damage += (float)((double)event.getAmount() * (magicCritDmg - 1.0));
            }
            if (damage > event.getAmount() && !attacker.level().isClientSide()) {
                AcesSpellUtils.LOGGER.debug("--PROJ CRIT!--");
                attacker.level().playLocalSound(victim.getX(), victim.getY(), victim.getZ(), SoundEvents.PLAYER_ATTACK_CRIT, SoundSource.PLAYERS, 1.0f, 1.0f, false);
                if (attacker instanceof Player) {
                    Player player = (Player)attacker;
                    player.crit((Entity)victim);
                } else {
                    ASUtils.spawnParticlesInCircle(16, 0.75f, 1.5f, 0.15f, victim, (ParticleOptions)ParticleTypes.CRIT);
                }
            }
            event.setAmount(damage);
            AcesSpellUtils.LOGGER.debug("OG Damage: " + event.getOriginalAmount());
            AcesSpellUtils.LOGGER.debug("Damage: " + damage);
            AcesSpellUtils.LOGGER.debug("Base Chance: " + baseMagicCritChance);
            AcesSpellUtils.LOGGER.debug("Current Chance: " + magicCritChance);
        }
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public static void magicProjectileBonusDamage(LivingIncomingDamageEvent event) {
        LivingEntity victim = event.getEntity();
        Entity attacker = event.getSource().getEntity();
        Entity directEntity = event.getSource().getDirectEntity();
        if (!(attacker instanceof LivingEntity)) {
            return;
        }
        LivingEntity livingEntity = (LivingEntity)attacker;
        if (!(directEntity instanceof AbstractMagicProjectile)) {
            return;
        }
        AbstractMagicProjectile projectile = (AbstractMagicProjectile)directEntity;
        AttributeInstance hasMagicProjDmg = livingEntity.getAttribute(ASAttributeRegistry.MAGIC_PROJECTILE_DAMAGE);
        if (hasMagicProjDmg == null) {
            return;
        }
        double magicProjDmg = 1.0 + livingEntity.getAttributeValue(ASAttributeRegistry.MAGIC_PROJECTILE_DAMAGE);
        if (magicProjDmg <= 0.0) {
            return;
        }
        if (event.getSource() instanceof SpellDamageSource && directEntity instanceof AbstractMagicProjectile) {
            float baseDamage = event.getOriginalAmount();
            float totalDamage = (float)((double)baseDamage * magicProjDmg);
            event.setAmount(totalDamage);
            AcesSpellUtils.LOGGER.debug("OG Proj Damage: " + baseDamage);
            AcesSpellUtils.LOGGER.debug("Bonus Proj Damage: " + (double)baseDamage * (magicProjDmg - 1.0));
            AcesSpellUtils.LOGGER.debug("Total Proj Damage: " + event.getAmount());
        }
    }

    @SubscribeEvent
    public static void lifeRecovery(LivingDamageEvent.Post event) {
        LivingEntity victim = event.getEntity();
        Entity attacker = event.getSource().getEntity();
        if (!(attacker instanceof LivingEntity)) {
            return;
        }
        LivingEntity livingEntity = (LivingEntity)attacker;
        AttributeInstance hasLifeRecovery = livingEntity.getAttribute(ASAttributeRegistry.LIFE_RECOVERY);
        if (hasLifeRecovery == null) {
            return;
        }
        double lifeRecoveryAttr = livingEntity.getAttributeValue(ASAttributeRegistry.LIFE_RECOVERY);
        if (lifeRecoveryAttr <= 0.0) {
            return;
        }
        float MAX_HEALTH = livingEntity.getMaxHealth();
        float recoveryAmount = (float)((double)MAX_HEALTH * lifeRecoveryAttr);
        livingEntity.heal(recoveryAmount);
        AcesSpellUtils.LOGGER.debug("HP: " + livingEntity.getHealth());
        AcesSpellUtils.LOGGER.debug("Healed for: " + recoveryAmount);
    }
}

