/*
 * Decompiled with CFR 0.152.
 */
package net.acetheeldritchking.aces_spell_utils.entity.spells;

import io.redspace.ironsspellbooks.api.magic.MagicData;
import io.redspace.ironsspellbooks.entity.mobs.AntiMagicSusceptible;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import net.acetheeldritchking.aces_spell_utils.utils.ASUtils;
import net.acetheeldritchking.aces_spell_utils.utils.AcesSpellUtilsConfig;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerChunkCache;
import net.minecraft.server.level.TicketType;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.neoforged.neoforge.common.util.INBTSerializable;
import org.jetbrains.annotations.UnknownNullability;

public abstract class AbstractDomainEntity
extends Entity
implements AntiMagicSusceptible,
INBTSerializable<CompoundTag> {
    private static final EntityDataAccessor<Integer> RADIUS = SynchedEntityData.defineId(AbstractDomainEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final EntityDataAccessor<Integer> REFINEMENT = SynchedEntityData.defineId(AbstractDomainEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final EntityDataAccessor<Boolean> OPEN = SynchedEntityData.defineId(AbstractDomainEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Boolean> TRANSPORTED = SynchedEntityData.defineId(AbstractDomainEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Boolean> CLASHABLE = SynchedEntityData.defineId(AbstractDomainEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Boolean> CLASHING = SynchedEntityData.defineId(AbstractDomainEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Long> SPAWN_TIME = SynchedEntityData.defineId(AbstractDomainEntity.class, (EntityDataSerializer)EntityDataSerializers.LONG);
    private static final EntityDataAccessor<Integer> TIME_SPENT_CLASHING = SynchedEntityData.defineId(AbstractDomainEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final Map<AbstractDomainEntity, ArrayList<AbstractDomainEntity>> clashingWithMap = new HashMap<AbstractDomainEntity, ArrayList<AbstractDomainEntity>>();
    private static final Map<AbstractDomainEntity, Entity> ownerMap = new HashMap<AbstractDomainEntity, Entity>();
    private int spawnAnimTime = Integer.MAX_VALUE;

    public AbstractDomainEntity(EntityType<? extends Entity> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
        this.addClashingMapIfNecessary();
        this.setNoGravity(true);
        this.canUsePortal(false);
    }

    public void onActivation() {
        if (!this.level().isClientSide) {
            this.setSpawnTime(this.level().getGameTime());
        }
        if (!this.level().isClientSide()) {
            ServerChunkCache cache = this.getServer().getLevel(this.level().dimension()).getChunkSource();
            cache.addRegionTicket(TicketType.FORCED, ASUtils.getChunkPos(new BlockPos((int)this.position().x, (int)this.position().y, (int)this.position().z)), 20, (Object)ASUtils.getChunkPos(new BlockPos((int)this.position().x, (int)this.position().y, (int)this.position().z)), true);
        }
        this.addClashingMapIfNecessary();
        this.level().getEntitiesOfClass(AbstractDomainEntity.class, new AABB(this.position().subtract((double)this.getRadius() / 2.0, (double)this.getRadius() / 2.0, (double)this.getRadius() / 2.0), this.position().add((double)this.getRadius() / 2.0, (double)this.getRadius() / 2.0, (double)this.getRadius() / 2.0))).stream().forEach(e -> {
            if (e.distanceTo(this) < (float)this.getRadius() && !Objects.equals(e, (Object)this) && e.getClashable() && (e.getOwner() == null || this.getOwner() == null || !e.getOwner().equals((Object)this.getOwner()))) {
                if ((double)e.getRefinement() / (double)this.getRefinement() >= AcesSpellUtilsConfig.refinementDifference) {
                    this.destroyDomain();
                } else if ((double)this.getRefinement() / (double)e.getRefinement() >= AcesSpellUtilsConfig.refinementDifference) {
                    e.destroyDomain();
                } else if (this.getClashingWith() != null && e.getClashingWith() != null) {
                    if (!this.getClashingWith().contains(e)) {
                        clashingWithMap.get((Object)this).add((AbstractDomainEntity)((Object)e));
                    }
                    if (!e.getClashingWith().contains((Object)this)) {
                        e.getClashingWith().add(this);
                    }
                    this.setClashing(true);
                    e.setClashing(true);
                }
            }
        });
    }

    public void destroyDomain() {
        this.discard();
        if (clashingWithMap.get((Object)this) != null) {
            for (AbstractDomainEntity e : clashingWithMap.get((Object)this)) {
                if (!e.getClashingWith().contains((Object)this)) continue;
                e.getClashingWith().remove((Object)this);
            }
        }
        clashingWithMap.remove((Object)this);
    }

    private boolean canTransport() {
        return !this.isOpen() && !this.getTransported() && !this.isClashing() && this.tickCount > this.getSpawnAnimTime() && !this.isRemoved();
    }

    public void handleDomainClash(ArrayList<AbstractDomainEntity> opposingDomains) {
    }

    public void targetSureHit() {
        this.level().getEntitiesOfClass(Entity.class, new AABB(this.position().subtract((double)this.getRadius() / 2.0, (double)this.getRadius() / 2.0, (double)this.getRadius() / 2.0), this.position().add((double)this.getRadius() / 2.0, (double)this.getRadius() / 2.0, (double)this.getRadius() / 2.0))).stream().forEach(e -> {
            if (e.distanceTo((Entity)this) < (float)this.getRadius() && this.canTarget((Entity)e)) {
                this.handleSureHit((Entity)e);
            }
        });
    }

    public void handleSureHit(Entity e) {
    }

    public void addClashingMapIfNecessary() {
        if (clashingWithMap.get((Object)this) == null) {
            clashingWithMap.put(this, new ArrayList());
        }
    }

    public boolean canTarget(Entity e) {
        boolean shareOwner = false;
        if (e instanceof TamableAnimal) {
            TamableAnimal tame = (TamableAnimal)e;
            shareOwner = Objects.equals(tame.getOwner(), ((TamableAnimal)e).getOwner());
        }
        if (e instanceof Projectile) {
            Projectile proj = (Projectile)e;
            shareOwner = Objects.equals(proj.getOwner(), e);
        }
        return !Objects.equals(e, (Object)this) && !Objects.equals(e, this.getOwner()) && !shareOwner;
    }

    public void tick() {
        LivingEntity living;
        Entity entity;
        this.addClashingMapIfNecessary();
        if (this.tickCount == 1) {
            this.onActivation();
        }
        if ((entity = this.getOwner()) instanceof LivingEntity && (living = (LivingEntity)entity).isDeadOrDying()) {
            this.destroyDomain();
        }
        if (this.getClashingWith().isEmpty() && this.isClashing()) {
            this.setClashing(false);
        }
        if (this.isClashing()) {
            this.incrementTimeSpentClashing();
            this.handleDomainClash(clashingWithMap.get((Object)this));
        }
        if (this.canTransport()) {
            this.handleTransportation();
        }
        if (!this.isClashing() && (this.isOpen() || this.getTransported())) {
            this.targetSureHit();
        }
        super.tick();
    }

    public void handleTransportation() {
        this.setTransported(true);
    }

    public void onAntiMagic(MagicData playerMagicData) {
    }

    public ArrayList<AbstractDomainEntity> getClashingWith() {
        if (clashingWithMap.get((Object)this) != null) {
            return clashingWithMap.get((Object)this);
        }
        return new ArrayList<AbstractDomainEntity>();
    }

    public boolean isClashing() {
        return (Boolean)this.entityData.get(CLASHING);
    }

    public void setClashing(boolean clashing) {
        this.entityData.set(CLASHING, (Object)clashing);
    }

    public int getRefinement() {
        return (Integer)this.entityData.get(REFINEMENT);
    }

    public void setRefinement(int refinement) {
        this.entityData.set(REFINEMENT, (Object)refinement);
    }

    public int getRadius() {
        return (Integer)this.entityData.get(RADIUS);
    }

    public void setRadius(int radius) {
        this.entityData.set(RADIUS, (Object)radius);
    }

    public boolean isOpen() {
        return (Boolean)this.entityData.get(OPEN);
    }

    public void setOpen(boolean open) {
        this.entityData.set(OPEN, (Object)open);
    }

    public boolean getTransported() {
        return (Boolean)this.entityData.get(TRANSPORTED);
    }

    public void setTransported(boolean transported) {
        this.entityData.set(TRANSPORTED, (Object)transported);
    }

    public void setOwner(Entity owner) {
        ownerMap.put(this, owner);
    }

    public Entity getOwner() {
        return ownerMap.get((Object)this);
    }

    public void setSpawnAnimTime(int spawnAnimTime) {
        this.spawnAnimTime = spawnAnimTime;
    }

    public int getSpawnAnimTime() {
        return this.spawnAnimTime;
    }

    public Long getSpawnTime() {
        return (Long)this.entityData.get(SPAWN_TIME);
    }

    public void setSpawnTime(long spawnTime) {
        this.entityData.set(SPAWN_TIME, (Object)spawnTime);
    }

    public void setClashable(boolean clashable) {
        this.entityData.set(CLASHABLE, (Object)clashable);
    }

    public boolean getClashable() {
        return (Boolean)this.entityData.get(CLASHABLE);
    }

    public int getTimeSpentClashing() {
        return (Integer)this.entityData.get(TIME_SPENT_CLASHING);
    }

    public void setTimeSpentClashing(int timeSpentClashing) {
        this.entityData.set(TIME_SPENT_CLASHING, (Object)timeSpentClashing);
    }

    public void incrementTimeSpentClashing() {
        this.entityData.set(TIME_SPENT_CLASHING, (Object)(this.getTimeSpentClashing() + 1));
    }

    protected void readAdditionalSaveData(CompoundTag tag) {
        this.setRadius(tag.getInt("Radius"));
        this.setRefinement(tag.getInt("Refinement"));
        this.setOpen(tag.getBoolean("Open"));
        this.setTransported(tag.getBoolean("Transported"));
        this.setSpawnTime(tag.getLong("Spawn Time"));
        this.setClashable(tag.getBoolean("Clashable"));
        this.setTimeSpentClashing(tag.getInt("Time Spent Clashing"));
        this.setClashing(tag.getBoolean("Clashing"));
    }

    protected void addAdditionalSaveData(CompoundTag tag) {
        tag.putInt("Radius", this.getRadius());
        tag.putInt("Refinement", this.getRefinement());
        tag.putBoolean("Open", this.isOpen());
        tag.putBoolean("Transported", this.getTransported());
        tag.putLong("Spawn Time", this.getSpawnTime().longValue());
        tag.putBoolean("Clashable", this.getClashable());
        tag.putInt("Time Spent Clashing", this.getTimeSpentClashing());
        tag.putBoolean("Clashing", this.isClashing());
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        builder.define(RADIUS, (Object)0);
        builder.define(REFINEMENT, (Object)0);
        builder.define(OPEN, (Object)false);
        builder.define(TRANSPORTED, (Object)false);
        builder.define(SPAWN_TIME, (Object)Long.MIN_VALUE);
        builder.define(CLASHABLE, (Object)true);
        builder.define(CLASHING, (Object)false);
        builder.define(TIME_SPENT_CLASHING, (Object)0);
    }

    public @UnknownNullability CompoundTag serializeNBT(HolderLookup.Provider provider) {
        CompoundTag compoundTag = new CompoundTag();
        compoundTag.putLong("Spawn Time", this.getSpawnTime().longValue());
        compoundTag.putInt("Time Spent Clashing", this.getTimeSpentClashing());
        compoundTag.putBoolean("Clashing", this.isClashing());
        return compoundTag;
    }

    public void deserializeNBT(HolderLookup.Provider provider, CompoundTag nbt) {
        this.setSpawnTime(nbt.getLong("Spawn Time"));
        this.setTimeSpentClashing(nbt.getInt("Time Spent Clashing"));
        this.setClashing(nbt.getBoolean("Clashing"));
    }
}

