/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.blocks.multiblocks.logic;

import blusunrize.immersiveengineering.api.energy.AveragingEnergyStorage;
import blusunrize.immersiveengineering.api.multiblocks.blocks.component.IClientTickableComponent;
import blusunrize.immersiveengineering.api.multiblocks.blocks.component.IMultiblockComponent;
import blusunrize.immersiveengineering.api.multiblocks.blocks.component.IServerTickableComponent;
import blusunrize.immersiveengineering.api.multiblocks.blocks.env.IInitialMultiblockContext;
import blusunrize.immersiveengineering.api.multiblocks.blocks.env.IMultiblockContext;
import blusunrize.immersiveengineering.api.multiblocks.blocks.env.IMultiblockLevel;
import blusunrize.immersiveengineering.api.multiblocks.blocks.logic.IMultiblockLogic;
import blusunrize.immersiveengineering.api.multiblocks.blocks.logic.IMultiblockState;
import blusunrize.immersiveengineering.api.multiblocks.blocks.util.CapabilityPosition;
import blusunrize.immersiveengineering.api.multiblocks.blocks.util.RelativeBlockFace;
import blusunrize.immersiveengineering.api.multiblocks.blocks.util.ShapeType;
import blusunrize.immersiveengineering.api.wires.redstone.CapabilityRedstoneNetwork;
import blusunrize.immersiveengineering.api.wires.redstone.WirelessRedstoneHandler;
import blusunrize.immersiveengineering.common.blocks.multiblocks.shapes.RadioTowerShapes;
import blusunrize.immersiveengineering.common.config.IEServerConfig;
import java.util.Arrays;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.SectionPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.neoforge.capabilities.Capabilities;

public class RadioTowerLogic
implements IMultiblockLogic<State>,
IServerTickableComponent<State>,
IClientTickableComponent<State> {
    public static final int FREQUENCY_MIN = 128;
    public static final int FREQUENCY_MAX = 384;
    public static final int ENERGY_CAPACITY = 64000;
    private static final CapabilityPosition ENERGY_INPUT = new CapabilityPosition(1, 1, 5, RelativeBlockFace.UP);
    private static final CapabilityPosition IO_CONNECTION = new CapabilityPosition(2, 1, 5, RelativeBlockFace.UP);
    private static final CapabilityPosition CONTROL_CONNECTION = new CapabilityPosition(3, 1, 5, RelativeBlockFace.UP);
    public static final BlockPos BROADCAST_POS = new BlockPos(2, 13, 2);

    @Override
    public void tickServer(IMultiblockContext<State> context) {
        State state = context.getState();
        IMultiblockLevel level = context.getLevel();
        Level rawLevel = context.getLevel().getRawLevel();
        if (rawLevel instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)rawLevel;
            BlockPos broadcastPos = level.toAbsolute(BROADCAST_POS);
            if (state.rangeInChunks < 0 || serverLevel.getGameTime() % 8192L == (long)((broadcastPos.getX() ^ broadcastPos.getZ()) & 0x1FFF)) {
                int maxRange;
                state.rangeInChunks = maxRange = this.calculateMaxRange((Level)serverLevel, broadcastPos, 4);
            }
            WirelessRedstoneHandler handler = WirelessRedstoneHandler.getHandler(serverLevel);
            int consumed = (Integer)IEServerConfig.MACHINES.radio_tower_consumption.get();
            int extracted = state.energy.extractEnergy(consumed, false);
            boolean prevActive = state.active;
            boolean bl = state.active = extracted >= consumed;
            if (state.active != prevActive) {
                state.markSendAndReceiveDirty();
            }
            if (!handler.isRegistered(broadcastPos, context.getState())) {
                handler.register(broadcastPos, context.getState());
            }
            if (state.sendingDirty) {
                handler.notifyComponents(broadcastPos, state);
                state.sendingDirty = false;
            }
            if (state.receivingDirty) {
                state.receivedSignals = state.isActive() ? handler.fetchSignals(broadcastPos, state) : new byte[16];
                state.bundleConnection.markDirty();
                state.receivingDirty = false;
            }
        }
    }

    @Override
    public void tickClient(IMultiblockContext<State> context) {
    }

    private int calculateMaxRange(Level level, BlockPos from, int chunkRadius) {
        int chunkX = SectionPos.blockToSectionCoord((int)from.getX());
        int chunkZ = SectionPos.blockToSectionCoord((int)from.getZ());
        int countOfHigher = 0;
        for (int offsetZ = -chunkRadius; offsetZ <= chunkRadius; ++offsetZ) {
            for (int offsetX = -chunkRadius; offsetX <= chunkRadius; ++offsetX) {
                LevelChunk chunk = level.getChunk(chunkX + offsetX, chunkZ + offsetZ);
                ChunkPos chunkPos = chunk.getPos();
                for (int iX = chunkPos.getMinBlockX(); iX <= chunkPos.getMaxBlockX(); ++iX) {
                    for (int iZ = chunkPos.getMinBlockZ(); iZ <= chunkPos.getMaxBlockZ(); ++iZ) {
                        if (chunk.getHeight(Heightmap.Types.WORLD_SURFACE, iX, iZ) <= from.getY() + 5) continue;
                        ++countOfHigher;
                    }
                }
            }
        }
        double mod = 1.015 - 1.0 / (1.0 + Math.exp(-((double)countOfHigher / 256.0 - 6.0)));
        return (int)Mth.clamp((double)(1024.0 * mod), (double)16.0, (double)1024.0);
    }

    @Override
    public State createInitialState(IInitialMultiblockContext<State> capabilitySource) {
        return new State(capabilitySource);
    }

    @Override
    public void registerCapabilities(IMultiblockComponent.CapabilityRegistrar<State> register) {
        register.registerAt(Capabilities.EnergyStorage.BLOCK, ENERGY_INPUT, state -> state.energy);
        register.registerAt(CapabilityRedstoneNetwork.REDSTONE_BUNDLE_CONNECTION, IO_CONNECTION, state -> state.bundleConnection);
        register.registerAt(CapabilityRedstoneNetwork.REDSTONE_BUNDLE_CONNECTION, CONTROL_CONNECTION, state -> state.controlConnection);
    }

    @Override
    public void dropExtraItems(State state, Consumer<ItemStack> drop) {
    }

    @Override
    public Function<BlockPos, VoxelShape> shapeGetter(ShapeType forType) {
        return RadioTowerShapes.SHAPE_GETTER;
    }

    public static class State
    implements IMultiblockState,
    WirelessRedstoneHandler.IWirelessRedstoneComponent {
        public final AveragingEnergyStorage energy = new AveragingEnergyStorage(64000);
        private final CapabilityRedstoneNetwork.RedstoneBundleConnection bundleConnection;
        private final CapabilityRedstoneNetwork.RedstoneBundleConnection controlConnection;
        public boolean active = false;
        public int frequency = 142;
        public int[] savedFrequencies = new int[16];
        public int rangeInChunks = -1;
        private byte[] receivedSignals = new byte[16];
        private byte[] sendingSignals = new byte[16];
        private boolean sendingDirty = false;
        private boolean receivingDirty = false;

        public State(IInitialMultiblockContext<State> ctx) {
            this.bundleConnection = new CapabilityRedstoneNetwork.RedstoneBundleConnection(){

                @Override
                public void onChange(byte[] externalInputs, Direction side) {
                    if (!Arrays.equals(externalInputs, sendingSignals)) {
                        sendingSignals = externalInputs;
                        sendingDirty = true;
                    }
                }

                @Override
                public void updateInput(byte[] signals, Direction side) {
                    for (int i = 0; i < signals.length; ++i) {
                        signals[i] = (byte)Math.max(signals[i], receivedSignals[i]);
                    }
                }
            };
            this.controlConnection = new CapabilityRedstoneNetwork.RedstoneBundleConnection(){

                @Override
                public void onChange(byte[] externalInputs, Direction side) {
                    byte maxSignal = 0;
                    int maxIdx = -1;
                    for (int i = 0; i < externalInputs.length; ++i) {
                        if (externalInputs[i] <= maxSignal) continue;
                        maxSignal = externalInputs[i];
                        maxIdx = i;
                    }
                    if (maxIdx >= 0) {
                        frequency = savedFrequencies[maxIdx];
                        receivingDirty = true;
                    }
                }
            };
            Arrays.fill(this.savedFrequencies, this.frequency);
        }

        @Override
        public void writeSaveNBT(CompoundTag nbt, HolderLookup.Provider provider) {
            nbt.putInt("frequency", this.frequency);
            nbt.putIntArray("savedFrequencies", this.savedFrequencies);
            nbt.put("energy", this.energy.serializeNBT(provider));
        }

        @Override
        public void readSaveNBT(CompoundTag nbt, HolderLookup.Provider provider) {
            this.frequency = nbt.getInt("frequency");
            this.savedFrequencies = nbt.getIntArray("savedFrequencies");
            this.energy.deserializeNBT(provider, (Tag)nbt.getCompound("energy"));
        }

        @Override
        public void writeSyncNBT(CompoundTag nbt, HolderLookup.Provider provider) {
            nbt.putBoolean("npe_avoid", true);
        }

        @Override
        public void readSyncNBT(CompoundTag nbt, HolderLookup.Provider provider) {
        }

        public int[] getSavedFrequencies() {
            return this.savedFrequencies;
        }

        public void setSavedFrequencies(int[] savedFrequencies) {
            this.savedFrequencies = savedFrequencies;
        }

        public int getChunkRange() {
            return this.rangeInChunks;
        }

        @Override
        public boolean isActive() {
            return this.active;
        }

        @Override
        public int getChunkRangeSq() {
            return this.rangeInChunks * this.rangeInChunks;
        }

        @Override
        public int getFrequency() {
            return this.frequency;
        }

        @Override
        public byte[] getBroadcastSignal() {
            return this.sendingSignals;
        }

        public void setFrequency(int frequency) {
            this.frequency = frequency;
        }

        @Override
        public void notifyOfUpdate(WirelessRedstoneHandler handler) {
            this.markSendAndReceiveDirty();
        }

        public void markSendAndReceiveDirty() {
            this.receivingDirty = true;
            this.sendingDirty = true;
        }

        public List<Vec3> getRelativeComponentsInRange(IMultiblockContext<State> context) {
            IMultiblockLevel level = context.getLevel();
            Level rawLevel = context.getLevel().getRawLevel();
            if (rawLevel instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)rawLevel;
                return WirelessRedstoneHandler.getHandler(serverLevel).getRelativeComponentsInRange(level.toAbsolute(BROADCAST_POS), this);
            }
            return List.of();
        }
    }
}

