/*
 * Decompiled with CFR 0.152.
 */
package com.blocklogic.agritechtrees.screen.custom;

import com.blocklogic.agritechtrees.block.custom.AgritechTreesHoppingPlanterBlock;
import com.blocklogic.agritechtrees.block.custom.AgritechTreesPlanterBlock;
import com.blocklogic.agritechtrees.block.entity.AgritechTreesPlanterBlockEntity;
import com.blocklogic.agritechtrees.config.AgritechTreesConfig;
import com.blocklogic.agritechtrees.screen.ModMenuTypes;
import com.blocklogic.agritechtrees.util.RegistryHelper;
import com.mojang.logging.LogUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.SlotItemHandler;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;

public class AgritechTreesPlanterMenu
extends AbstractContainerMenu {
    private static final Logger LOGGER = LogUtils.getLogger();
    public final AgritechTreesPlanterBlockEntity blockEntity;
    private final Level level;
    private int progressTicks = 0;
    private int maxProgressTicks = 0;
    private static final int HOTBAR_SLOT_COUNT = 9;
    private static final int PLAYER_INVENTORY_ROW_COUNT = 3;
    private static final int PLAYER_INVENTORY_COLUMN_COUNT = 9;
    private static final int PLAYER_INVENTORY_SLOT_COUNT = 27;
    private static final int VANILLA_SLOT_COUNT = 36;
    private static final int VANILLA_FIRST_SLOT_INDEX = 0;
    private static final int TE_INVENTORY_FIRST_SLOT_INDEX = 36;
    private static final int TE_INVENTORY_SLOT_COUNT = 8;

    public AgritechTreesPlanterMenu(int containerId, Inventory inv, FriendlyByteBuf extraData) {
        this(containerId, inv, inv.player.level().getBlockEntity(extraData.readBlockPos()));
    }

    public AgritechTreesPlanterMenu(int containerId, Inventory inv, BlockEntity blockEntity) {
        super((MenuType)ModMenuTypes.AGRITECH_TREES_PLANTER_MENU.get(), containerId);
        this.blockEntity = (AgritechTreesPlanterBlockEntity)blockEntity;
        this.level = inv.player.level();
        this.addPlayerInventory(inv);
        this.addPlayerHotbar(inv);
        this.addSlot((Slot)new SaplingSlot((IItemHandler)this.blockEntity.inventory, 0, 26, 18, this.blockEntity));
        this.addSlot((Slot)new SoilSlot((IItemHandler)this.blockEntity.inventory, 1, 26, 54, this.blockEntity));
        int outputSlotIndex = 2;
        for (int row = 0; row < 2; ++row) {
            for (int col = 0; col < 3; ++col) {
                this.addSlot((Slot)new OutputSlot((IItemHandler)this.blockEntity.inventory, outputSlotIndex++, 80 + col * 18, 27 + row * 18));
            }
        }
    }

    public ItemStack quickMoveStack(Player player, int index) {
        Slot sourceSlot = (Slot)this.slots.get(index);
        if (sourceSlot == null || !sourceSlot.hasItem()) {
            return ItemStack.EMPTY;
        }
        ItemStack sourceStack = sourceSlot.getItem();
        ItemStack copyOfSourceStack = sourceStack.copy();
        if (index < 36) {
            boolean movedItem = false;
            if (((Slot)this.slots.get(36)).mayPlace(sourceStack)) {
                if (this.moveItemStackTo(sourceStack, 36, 37, false)) {
                    movedItem = true;
                }
            } else if (((Slot)this.slots.get(37)).mayPlace(sourceStack) && this.moveItemStackTo(sourceStack, 37, 38, false)) {
                movedItem = true;
            }
            if (!movedItem) {
                return ItemStack.EMPTY;
            }
        } else if (index < 44) {
            if (!this.moveItemStackTo(sourceStack, 0, 36, false)) {
                return ItemStack.EMPTY;
            }
        } else {
            LOGGER.error("Invalid slotIndex:" + index);
            return ItemStack.EMPTY;
        }
        if (sourceStack.getCount() == 0) {
            sourceSlot.set(ItemStack.EMPTY);
        } else {
            sourceSlot.setChanged();
        }
        sourceSlot.onTake(player, sourceStack);
        return copyOfSourceStack;
    }

    public void updateProgressData(int progressTicks, int maxProgressTicks) {
        this.progressTicks = progressTicks;
        this.maxProgressTicks = maxProgressTicks;
    }

    public float getProgressPercentage() {
        if (this.maxProgressTicks <= 0) {
            return 0.0f;
        }
        return (float)this.progressTicks / (float)this.maxProgressTicks;
    }

    public int getProgressBarWidth(int maxWidth) {
        return (int)(this.getProgressPercentage() * (float)maxWidth);
    }

    public boolean stillValid(Player player) {
        Block block = this.blockEntity.getBlockState().getBlock();
        if (block instanceof AgritechTreesPlanterBlock || block instanceof AgritechTreesHoppingPlanterBlock) {
            return AgritechTreesPlanterMenu.stillValid((ContainerLevelAccess)ContainerLevelAccess.create((Level)this.level, (BlockPos)this.blockEntity.getBlockPos()), (Player)player, (Block)block);
        }
        return false;
    }

    private void addPlayerInventory(Inventory playerInventory) {
        for (int i = 0; i < 3; ++i) {
            for (int l = 0; l < 9; ++l) {
                this.addSlot(new Slot((Container)playerInventory, l + i * 9 + 9, 8 + l * 18, 87 + i * 18));
            }
        }
    }

    private void addPlayerHotbar(Inventory playerInventory) {
        for (int i = 0; i < 9; ++i) {
            this.addSlot(new Slot((Container)playerInventory, i, 8 + i * 18, 146));
        }
    }

    public static class SaplingSlot
    extends SlotItemHandler {
        private final AgritechTreesPlanterBlockEntity blockEntity;

        public SaplingSlot(IItemHandler itemHandler, int index, int xPosition, int yPosition, AgritechTreesPlanterBlockEntity blockEntity) {
            super(itemHandler, index, xPosition, yPosition);
            this.blockEntity = blockEntity;
        }

        public boolean mayPlace(ItemStack stack) {
            String saplingId = RegistryHelper.getItemId(stack);
            if (!AgritechTreesConfig.isValidSapling(saplingId)) {
                return false;
            }
            ItemStack soilStack = this.blockEntity.inventory.getStackInSlot(1);
            if (!soilStack.isEmpty()) {
                String soilId = RegistryHelper.getItemId(soilStack);
                return AgritechTreesConfig.isSoilValidForSapling(soilId, saplingId);
            }
            return true;
        }
    }

    public static class SoilSlot
    extends SlotItemHandler {
        private final AgritechTreesPlanterBlockEntity blockEntity;

        public SoilSlot(IItemHandler itemHandler, int index, int xPosition, int yPosition, AgritechTreesPlanterBlockEntity blockEntity) {
            super(itemHandler, index, xPosition, yPosition);
            this.blockEntity = blockEntity;
        }

        public boolean mayPlace(ItemStack stack) {
            String soilId = RegistryHelper.getItemId(stack);
            if (!AgritechTreesConfig.isValidSoil(soilId)) {
                return false;
            }
            ItemStack saplingStack = this.blockEntity.inventory.getStackInSlot(0);
            if (!saplingStack.isEmpty()) {
                String saplingId = RegistryHelper.getItemId(saplingStack);
                return AgritechTreesConfig.isSoilValidForSapling(soilId, saplingId);
            }
            return true;
        }

        public int getMaxStackSize() {
            return 1;
        }

        public int getMaxStackSize(@NotNull ItemStack stack) {
            return 1;
        }
    }

    public static class OutputSlot
    extends SlotItemHandler {
        public OutputSlot(IItemHandler itemHandler, int index, int xPosition, int yPosition) {
            super(itemHandler, index, xPosition, yPosition);
        }

        public boolean mayPlace(ItemStack stack) {
            return false;
        }
    }
}

