/*
 * Decompiled with CFR 0.152.
 */
package com.blocklogic.agritechtrees.config;

import com.blocklogic.agritechtrees.config.AgritechTreesConfig;
import com.blocklogic.agritechtrees.util.RegistryHelper;
import com.mojang.logging.LogUtils;
import java.io.BufferedReader;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.neoforged.fml.loading.FMLPaths;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.core.Appender;
import org.apache.logging.log4j.core.Layout;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.appender.FileAppender;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.config.LoggerConfig;
import org.apache.logging.log4j.core.layout.PatternLayout;
import org.slf4j.Logger;

public class AgritechTreesOverrideConfig {
    private static final Logger MAIN_LOGGER = LogUtils.getLogger();
    private static org.apache.logging.log4j.Logger ERROR_LOGGER = null;
    private static boolean HAS_LOGGED_ERRORS = false;
    private static Path ERROR_LOG_PATH = null;
    private static final String OVERRIDE_FILE_NAME = "agritech_trees_config_overrides.toml";
    private static final Pattern TABLE_PATTERN = Pattern.compile("\\[(\\w+)\\.([\\w]+)\\]");
    private static final Pattern KEY_VALUE_PATTERN = Pattern.compile("(\\w+)\\s*=\\s*(.+)");
    private static final Pattern ARRAY_PATTERN = Pattern.compile("\\[\\s*(.*)\\s*\\]");
    private static final Pattern STRING_PATTERN = Pattern.compile("\"([^\"]*)\"");
    private static final Map<String, Integer> treeLineNumbers = new HashMap<String, Integer>();
    private static final Map<String, Integer> soilLineNumbers = new HashMap<String, Integer>();

    private static void setupErrorLogger() {
        ERROR_LOGGER = LogManager.getLogger(AgritechTreesOverrideConfig.class);
    }

    private static synchronized void createLogFileIfNeeded() {
        if (HAS_LOGGED_ERRORS) {
            return;
        }
        try {
            String timestamp = LocalDateTime.now().format(DateTimeFormatter.ofPattern("yyyy-MM-dd_HH-mm-ss"));
            String logFileName = "agritechtrees_config_overrides_errors_" + timestamp + ".log";
            ERROR_LOG_PATH = FMLPaths.CONFIGDIR.get().resolve("agritechtrees").resolve("config_logs").resolve(logFileName);
            Files.createDirectories(ERROR_LOG_PATH.getParent(), new FileAttribute[0]);
            LoggerContext context = (LoggerContext)LogManager.getContext((boolean)false);
            Configuration config = context.getConfiguration();
            LoggerConfig existingLogger = config.getLoggerConfig("AgritechTreesOverrideErrorLogger");
            if (existingLogger != null) {
                existingLogger.getAppenders().forEach((name, appender) -> {
                    existingLogger.removeAppender(name);
                    appender.stop();
                });
                config.removeLogger("AgritechTreesOverrideErrorLogger");
            }
            PatternLayout layout = PatternLayout.newBuilder().withPattern("%d{yyyy-MM-dd HH:mm:ss} [%p] %m%n").build();
            FileAppender appender2 = ((FileAppender.Builder)((FileAppender.Builder)((FileAppender.Builder)FileAppender.newBuilder().setName("AgritechTreesOverrideErrorAppender")).withFileName(ERROR_LOG_PATH.toString()).setLayout((Layout)layout)).setConfiguration(config)).build();
            appender2.start();
            config.addAppender((Appender)appender2);
            LoggerConfig loggerConfig = new LoggerConfig("AgritechTreesOverrideErrorLogger", Level.INFO, false);
            loggerConfig.addAppender((Appender)appender2, Level.INFO, null);
            config.addLogger("AgritechTreesOverrideErrorLogger", loggerConfig);
            context.updateLoggers();
            ERROR_LOGGER = LogManager.getLogger((String)"AgritechTreesOverrideErrorLogger");
            MAIN_LOGGER.info("Created override config error log file: {}", (Object)ERROR_LOG_PATH);
            HAS_LOGGED_ERRORS = true;
        }
        catch (Exception e) {
            MAIN_LOGGER.error("Failed to set up dedicated error logger: {}", (Object)e.getMessage());
        }
    }

    private static void logError(String message, Object ... params) {
        AgritechTreesOverrideConfig.createLogFileIfNeeded();
        ERROR_LOGGER.error(message, params);
    }

    private static void logWarning(String message, Object ... params) {
        AgritechTreesOverrideConfig.createLogFileIfNeeded();
        ERROR_LOGGER.warn(message, params);
    }

    public static void loadOverrides(Map<String, AgritechTreesConfig.TreeInfo> trees, Map<String, AgritechTreesConfig.SoilInfo> soils) {
        Path configDir = FMLPaths.CONFIGDIR.get().resolve("agritechtrees");
        Path overridePath = configDir.resolve(OVERRIDE_FILE_NAME);
        AgritechTreesOverrideConfig.setupErrorLogger();
        if (!Files.exists(overridePath, new LinkOption[0])) {
            AgritechTreesOverrideConfig.createDefaultOverrideFile(configDir, overridePath);
        }
        try {
            MAIN_LOGGER.info("Loading tree and soil overrides from {}", (Object)overridePath);
            treeLineNumbers.clear();
            soilLineNumbers.clear();
            Map<String, Map<String, Map<String, Object>>> tables = AgritechTreesOverrideConfig.parseTomlFile(overridePath);
            int treeCount = AgritechTreesOverrideConfig.processTreeEntries(tables.getOrDefault("trees", Collections.emptyMap()), trees);
            int soilCount = AgritechTreesOverrideConfig.processSoilEntries(tables.getOrDefault("soils", Collections.emptyMap()), soils);
            MAIN_LOGGER.info("Successfully loaded {} tree overrides and {} soil overrides", (Object)treeCount, (Object)soilCount);
        }
        catch (Exception e) {
            MAIN_LOGGER.error("Failed to load override.toml file: {}", (Object)e.getMessage());
            AgritechTreesOverrideConfig.logError("Failed to load override.toml file: {}", e.getMessage());
            AgritechTreesOverrideConfig.logError("The override file will be ignored, but the mod will continue to function", new Object[0]);
        }
    }

    private static Map<String, Map<String, Map<String, Object>>> parseTomlFile(Path filePath) throws IOException {
        HashMap<String, Map<String, Map<String, Object>>> result = new HashMap<String, Map<String, Map<String, Object>>>();
        String currentSection = null;
        String currentTable = null;
        Map currentSectionMap = null;
        Map currentTableMap = null;
        try (BufferedReader reader = Files.newBufferedReader(filePath);){
            String line;
            StringBuilder multilineValue = null;
            String pendingKey = null;
            int lineNumber = 0;
            while ((line = reader.readLine()) != null) {
                Matcher keyValueMatcher;
                ++lineNumber;
                int commentPos = AgritechTreesOverrideConfig.findUnquotedChar(line, '#');
                if (commentPos >= 0) {
                    line = line.substring(0, commentPos);
                }
                if ((line = line.trim()).isEmpty()) continue;
                if (multilineValue != null) {
                    multilineValue.append(line);
                    if (AgritechTreesOverrideConfig.countOccurrences(multilineValue.toString(), '[') != AgritechTreesOverrideConfig.countOccurrences(multilineValue.toString(), ']') || AgritechTreesOverrideConfig.countOccurrences(multilineValue.toString(), '{') != AgritechTreesOverrideConfig.countOccurrences(multilineValue.toString(), '}')) continue;
                    currentTableMap.put(pendingKey, AgritechTreesOverrideConfig.parseValue(multilineValue.toString()));
                    multilineValue = null;
                    pendingKey = null;
                    continue;
                }
                Matcher tableMatcher = TABLE_PATTERN.matcher(line);
                if (tableMatcher.matches()) {
                    currentSection = tableMatcher.group(1);
                    currentTable = tableMatcher.group(2);
                    if ("trees".equals(currentSection)) {
                        treeLineNumbers.put(currentTable, lineNumber);
                    } else if ("soils".equals(currentSection)) {
                        soilLineNumbers.put(currentTable, lineNumber);
                    }
                    currentSectionMap = result.computeIfAbsent(currentSection, k -> new HashMap());
                    currentTableMap = currentSectionMap.computeIfAbsent(currentTable, k -> new HashMap());
                    continue;
                }
                if (currentTableMap == null || !(keyValueMatcher = KEY_VALUE_PATTERN.matcher(line)).matches()) continue;
                String key = keyValueMatcher.group(1);
                String valueStr = keyValueMatcher.group(2).trim();
                if (valueStr.startsWith("[") && !valueStr.endsWith("]") || AgritechTreesOverrideConfig.countOccurrences(valueStr, '[') != AgritechTreesOverrideConfig.countOccurrences(valueStr, ']') || AgritechTreesOverrideConfig.countOccurrences(valueStr, '{') != AgritechTreesOverrideConfig.countOccurrences(valueStr, '}')) {
                    multilineValue = new StringBuilder(valueStr);
                    pendingKey = key;
                    continue;
                }
                Object value = AgritechTreesOverrideConfig.parseValue(valueStr);
                currentTableMap.put(key, value);
            }
        }
        return result;
    }

    private static int findUnquotedChar(String str, char target) {
        boolean inQuotes = false;
        for (int i = 0; i < str.length(); ++i) {
            char c = str.charAt(i);
            if (c == '\"') {
                inQuotes = !inQuotes;
                continue;
            }
            if (c != target || inQuotes) continue;
            return i;
        }
        return -1;
    }

    private static int countOccurrences(String str, char target) {
        int count = 0;
        for (int i = 0; i < str.length(); ++i) {
            if (str.charAt(i) != target) continue;
            ++count;
        }
        return count;
    }

    private static Object parseValue(String valueStr) {
        Matcher arrayMatcher;
        if (valueStr.startsWith("[") && valueStr.endsWith("]") && valueStr.contains("{")) {
            int closeBrace;
            int openBrace;
            ArrayList<Map<String, Object>> items = new ArrayList<Map<String, Object>>();
            String content = valueStr.substring(1, valueStr.length() - 1).trim();
            int startIdx = 0;
            while (startIdx < content.length() && (openBrace = content.indexOf(123, startIdx)) != -1 && (closeBrace = AgritechTreesOverrideConfig.findMatchingCloseBrace(content, openBrace)) != -1) {
                String objectStr = content.substring(openBrace + 1, closeBrace).trim();
                Map<String, Object> objectMap = AgritechTreesOverrideConfig.parseObject(objectStr);
                items.add(objectMap);
                startIdx = closeBrace + 1;
            }
            return items;
        }
        if (valueStr.startsWith("[") && valueStr.endsWith("]") && (arrayMatcher = ARRAY_PATTERN.matcher(valueStr)).matches()) {
            String arrayContent = arrayMatcher.group(1);
            ArrayList<String> items = new ArrayList<String>();
            Matcher stringMatcher = STRING_PATTERN.matcher(arrayContent);
            while (stringMatcher.find()) {
                items.add(stringMatcher.group(1));
            }
            return items;
        }
        if (valueStr.startsWith("\"") && valueStr.endsWith("\"")) {
            return valueStr.substring(1, valueStr.length() - 1);
        }
        try {
            if (valueStr.contains(".")) {
                return Double.parseDouble(valueStr);
            }
            return Integer.parseInt(valueStr);
        }
        catch (NumberFormatException numberFormatException) {
            if (valueStr.equalsIgnoreCase("true")) {
                return true;
            }
            if (valueStr.equalsIgnoreCase("false")) {
                return false;
            }
            return valueStr;
        }
    }

    private static int findMatchingCloseBrace(String content, int openBracePos) {
        int depth = 0;
        for (int i = openBracePos; i < content.length(); ++i) {
            char c = content.charAt(i);
            if (c == '{') {
                ++depth;
                continue;
            }
            if (c != '}' || --depth != 0) continue;
            return i;
        }
        return -1;
    }

    private static Map<String, Object> parseObject(String objectStr) {
        String[] parts;
        HashMap<String, Object> result = new HashMap<String, Object>();
        for (String part : parts = objectStr.split(",")) {
            Object value;
            String[] keyValue;
            if ((part = part.trim()).isEmpty() || (keyValue = part.split("=", 2)).length != 2) continue;
            String key = keyValue[0].trim();
            String valueStr = keyValue[1].trim();
            if (valueStr.startsWith("\"") && valueStr.endsWith("\"")) {
                value = valueStr.substring(1, valueStr.length() - 1);
            } else if (valueStr.equals("true")) {
                value = true;
            } else if (valueStr.equals("false")) {
                value = false;
            } else {
                try {
                    value = valueStr.contains(".") ? (Number)Double.parseDouble(valueStr) : (Number)Integer.parseInt(valueStr);
                }
                catch (NumberFormatException e) {
                    value = valueStr;
                }
            }
            result.put(key, value);
        }
        return result;
    }

    private static int processTreeEntries(Map<String, Map<String, Object>> treeEntries, Map<String, AgritechTreesConfig.TreeInfo> trees) {
        int count = 0;
        for (Map.Entry<String, Map<String, Object>> entry : treeEntries.entrySet()) {
            Object lineInfo;
            int lineNum;
            String treeName = entry.getKey();
            Map<String, Object> treeConfig = entry.getValue();
            try {
                Object saplingObj = treeConfig.get("sapling");
                if (saplingObj == null) {
                    lineNum = treeLineNumbers.getOrDefault(treeName, -1);
                    lineInfo = lineNum > 0 ? " (line " + lineNum + ")" : "";
                    MAIN_LOGGER.warn("Tree override '{}'{} is missing a sapling ID, skipping", (Object)treeName, lineInfo);
                    AgritechTreesOverrideConfig.logWarning("Tree override '{}'{} is missing a sapling ID, skipping", treeName, lineInfo);
                    continue;
                }
                String saplingId = saplingObj.toString();
                Item saplingItem = RegistryHelper.getItem(saplingId);
                if (saplingItem == null) {
                    int lineNum2 = treeLineNumbers.getOrDefault(treeName, -1);
                    Object lineInfo2 = lineNum2 > 0 ? " (line " + lineNum2 + ")" : "";
                    MAIN_LOGGER.warn("Tree override '{}'{} uses non-existent sapling item: {}, skipping", new Object[]{treeName, lineInfo2, saplingId});
                    AgritechTreesOverrideConfig.logWarning("Tree override '{}'{} uses non-existent sapling item: {}, skipping", treeName, lineInfo2, saplingId);
                    continue;
                }
                ArrayList<String> validSoils = new ArrayList<String>();
                Object soilsObj = treeConfig.get("soil");
                if (soilsObj instanceof List) {
                    List soilsList = (List)soilsObj;
                    for (Object soilObj : soilsList) {
                        String soilId = soilObj.toString();
                        Block soilBlock = RegistryHelper.getBlock(soilId);
                        if (soilBlock == null) {
                            int lineNum3 = treeLineNumbers.getOrDefault(treeName, -1);
                            Object lineInfo3 = lineNum3 > 0 ? " (line " + lineNum3 + ")" : "";
                            MAIN_LOGGER.warn("Tree override '{}'{} references non-existent soil block: {}, skipping this soil", new Object[]{treeName, lineInfo3, soilId});
                            AgritechTreesOverrideConfig.logWarning("Tree override '{}'{} references non-existent soil block: {}, skipping this soil", treeName, lineInfo3, soilId);
                            continue;
                        }
                        validSoils.add(soilId);
                    }
                }
                if (validSoils.isEmpty()) {
                    int lineNum4 = treeLineNumbers.getOrDefault(treeName, -1);
                    Object lineInfo4 = lineNum4 > 0 ? " (line " + lineNum4 + ")" : "";
                    MAIN_LOGGER.warn("Tree override '{}'{} has no valid soils, skipping", (Object)treeName, lineInfo4);
                    AgritechTreesOverrideConfig.logWarning("Tree override '{}'{} has no valid soils, skipping", treeName, lineInfo4);
                    continue;
                }
                ArrayList<AgritechTreesConfig.DropInfo> drops = new ArrayList<AgritechTreesConfig.DropInfo>();
                Object dropsObj = treeConfig.get("drops");
                if (dropsObj instanceof List) {
                    List dropsList = (List)dropsObj;
                    int defaultMinCount = 1;
                    int defaultMaxCount = 1;
                    float defaultChance = 1.0f;
                    if (treeConfig.containsKey("min_count") && treeConfig.get("min_count") instanceof Number) {
                        defaultMinCount = ((Number)treeConfig.get("min_count")).intValue();
                    }
                    if (treeConfig.containsKey("max_count") && treeConfig.get("max_count") instanceof Number) {
                        defaultMaxCount = ((Number)treeConfig.get("max_count")).intValue();
                    }
                    if (treeConfig.containsKey("chance") && treeConfig.get("chance") instanceof Number) {
                        defaultChance = ((Number)treeConfig.get("chance")).floatValue();
                    }
                    for (Object dropObj : dropsList) {
                        String dropId;
                        int minCount = defaultMinCount;
                        int maxCount = defaultMaxCount;
                        float chance = defaultChance;
                        if (dropObj instanceof Map) {
                            Map dropMap = (Map)dropObj;
                            Object itemObj = dropMap.get("item");
                            if (itemObj == null) {
                                int lineNum5 = treeLineNumbers.getOrDefault(treeName, -1);
                                Object lineInfo5 = lineNum5 > 0 ? " (line " + lineNum5 + ")" : "";
                                MAIN_LOGGER.warn("Tree override '{}'{} has drop without item ID, skipping", (Object)treeName, lineInfo5);
                                AgritechTreesOverrideConfig.logWarning("Tree override '{}'{} has drop without item ID, skipping", treeName, lineInfo5);
                                continue;
                            }
                            dropId = itemObj.toString();
                            if (dropMap.containsKey("min_count") && dropMap.get("min_count") instanceof Number) {
                                minCount = ((Number)dropMap.get("min_count")).intValue();
                            }
                            if (dropMap.containsKey("max_count") && dropMap.get("max_count") instanceof Number) {
                                maxCount = ((Number)dropMap.get("max_count")).intValue();
                            }
                            if (dropMap.containsKey("chance") && dropMap.get("chance") instanceof Number) {
                                chance = ((Number)dropMap.get("chance")).floatValue();
                            }
                        } else {
                            dropId = dropObj.toString();
                        }
                        Item dropItem = RegistryHelper.getItem(dropId);
                        if (dropItem == null) {
                            int lineNum6 = treeLineNumbers.getOrDefault(treeName, -1);
                            Object lineInfo6 = lineNum6 > 0 ? " (line " + lineNum6 + ")" : "";
                            MAIN_LOGGER.warn("Tree override '{}'{} references non-existent drop item: {}, skipping this drop", new Object[]{treeName, lineInfo6, dropId});
                            AgritechTreesOverrideConfig.logWarning("Tree override '{}'{} references non-existent drop item: {}, skipping this drop", treeName, lineInfo6, dropId);
                            continue;
                        }
                        drops.add(new AgritechTreesConfig.DropInfo(dropId, minCount, maxCount, chance));
                    }
                }
                if (drops.isEmpty()) {
                    int lineNum7 = treeLineNumbers.getOrDefault(treeName, -1);
                    Object lineInfo7 = lineNum7 > 0 ? " (line " + lineNum7 + ")" : "";
                    MAIN_LOGGER.warn("Tree override '{}'{} has no valid drops, skipping", (Object)treeName, lineInfo7);
                    AgritechTreesOverrideConfig.logWarning("Tree override '{}'{} has no valid drops, skipping", treeName, lineInfo7);
                    continue;
                }
                AgritechTreesConfig.TreeInfo treeInfo = new AgritechTreesConfig.TreeInfo();
                treeInfo.validSoils = validSoils;
                treeInfo.drops = drops;
                trees.put(saplingId, treeInfo);
                ++count;
                MAIN_LOGGER.info("Added tree override for '{}' with sapling {}", (Object)treeName, (Object)saplingId);
            }
            catch (Exception e) {
                lineNum = treeLineNumbers.getOrDefault(treeName, -1);
                lineInfo = lineNum > 0 ? " (line " + lineNum + ")" : "";
                MAIN_LOGGER.error("Error processing tree override '{}'{}: {}", new Object[]{treeName, lineInfo, e.getMessage()});
                AgritechTreesOverrideConfig.logError("Error processing tree override '{}'{}: {}", treeName, lineInfo, e.getMessage());
            }
        }
        return count;
    }

    private static int processSoilEntries(Map<String, Map<String, Object>> soilEntries, Map<String, AgritechTreesConfig.SoilInfo> soils) {
        int count = 0;
        for (Map.Entry<String, Map<String, Object>> entry : soilEntries.entrySet()) {
            Object lineInfo;
            int lineNum;
            String soilName = entry.getKey();
            Map<String, Object> soilConfig = entry.getValue();
            try {
                Object blockObj = soilConfig.get("block");
                if (blockObj == null) {
                    lineNum = soilLineNumbers.getOrDefault(soilName, -1);
                    lineInfo = lineNum > 0 ? " (line " + lineNum + ")" : "";
                    MAIN_LOGGER.warn("Soil override '{}'{} is missing a block ID, skipping", (Object)soilName, lineInfo);
                    AgritechTreesOverrideConfig.logWarning("Soil override '{}'{} is missing a block ID, skipping", soilName, lineInfo);
                    continue;
                }
                String soilId = blockObj.toString();
                Block soilBlock = RegistryHelper.getBlock(soilId);
                if (soilBlock == null) {
                    int lineNum2 = soilLineNumbers.getOrDefault(soilName, -1);
                    Object lineInfo2 = lineNum2 > 0 ? " (line " + lineNum2 + ")" : "";
                    MAIN_LOGGER.warn("Soil override '{}'{} uses non-existent block: {}, skipping", new Object[]{soilName, lineInfo2, soilId});
                    AgritechTreesOverrideConfig.logWarning("Soil override '{}'{} uses non-existent block: {}, skipping", soilName, lineInfo2, soilId);
                    continue;
                }
                float growthModifier = 1.0f;
                Object modifierObj = soilConfig.get("growth_modifier");
                if (modifierObj instanceof Number) {
                    growthModifier = ((Number)modifierObj).floatValue();
                }
                AgritechTreesConfig.SoilInfo soilInfo = new AgritechTreesConfig.SoilInfo(growthModifier);
                soils.put(soilId, soilInfo);
                ++count;
                MAIN_LOGGER.info("Added soil override for '{}' with block {}", (Object)soilName, (Object)soilId);
            }
            catch (Exception e) {
                lineNum = soilLineNumbers.getOrDefault(soilName, -1);
                lineInfo = lineNum > 0 ? " (line " + lineNum + ")" : "";
                MAIN_LOGGER.error("Error processing soil override '{}'{}: {}", new Object[]{soilName, lineInfo, e.getMessage()});
                AgritechTreesOverrideConfig.logError("Error processing soil override '{}'{}: {}", soilName, lineInfo, e.getMessage());
            }
        }
        return count;
    }

    private static void createDefaultOverrideFile(Path configDir, Path overridePath) {
        block9: {
            try {
                if (!Files.exists(configDir, new LinkOption[0])) {
                    Files.createDirectories(configDir, new FileAttribute[0]);
                }
                try (FileWriter writer = new FileWriter(overridePath.toFile());){
                    writer.write(AgritechTreesOverrideConfig.createBasicTemplate());
                }
                MAIN_LOGGER.info("Created default override.toml file with examples at {}", (Object)overridePath);
            }
            catch (IOException e) {
                MAIN_LOGGER.error("Failed to create default override.toml file: {}", (Object)e.getMessage());
                if (!HAS_LOGGED_ERRORS) break block9;
                ERROR_LOGGER.error("Failed to create default override.toml file: {}", (Object)e.getMessage());
            }
        }
    }

    public static void resetErrorFlag() {
        HAS_LOGGED_ERRORS = false;
        ERROR_LOGGER = null;
        ERROR_LOG_PATH = null;
    }

    private static String createBasicTemplate() {
        return "# AgriTech Trees Override Configuration\n# This file allows you to add custom trees and soils without modifying the core configuration.\n# Any entries here will override existing configurations for the same items/blocks.\n\n# How to use:\n# 1. Add [trees.your_tree_name] sections for new trees or to override existing ones\n# 2. Add [soils.your_soil_name] sections for new soils or to override existing ones\n# 3. Save the file and restart your game\n\n# IMPORTANT: Make sure to verify the exact item and block IDs from your mods\n# Incorrect IDs will be skipped with a warning message in the log\n# The mod uses resource location format (e.g., \"minecraft:dirt\" not just \"dirt\")\n# The easiest way to check IDs is with F3+H enabled (shows tooltip IDs) or via JEI/REI\n\n# Example trees:\n\n# [trees.example_oak]\n# sapling = \"examplemod:oak_sapling\"\n# soil = [\n#   \"minecraft:dirt\",\n#   \"examplemod:rich_soil\"\n# ]\n# # There are two ways to specify drops:\n# # 1. Simple drops with default settings:\n# drops = [\n#   \"examplemod:oak_log\",\n#   \"examplemod:oak_sapling\"\n# ]\n# min_count = 1  # Minimum drop count for all simple drops (default: 1)\n# max_count = 3  # Maximum drop count for all simple drops (default: 1)\n# chance = 0.75  # Drop chance for all simple drops (default: 1.0)\n\n# # 2. Detailed drops with individual settings (use this for multiple drops with different chances):\n# # [trees.example_oak_advanced]\n# # sapling = \"examplemod:oak_sapling\"\n# # soil = [\"minecraft:dirt\"]\n# # drops = [\n# #   { item = \"examplemod:oak_log\", min_count = 2, max_count = 6, chance = 1.0 },\n# #   { item = \"examplemod:oak_sapling\", min_count = 1, max_count = 2, chance = 0.5 },\n# #   { item = \"minecraft:apple\", min_count = 1, max_count = 2, chance = 0.2 }\n# # ]\n\n# Example soils:\n\n# [soils.example_rich_soil]\n# block = \"examplemod:rich_soil\"\n# growth_modifier = 1.5  # Growth speed multiplier (default: 1.0)\n\n# REAL EXAMPLE - Uncomment to use\n# This example adds support for a mod's tree\n\n# [trees.modded_tree]\n# sapling = \"awesomemod:magical_sapling\"\n# soil = [\n#   \"minecraft:dirt\",\n#   \"minecraft:grass_block\",\n#   \"minecraft:podzol\"\n# ]\n# drops = [\n#   { item = \"awesomemod:magical_log\", min_count = 3, max_count = 7, chance = 1.0 },\n#   { item = \"awesomemod:magical_sapling\", min_count = 1, max_count = 2, chance = 0.5 },\n#   { item = \"awesomemod:magical_fruit\", min_count = 1, max_count = 3, chance = 0.4 }\n# ]\n\n# [soils.magical_soil]\n# block = \"awesomemod:magical_soil\"\n# growth_modifier = 1.75\n";
    }
}

