/*
 * Decompiled with CFR 0.152.
 */
package com.blocklogic.agritechtrees;

import com.blocklogic.agritechtrees.config.AgritechTreesConfig;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.ModList;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.event.config.ModConfigEvent;
import net.neoforged.neoforge.common.ModConfigSpec;

@EventBusSubscriber(modid="agritechtrees", bus=EventBusSubscriber.Bus.MOD)
public class Config {
    private static final ModConfigSpec.Builder BUILDER = new ModConfigSpec.Builder();
    private static final ModConfigSpec.BooleanValue MESSAGE = BUILDER.comment("INFO: If you change any of the values below, delete 'config/agritechtrees/saplings_and_soils.json' and restart your client to regenerate the crop config!").define("infoIs", true);
    private static final ModConfigSpec.BooleanValue ENABLE_ARS_ELEMENTAL = BUILDER.comment("Enable Ars Elemental Archwood Trees. Default: true").define("addArsElementalTrees", true);
    private static final ModConfigSpec.BooleanValue ENABLE_ARS_NOUVEAU = BUILDER.comment("Enable Ars Nouveau Archwood Trees. Default: true").define("addArsNouveauTrees", true);
    private static final ModConfigSpec.BooleanValue ENABLE_TWILIGHT_FOREST = BUILDER.comment("Enable Twilight Forest Trees (Not including magic trees). Default: true").define("enableTwilightForest", true);
    private static final ModConfigSpec.BooleanValue ENABLE_EVILCRAFT = BUILDER.comment("Enable Evilcraft Trees (Not including magic trees). Default: true").define("enableEvilCraft", true);
    private static final ModConfigSpec.BooleanValue ENABLE_FORBIDDEN_ARCANUS = BUILDER.comment("Enable Forbidden Arcanus Trees. Default: true").define("enableForbiddenArcanus", true);
    private static final ModConfigSpec.BooleanValue ENABLE_INTEGRATED_DYNAMICS = BUILDER.comment("Enable Integrated Dynamics Trees. Default: true").define("enableIntegratedDynamics", true);
    private static final ModConfigSpec.BooleanValue ENABLE_OCCULTISM = BUILDER.comment("Enable Occultism Trees. Default: true").define("enableOccultism", true);
    private static final ModConfigSpec.BooleanValue ENABLE_HEXEREI = BUILDER.comment("Enable Hexerei Trees. Default: true").define("enableHexerei", true);
    static final ModConfigSpec SPEC = BUILDER.build();
    public static boolean enableArsElemental;
    public static boolean enableArsNouveau;
    public static boolean enableTwilightForest;
    public static boolean enableEvilCraft;
    public static boolean enableForbiddenArcanus;
    public static boolean enableIntegratedDynamics;
    public static boolean enableOccultism;
    public static boolean enableHexerei;

    private static boolean validateItemName(Object obj) {
        String itemName;
        return obj instanceof String && BuiltInRegistries.ITEM.containsKey(ResourceLocation.parse((String)(itemName = (String)obj)));
    }

    public static void loadConfig() {
        enableArsElemental = (Boolean)ENABLE_ARS_ELEMENTAL.get() != false && ModList.get().isLoaded("ars_elemental");
        enableArsNouveau = (Boolean)ENABLE_ARS_NOUVEAU.get() != false && ModList.get().isLoaded("ars_nouveau");
        enableTwilightForest = (Boolean)ENABLE_TWILIGHT_FOREST.get() != false && ModList.get().isLoaded("twilightforest");
        enableEvilCraft = (Boolean)ENABLE_EVILCRAFT.get() != false && ModList.get().isLoaded("evilcraft");
        enableForbiddenArcanus = (Boolean)ENABLE_FORBIDDEN_ARCANUS.get() != false && ModList.get().isLoaded("forbidden_arcanus");
        enableIntegratedDynamics = (Boolean)ENABLE_INTEGRATED_DYNAMICS.get() != false && ModList.get().isLoaded("integrateddynamics");
        enableOccultism = (Boolean)ENABLE_OCCULTISM.get() != false && ModList.get().isLoaded("occultism");
        enableHexerei = (Boolean)ENABLE_HEXEREI.get() != false && ModList.get().isLoaded("hexerei");
    }

    @SubscribeEvent
    static void onLoad(ModConfigEvent event) {
        Config.loadConfig();
        AgritechTreesConfig.loadConfig();
    }
}

