/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.core.self.network;

import com.google.common.base.Strings;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import shetiphian.core.common.NameCache;
import shetiphian.core.common.PlayerConfigs;
import shetiphian.core.network.PacketPlayerConfig;
import shetiphian.core.self.network.PacketNameSyncPlayer;
import shetiphian.core.self.network.PacketNameSyncTeam;
import shetiphian.core.self.network.PacketTeamIdSync;
import shetiphian.core.self.teams.PacketTeamSync;
import shetiphian.core.self.teams.PlayerTeam;

final class ClientPayloadHandler {
    static final ClientPayloadHandler INSTANCE = new ClientPayloadHandler();

    ClientPayloadHandler() {
    }

    void handle(PacketNameSyncPlayer packet, Player player) {
        if (!Strings.isNullOrEmpty((String)packet.displayName())) {
            NameCache.setPlayerName(packet.uuid(), packet.displayName());
        }
    }

    void handle(PacketNameSyncTeam packet, Player player) {
        if (!Strings.isNullOrEmpty((String)packet.displayName())) {
            NameCache.setTeamName(packet.teamId(), packet.displayName());
        }
    }

    void handle(PacketPlayerConfig packet, Player player) {
        PlayerConfigs.setServerControlled((ResourceLocation)packet.data().getLeft(), packet.data().getMiddle());
    }

    void handle(PacketTeamIdSync packet, Player player) {
        for (int index = 0; index < packet.names().length; ++index) {
            PlayerTeam.create(packet.ids()[index], null, packet.names()[index]);
        }
    }

    void handle(PacketTeamSync data, Player player) {
        PlayerTeam.handleSyncPacket(data, player.getUUID());
    }
}

