/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.core.self.client.model;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.mojang.math.Transformation;
import java.util.ArrayList;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.BlockModel;
import net.minecraft.client.renderer.block.model.ItemOverrides;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.Material;
import net.minecraft.client.resources.model.ModelBaker;
import net.minecraft.client.resources.model.ModelState;
import net.minecraft.client.resources.model.UnbakedModel;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.client.ChunkRenderTypeSet;
import net.neoforged.neoforge.client.model.IDynamicBakedModel;
import net.neoforged.neoforge.client.model.SimpleModelState;
import net.neoforged.neoforge.client.model.data.ModelData;
import net.neoforged.neoforge.client.model.data.ModelProperty;
import net.neoforged.neoforge.client.model.geometry.IGeometryBakingContext;
import net.neoforged.neoforge.client.model.geometry.IGeometryLoader;
import net.neoforged.neoforge.client.model.geometry.IUnbakedGeometry;
import net.neoforged.neoforge.common.util.ConcatenatedListView;

public class ModelMultiLayered {
    public static final Loader LOADER = new Loader();

    public static class Loader
    implements IGeometryLoader<Unbaked> {
        public Unbaked read(JsonObject modelContents, JsonDeserializationContext context) {
            ImmutableMap children;
            String name;
            ArrayList<String> itemPasses = new ArrayList<String>();
            ImmutableMap.Builder childrenBuilder = ImmutableMap.builder();
            if (modelContents.has("children")) {
                for (Map.Entry entry : GsonHelper.getAsJsonObject((JsonObject)modelContents, (String)"children").entrySet()) {
                    Object v = entry.getValue();
                    if (!(v instanceof JsonObject)) continue;
                    JsonObject subModel = (JsonObject)v;
                    name = (String)entry.getKey();
                    childrenBuilder.put((Object)name, (Object)((BlockModel)context.deserialize((JsonElement)subModel, BlockModel.class)));
                    if (name.endsWith("_fast")) continue;
                    itemPasses.add(name);
                }
            }
            if ((children = childrenBuilder.build()).isEmpty()) {
                throw new JsonParseException("Layered model requires a \"children\" block with at least one element.");
            }
            if (modelContents.has("item_render_order")) {
                itemPasses.clear();
                for (JsonElement element : GsonHelper.getAsJsonArray((JsonObject)modelContents, (String)"item_render_order")) {
                    name = element.getAsString();
                    if (!children.containsKey((Object)name)) {
                        throw new JsonParseException("Specified \"" + name + "\" in \"item_render_order\", but that is not a child of this model.");
                    }
                    itemPasses.add(name);
                }
            }
            return new Unbaked((Map<String, BlockModel>)children, (List<String>)ImmutableList.copyOf(itemPasses));
        }
    }

    public static class Data {
        public static final ModelProperty<Data> PROPERTY = new ModelProperty();
        private final Map<String, ModelData> partData;

        private Data(Map<String, ModelData> partData) {
            this.partData = partData;
        }

        public ModelData get(String name) {
            return this.partData.get(name);
        }

        public static ModelData resolve(ModelData modelData, String name) {
            Data compositeData = (Data)modelData.get(PROPERTY);
            if (compositeData == null) {
                return modelData;
            }
            ModelData partData = compositeData.get(name);
            return partData != null ? partData : modelData;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            private final Map<String, ModelData> partData = new IdentityHashMap<String, ModelData>();

            public Builder with(String name, ModelData data) {
                this.partData.put(name, data);
                return this;
            }

            public Data build() {
                return new Data(this.partData);
            }
        }
    }

    private record Unbaked(Map<String, BlockModel> children, List<String> itemPasses) implements IUnbakedGeometry<Unbaked>
    {
        public Set<String> getConfigurableComponentNames() {
            return this.children.keySet();
        }

        public void resolveParents(Function<ResourceLocation, UnbakedModel> modelGetter, IGeometryBakingContext context) {
            this.children.values().forEach(child -> child.resolveParents(modelGetter));
        }

        public BakedModel bake(IGeometryBakingContext context, ModelBaker bakery, Function<Material, TextureAtlasSprite> spriteGetter, ModelState modelState, ItemOverrides overrides) {
            TextureAtlasSprite particle = spriteGetter.apply(context.getMaterial("particle"));
            Transformation rootTransform = context.getRootTransform();
            if (!rootTransform.isIdentity()) {
                modelState = new SimpleModelState(modelState.getRotation().compose(rootTransform), modelState.isUvLocked());
            }
            ImmutableMap.Builder bakedPartsBuilder = ImmutableMap.builder();
            for (Map.Entry<String, BlockModel> entry : this.children.entrySet()) {
                String name = entry.getKey();
                if (!context.isComponentVisible(name, true)) continue;
                BlockModel model = entry.getValue();
                bakedPartsBuilder.put((Object)name, (Object)model.bake(bakery, model, spriteGetter, modelState, true));
            }
            ImmutableMap bakedParts = bakedPartsBuilder.build();
            ImmutableList.Builder itemPassesBuilder = ImmutableList.builder();
            for (String name : this.itemPasses) {
                BakedModel model = (BakedModel)bakedParts.get((Object)name);
                if (model == null) {
                    throw new IllegalStateException("Specified \"" + name + "\" in \"item_render_order\", but that is not a child of this model.");
                }
                itemPassesBuilder.add((Object)model);
            }
            return new Baked(context.useAmbientOcclusion(), context.isGui3d(), context.useBlockLight(), particle, overrides, context.getTransforms(), (Map<String, BakedModel>)bakedParts, (List<BakedModel>)itemPassesBuilder.build());
        }

        private static class Baked
        implements IDynamicBakedModel {
            private final boolean isAmbientOcclusion;
            private final boolean isGui3d;
            private final boolean isSideLit;
            private final TextureAtlasSprite particle;
            private final ItemOverrides overrides;
            private final ItemTransforms transforms;
            private final Map<String, BakedModel> children;
            private final List<BakedModel> itemPasses;

            public Baked(boolean useAO, boolean isGui3d, boolean isSideLit, TextureAtlasSprite particle, ItemOverrides overrides, ItemTransforms transforms, Map<String, BakedModel> children, List<BakedModel> itemPasses) {
                this.isAmbientOcclusion = useAO;
                this.isGui3d = isGui3d;
                this.isSideLit = isSideLit;
                this.particle = particle;
                this.overrides = overrides;
                this.transforms = transforms;
                this.children = children;
                this.itemPasses = itemPasses;
            }

            public List<BakedQuad> getQuads(BlockState state, Direction side, RandomSource rand, ModelData data, RenderType renderType) {
                ArrayList<List> quadLists = new ArrayList<List>();
                for (Map.Entry<String, BakedModel> entry : this.children.entrySet()) {
                    String name = entry.getKey();
                    if (Minecraft.useFancyGraphics() ? name.endsWith("_fast") : name.endsWith("_fancy")) continue;
                    BakedModel model = entry.getValue();
                    if (renderType != null && (state == null || !model.getRenderTypes(state, rand, data).contains(renderType))) continue;
                    quadLists.add(model.getQuads(state, side, rand, Data.resolve(data, name), renderType));
                }
                return ConcatenatedListView.of(quadLists);
            }

            public List<BakedModel> getRenderPasses(ItemStack itemStack, boolean fabulous) {
                return this.itemPasses;
            }

            public boolean useAmbientOcclusion() {
                return this.isAmbientOcclusion;
            }

            public boolean isGui3d() {
                return this.isGui3d;
            }

            public boolean usesBlockLight() {
                return this.isSideLit;
            }

            public boolean isCustomRenderer() {
                return false;
            }

            public TextureAtlasSprite getParticleIcon() {
                return this.particle;
            }

            public ItemOverrides getOverrides() {
                return this.overrides;
            }

            public ItemTransforms getTransforms() {
                return this.transforms;
            }

            public ChunkRenderTypeSet getRenderTypes(BlockState state, RandomSource rand, ModelData data) {
                ArrayList<ChunkRenderTypeSet> sets = new ArrayList<ChunkRenderTypeSet>();
                for (Map.Entry<String, BakedModel> entry : this.children.entrySet()) {
                    sets.add(entry.getValue().getRenderTypes(state, rand, Data.resolve(data, entry.getKey())));
                }
                return ChunkRenderTypeSet.union(sets);
            }

            public BakedModel getPart(String name) {
                return this.children.get(name);
            }
        }
    }
}

