/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.core.platform;

import java.util.Optional;
import java.util.OptionalInt;
import java.util.function.Consumer;
import java.util.function.Function;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleMenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.MenuConstructor;
import net.minecraft.world.item.AxeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.HitResult;
import net.neoforged.neoforge.common.CommonHooks;
import net.neoforged.neoforge.common.ItemAbilities;
import net.neoforged.neoforge.event.entity.player.CriticalHitEvent;
import shetiphian.core.common.UseContext;
import shetiphian.core.common.block.IEnhancedRotation;
import shetiphian.core.platform.ICommonHelper;

public class NeoForgeCommonHelper
implements ICommonHelper {
    @Override
    public Optional<Float> getCriticalHit(Player player, Entity target, boolean vanillaCritical, float damageModifier) {
        CriticalHitEvent critEvent = CommonHooks.fireCriticalHit((Player)player, (Entity)target, (boolean)vanillaCritical, (float)damageModifier);
        return critEvent.isCriticalHit() ? Optional.of(Float.valueOf(critEvent.getDamageMultiplier())) : Optional.empty();
    }

    @Override
    public ItemStack getPickBlock(BlockState state, LevelReader world, BlockPos pos, Player player, HitResult target) {
        return state.getCloneItemStack(target, world, pos, player);
    }

    @Override
    public BlockState rotate(BlockState state, LevelAccessor world, BlockPos pos, Rotation rotation, UseOnContext context) {
        Block block = state.getBlock();
        if (block instanceof IEnhancedRotation) {
            IEnhancedRotation enhancedRotation = (IEnhancedRotation)block;
            return enhancedRotation.rotate(state, world, pos, rotation, context);
        }
        return state.rotate(world, pos, rotation);
    }

    @Override
    public Function<Block, Optional<BlockState>> getLogStrippingProcessor(Item axeItem, Level world) {
        UseContext context = new UseContext(world, null, new ItemStack((ItemLike)axeItem));
        return arg_0 -> NeoForgeCommonHelper.lambda$getLogStrippingProcessor$0((UseOnContext)context, arg_0);
    }

    @Override
    public OptionalInt openMenu(ServerPlayer player, Component title, MenuConstructor constructor, Consumer<FriendlyByteBuf> extraDataWriter) {
        return this.openMenu(player, (MenuProvider)new SimpleMenuProvider(constructor, title), extraDataWriter);
    }

    @Override
    public OptionalInt openMenu(ServerPlayer player, MenuProvider provider, Consumer<FriendlyByteBuf> extraDataWriter) {
        if (extraDataWriter == null) {
            return player.openMenu(provider);
        }
        return player.openMenu(provider, extraDataWriter::accept);
    }

    private static /* synthetic */ Optional lambda$getLogStrippingProcessor$0(UseOnContext context, Block unstripped) {
        BlockState result = unstripped.defaultBlockState().getToolModifiedState(context, ItemAbilities.AXE_STRIP, true);
        if (result == null) {
            result = AxeItem.getAxeStrippingState((BlockState)unstripped.defaultBlockState());
        }
        return Optional.ofNullable(result);
    }
}

