/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.core.platform;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import net.minecraft.client.Minecraft;
import net.minecraft.client.color.item.ItemColors;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.ModelBlockRenderer;
import net.minecraft.client.renderer.block.model.BlockModel;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.bus.api.Event;
import net.neoforged.neoforge.client.event.ContainerScreenEvent;
import net.neoforged.neoforge.client.model.data.ModelData;
import net.neoforged.neoforge.client.model.data.ModelProperty;
import net.neoforged.neoforge.common.NeoForge;
import shetiphian.core.client.model.RetexturedBlockModel;
import shetiphian.core.client.model.data.RenderData;
import shetiphian.core.platform.IClientHelper;
import shetiphian.core.self.client.render.CustomRenderLayer;

public class NeoForgeClientHelper
implements IClientHelper {
    public static ModelProperty<RenderData> RENDER_DATA_WRAPPER = new ModelProperty();
    private static final Cache<RenderData, ModelData> DATA_CACHE = CacheBuilder.newBuilder().expireAfterWrite(5L, TimeUnit.MINUTES).build();

    @Override
    public RetexturedBlockModel makeRetexturedBlockModel(BlockModel base) {
        RetexturedBlockModel retexturedBlockModel = new RetexturedBlockModel(base.getParentLocation(), base.getElements(), base.textureMap, base.hasAmbientOcclusion(), base.getGuiLight(), base.getTransforms(), base.getOverrides());
        retexturedBlockModel.customData.copyFrom(base.customData);
        return retexturedBlockModel;
    }

    @Override
    public void fireContainerScreenRenderEvent(boolean background, AbstractContainerScreen<?> guiContainer, GuiGraphics guiGraphics, int mouseX, int mouseY) {
        if (background) {
            NeoForge.EVENT_BUS.post((Event)new ContainerScreenEvent.Render.Background(guiContainer, guiGraphics, mouseX, mouseY));
        } else {
            NeoForge.EVENT_BUS.post((Event)new ContainerScreenEvent.Render.Foreground(guiContainer, guiGraphics, mouseX, mouseY));
        }
    }

    @Override
    public List<RenderType> getLayers(BakedModel model, BlockState state, RandomSource random, RenderData renderData) {
        return model.getRenderTypes(state, random, this.getModelData(renderData)).asList();
    }

    @Override
    public void updateRenderData(BlockEntity tile) {
        tile.requestModelDataUpdate();
    }

    @Override
    public RenderType getLineType(double width) {
        return CustomRenderLayer.getLines(width);
    }

    @Override
    public RenderType getDepthlessLineType(double width) {
        return CustomRenderLayer.getDepthlessLines(width);
    }

    @Override
    public ItemColors getItemColors() {
        return Minecraft.getInstance().getItemColors();
    }

    @Override
    public void renderModel(ModelBlockRenderer renderer, PoseStack.Pose pose, VertexConsumer buffers, BlockState state, BakedModel model, float red, float green, float blue, int packedLight, int packedOverlay, RenderData renderData, RenderType renderType) {
        renderer.renderModel(pose, buffers, state, model, red, green, blue, packedLight, packedOverlay, this.getModelData(renderData), renderType);
    }

    public ModelData getModelData(RenderData renderData) {
        ModelData modelData = ModelData.EMPTY;
        if (renderData != null && !renderData.isEmpty()) {
            try {
                modelData = (ModelData)DATA_CACHE.get((Object)renderData, () -> ModelData.builder().with(RENDER_DATA_WRAPPER, (Object)renderData).build());
            }
            catch (ExecutionException executionException) {
                // empty catch block
            }
        }
        return modelData;
    }

    @Override
    public void tesselateBlock(ModelBlockRenderer renderer, BlockAndTintGetter world, BakedModel model, BlockState state, BlockPos pos, PoseStack poseStack, VertexConsumer buffers, boolean checkSides, RandomSource random, long seed, int packedOverlay, RenderData renderData, RenderType renderType) {
        renderer.tesselateBlock(world, model, state, pos, poseStack, buffers, checkSides, random, seed, packedOverlay, this.getModelData(renderData), renderType);
    }
}

