/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.core.platform;

import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.players.PlayerList;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.dimension.DimensionType;

public interface INetworkHelper {
    public void sendToServer(CustomPacketPayload var1);

    public void sendToPlayer(CustomPacketPayload var1, ServerPlayer var2);

    default public void sendToPlayer(CustomPacketPayload packet, UUID uuid) {
        for (ServerPlayer player : this.getPlayers()) {
            if (!player.getUUID().equals(uuid)) continue;
            this.sendToPlayer(packet, player);
            break;
        }
    }

    default public void sendToList(CustomPacketPayload packet, List<ServerPlayer> players) {
        for (ServerPlayer player : players) {
            this.sendToPlayer(packet, player);
        }
    }

    default public void sendToIdList(CustomPacketPayload packet, List<UUID> players) {
        for (ServerPlayer player : this.getPlayers()) {
            if (!players.contains(player.getUUID())) continue;
            this.sendToPlayer(packet, player);
        }
    }

    default public void sendToAll(CustomPacketPayload packet) {
        this.sendToList(packet, this.getPlayers());
    }

    default public void sendToAllAround(CustomPacketPayload packet, Entity entity, double range) {
        this.sendToAllAround(packet, entity.level().dimensionType(), entity.getX(), entity.getY(), entity.getZ(), range);
    }

    default public void sendToAllAround(CustomPacketPayload packet, DimensionType dimension, BlockPos pos, double range) {
        this.sendToAllAround(packet, dimension, pos.getX(), pos.getY(), pos.getZ(), range);
    }

    default public void sendToAllAround(CustomPacketPayload packet, DimensionType dimension, double x, double y, double z, double range) {
        for (ServerPlayer player : this.getPlayers()) {
            double posZ;
            double posY;
            double posX;
            if (player.level().dimensionType() != dimension || !((posX = x - player.getX()) * posX + (posY = y - player.getY()) * posY + (posZ = z - player.getZ()) * posZ < range * range)) continue;
            this.sendToPlayer(packet, player);
        }
    }

    default public void sendToDimension(CustomPacketPayload packet, DimensionType dimension) {
        for (ServerPlayer player : this.getPlayers()) {
            if (player.level().dimensionType() != dimension) continue;
            this.sendToPlayer(packet, player);
        }
    }

    default public List<ServerPlayer> getPlayers() {
        PlayerList playerList = null;
        try {
            playerList = this.getCurrentServer().getPlayerList();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return playerList != null ? playerList.getPlayers() : new ArrayList();
    }

    public MinecraftServer getCurrentServer();

    public boolean isClientReady();

    public void setClientReady(boolean var1);
}

