/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.core.platform;

import java.util.Optional;
import java.util.OptionalInt;
import java.util.function.Consumer;
import java.util.function.Function;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.MenuConstructor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.HitResult;
import org.jetbrains.annotations.Nullable;
import shetiphian.core.common.inventory.MenuProviderWithData;

public interface ICommonHelper {
    default public Optional<Float> getCriticalHit(Player player, Entity target, boolean vanillaCritical, float damageModifier) {
        return Optional.empty();
    }

    public ItemStack getPickBlock(BlockState var1, LevelReader var2, BlockPos var3, Player var4, HitResult var5);

    public BlockState rotate(BlockState var1, LevelAccessor var2, BlockPos var3, Rotation var4, @Nullable UseOnContext var5);

    public Function<Block, Optional<BlockState>> getLogStrippingProcessor(Item var1, Level var2);

    default public OptionalInt openMenu(Player player, Component title, MenuConstructor constructor, Consumer<FriendlyByteBuf> extraDataWriter) {
        OptionalInt optionalInt;
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            optionalInt = this.openMenu(serverPlayer, title, constructor, extraDataWriter);
        } else {
            optionalInt = OptionalInt.empty();
        }
        return optionalInt;
    }

    default public OptionalInt openMenu(Player player, MenuProvider provider, Consumer<FriendlyByteBuf> extraDataWriter) {
        OptionalInt optionalInt;
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            optionalInt = this.openMenu(serverPlayer, provider, extraDataWriter);
        } else {
            optionalInt = OptionalInt.empty();
        }
        return optionalInt;
    }

    default public OptionalInt openMenu(Player player, MenuProviderWithData provider) {
        OptionalInt optionalInt;
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            optionalInt = this.openMenu(serverPlayer, (MenuProvider)provider, provider::write);
        } else {
            optionalInt = OptionalInt.empty();
        }
        return optionalInt;
    }

    public OptionalInt openMenu(ServerPlayer var1, Component var2, MenuConstructor var3, Consumer<FriendlyByteBuf> var4);

    public OptionalInt openMenu(ServerPlayer var1, MenuProvider var2, Consumer<FriendlyByteBuf> var3);
}

