/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.core.network;

import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import org.apache.commons.lang3.tuple.Triple;
import shetiphian.core.ShetiPhianCore;
import shetiphian.core.common.PlayerConfigs;
import shetiphian.core.network.IConfigWrapper;
import shetiphian.core.network.PacketHelpers;

public record PacketPlayerConfig(Triple<ResourceLocation, Object, Byte> data) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<PacketPlayerConfig> ID = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"shetiphiancore", (String)"player_config"));
    public static final StreamCodec<RegistryFriendlyByteBuf, Triple<ResourceLocation, Object, Byte>> TRIPLE_DATA_CODEC = new StreamCodec<RegistryFriendlyByteBuf, Triple<ResourceLocation, Object, Byte>>(){

        public Triple<ResourceLocation, Object, Byte> decode(RegistryFriendlyByteBuf buffer) {
            return PacketPlayerConfig.decodeTriple(buffer);
        }

        public void encode(RegistryFriendlyByteBuf buffer, Triple<ResourceLocation, Object, Byte> data) {
            PacketPlayerConfig.encodeTriple(buffer, data);
        }
    };
    public static final StreamCodec<RegistryFriendlyByteBuf, PacketPlayerConfig> CODEC = StreamCodec.composite(TRIPLE_DATA_CODEC, PacketPlayerConfig::data, PacketPlayerConfig::new);

    public CustomPacketPayload.Type<PacketPlayerConfig> type() {
        return ID;
    }

    public static PacketPlayerConfig syncCustom(ResourceLocation identifier, Object value) {
        return new PacketPlayerConfig((Triple<ResourceLocation, Object, Byte>)Triple.of((Object)identifier, (Object)value, (Object)0));
    }

    public static PacketPlayerConfig sync(ResourceLocation identifier, boolean value) {
        return new PacketPlayerConfig((Triple<ResourceLocation, Object, Byte>)Triple.of((Object)identifier, (Object)value, (Object)1));
    }

    public static PacketPlayerConfig sync(ResourceLocation identifier, byte value) {
        return new PacketPlayerConfig((Triple<ResourceLocation, Object, Byte>)Triple.of((Object)identifier, (Object)value, (Object)2));
    }

    public static PacketPlayerConfig sync(ResourceLocation identifier, short value) {
        return new PacketPlayerConfig((Triple<ResourceLocation, Object, Byte>)Triple.of((Object)identifier, (Object)value, (Object)3));
    }

    public static PacketPlayerConfig sync(ResourceLocation identifier, int value) {
        return new PacketPlayerConfig((Triple<ResourceLocation, Object, Byte>)Triple.of((Object)identifier, (Object)value, (Object)4));
    }

    public static PacketPlayerConfig sync(ResourceLocation identifier, long value) {
        return new PacketPlayerConfig((Triple<ResourceLocation, Object, Byte>)Triple.of((Object)identifier, (Object)value, (Object)5));
    }

    public static PacketPlayerConfig sync(ResourceLocation identifier, double value) {
        return new PacketPlayerConfig((Triple<ResourceLocation, Object, Byte>)Triple.of((Object)identifier, (Object)value, (Object)6));
    }

    public static PacketPlayerConfig sync(ResourceLocation identifier, float value) {
        return new PacketPlayerConfig((Triple<ResourceLocation, Object, Byte>)Triple.of((Object)identifier, (Object)Float.valueOf(value), (Object)7));
    }

    public static PacketPlayerConfig sync(ResourceLocation identifier, String value) {
        return new PacketPlayerConfig((Triple<ResourceLocation, Object, Byte>)Triple.of((Object)identifier, (Object)value, (Object)8));
    }

    public static PacketPlayerConfig sync(ResourceLocation identifier, ResourceLocation value) {
        return new PacketPlayerConfig((Triple<ResourceLocation, Object, Byte>)Triple.of((Object)identifier, (Object)value, (Object)9));
    }

    public static PacketPlayerConfig sync(ResourceLocation identifier, ItemStack value) {
        return new PacketPlayerConfig((Triple<ResourceLocation, Object, Byte>)Triple.of((Object)identifier, (Object)value, (Object)10));
    }

    public static PacketPlayerConfig sync(ResourceLocation identifier, UUID value) {
        return new PacketPlayerConfig((Triple<ResourceLocation, Object, Byte>)Triple.of((Object)identifier, (Object)value, (Object)11));
    }

    public static PacketPlayerConfig sync(ResourceLocation identifier, CompoundTag value) {
        return new PacketPlayerConfig((Triple<ResourceLocation, Object, Byte>)Triple.of((Object)identifier, (Object)value, (Object)12));
    }

    private static void encodeTriple(RegistryFriendlyByteBuf buffer, Triple<ResourceLocation, Object, Byte> data) {
        buffer.writeResourceLocation((ResourceLocation)data.getLeft());
        buffer.writeByte(((Byte)data.getRight()).byteValue());
        switch ((Byte)data.getRight()) {
            case 0: {
                IConfigWrapper wrapper = PlayerConfigs.getConfigWrapper((ResourceLocation)data.getLeft());
                if (wrapper != null) {
                    wrapper.toBytes((ResourceLocation)data.getLeft(), data.getMiddle(), (FriendlyByteBuf)buffer);
                    break;
                }
                ShetiPhianCore.LOGGER.error("Error syncing config; Client missing IConfigWrapper registration for: {}", data.getLeft());
                break;
            }
            case 1: {
                buffer.writeBoolean(((Boolean)data.getMiddle()).booleanValue());
                break;
            }
            case 2: {
                buffer.writeByte(((Byte)data.getMiddle()).byteValue());
                break;
            }
            case 3: {
                buffer.writeShort((int)((Short)data.getMiddle()).shortValue());
                break;
            }
            case 4: {
                buffer.writeVarInt(((Integer)data.getMiddle()).intValue());
                break;
            }
            case 5: {
                buffer.writeVarLong(((Long)data.getMiddle()).longValue());
                break;
            }
            case 6: {
                buffer.writeDouble(((Double)data.getMiddle()).doubleValue());
                break;
            }
            case 7: {
                buffer.writeFloat(((Float)data.getMiddle()).floatValue());
                break;
            }
            case 8: {
                PacketHelpers.STRING_CODEC.encode((Object)buffer, (Object)((String)data.getMiddle()));
                break;
            }
            case 9: {
                buffer.writeResourceLocation((ResourceLocation)data.getMiddle());
                break;
            }
            case 10: {
                ItemStack.OPTIONAL_STREAM_CODEC.encode((Object)buffer, (Object)((ItemStack)data.getMiddle()));
                break;
            }
            case 11: {
                buffer.writeUUID((UUID)data.getMiddle());
                break;
            }
            case 12: {
                buffer.writeNbt((Tag)((CompoundTag)data.getMiddle()));
            }
        }
    }

    private static Triple<ResourceLocation, Object, Byte> decodeTriple(RegistryFriendlyByteBuf buffer) {
        ResourceLocation identifier = buffer.readResourceLocation();
        byte type = buffer.readByte();
        Object object = null;
        switch (type) {
            case 0: {
                IConfigWrapper wrapper = PlayerConfigs.getConfigWrapper(identifier);
                if (wrapper != null) {
                    object = wrapper.fromBytes(identifier, (FriendlyByteBuf)buffer);
                    break;
                }
                ShetiPhianCore.LOGGER.error("Error syncing config; Server missing IConfigWrapper registration for: {}", (Object)identifier);
                break;
            }
            case 1: {
                object = buffer.readBoolean();
                break;
            }
            case 2: {
                object = buffer.readByte();
                break;
            }
            case 3: {
                object = buffer.readShort();
                break;
            }
            case 4: {
                object = buffer.readVarInt();
                break;
            }
            case 5: {
                object = buffer.readVarLong();
                break;
            }
            case 6: {
                object = buffer.readDouble();
                break;
            }
            case 7: {
                object = Float.valueOf(buffer.readFloat());
                break;
            }
            case 8: {
                object = PacketHelpers.STRING_CODEC.decode((Object)buffer);
                break;
            }
            case 9: {
                object = buffer.readResourceLocation();
                break;
            }
            case 10: {
                object = ItemStack.OPTIONAL_STREAM_CODEC.decode((Object)buffer);
                break;
            }
            case 11: {
                object = buffer.readUUID();
                break;
            }
            case 12: {
                object = buffer.readNbt();
            }
        }
        return Triple.of((Object)identifier, (Object)object, (Object)type);
    }
}

