/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.core.mixins;

import com.google.common.base.Strings;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.StateHolder;
import net.minecraft.world.level.block.state.properties.Property;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import shetiphian.core.ShetiPhianCore;

@Mixin(value={StateDefinition.Builder.class})
public abstract class SPC_Fix_StateDefinitionDupe<O, S extends StateHolder<O, S>> {
    @Unique
    private static final Cache<String, Boolean> ERROR_CACHE = CacheBuilder.newBuilder().expireAfterWrite(5L, TimeUnit.MINUTES).build();
    @Shadow
    @Final
    private O owner;
    @Shadow
    @Final
    private Map<String, Property<?>> properties;

    @Shadow
    protected abstract <T extends Comparable<T>> void validateProperty(Property<T> var1);

    @Inject(method={"add"}, at={@At(value="HEAD")}, cancellable=true)
    private void shetiphiancore_add(Property<?>[] properties, CallbackInfoReturnable<StateDefinition.Builder<O, S>> cir) {
        for (Property<?> property : properties) {
            String name = property.getName();
            if (!property.equals(this.properties.get(name))) {
                this.validateProperty(property);
                this.properties.put(name, property);
                continue;
            }
            String className = this.owner.getClass().getCanonicalName();
            if (Strings.isNullOrEmpty((String)className)) {
                className = this.owner.getClass().getName();
            }
            if (Strings.isNullOrEmpty((String)className) || ERROR_CACHE.getIfPresent((Object)className) != null) continue;
            ERROR_CACHE.put((Object)className, (Object)true);
            ShetiPhianCore.LOGGER.info("Skipping property '" + name + "' as '" + className + "' already contains this exact property. It was likely added to the parent by another mod, and will cause a crash if added again. -ShetiPhian");
        }
        cir.setReturnValue((Object)((StateDefinition.Builder)this));
        cir.cancel();
    }
}

