/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.core.mixins;

import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.CarpetBlock;
import net.minecraft.world.level.block.ScaffoldingBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.EntityCollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import shetiphian.core.self.Configs;

@Mixin(value={BlockBehaviour.class})
public class SPC_CarpetPassthrough {
    @Inject(method={"getCollisionShape"}, at={@At(value="HEAD")}, cancellable=true)
    private void shetiphiancore_getCollisionShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context, CallbackInfoReturnable<VoxelShape> cir) {
        if (state.getBlock() instanceof CarpetBlock && Configs.CORE_EDITS.enableCarpetPassthrough.get().booleanValue() && world.getBlockState(pos.below()).getBlock() instanceof ScaffoldingBlock) {
            Entity entity;
            if (context.isDescending()) {
                cir.setReturnValue((Object)Shapes.empty());
                cir.cancel();
            }
            if (context instanceof EntityCollisionContext && (entity = ((EntityCollisionContext)context).getEntity()) != null && entity.getDeltaMovement().y > 0.0) {
                cir.setReturnValue((Object)Shapes.empty());
                cir.cancel();
            }
        }
    }
}

