/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.core.common.tileentity;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.util.Mth;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import shetiphian.core.common.Helpers;
import shetiphian.core.common.tileentity.TileEntityBase;

public class TileEntityExtendedRedstone
extends TileEntityBase {
    private final int MULTIPLIER;
    private final int MAXIMUM;
    private int redstone = 0;
    private boolean enabled = true;

    public TileEntityExtendedRedstone(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        this(type, pos, state, 5);
    }

    public TileEntityExtendedRedstone(BlockEntityType<?> type, BlockPos pos, BlockState state, int multiplier) {
        super(type, pos, state);
        this.MULTIPLIER = multiplier;
        this.MAXIMUM = 15 * this.MULTIPLIER;
    }

    @Override
    protected void buildNBT(CompoundTag nbtTag, HolderLookup.Provider provider) {
        nbtTag.putInt("redstone", this.redstone);
    }

    @Override
    protected void processNBT(CompoundTag nbtTag, HolderLookup.Provider provider) {
        this.redstone = nbtTag.getInt("redstone");
    }

    public int getExPower() {
        return Mth.clamp((int)this.redstone, (int)0, (int)this.MAXIMUM);
    }

    public int getRSPower() {
        return Mth.clamp((int)(this.redstone / this.MULTIPLIER), (int)0, (int)15);
    }

    public void setExPower(int redstone) {
        this.redstone = Mth.clamp((int)redstone, (int)0, (int)this.MAXIMUM);
    }

    public void setRSPower(int redstone) {
        this.redstone = Mth.clamp((int)redstone, (int)0, (int)15) * this.MULTIPLIER;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public boolean updatePower() {
        int powerIn;
        int newPower;
        int currentPower;
        if (this.level != null && !this.level.isClientSide() && (currentPower = this.getExPower()) != (newPower = Mth.clamp((int)((powerIn = this.isEnabled() ? this.doPowerCalculation() : 0) - 1), (int)0, (int)this.MAXIMUM))) {
            this.setExPower(newPower);
            Helpers.syncTile(this);
            this.level.updateNeighborsAt(this.worldPosition, this.getBlockState().getBlock());
            for (Direction direction : Direction.values()) {
                this.level.updateNeighborsAt(this.worldPosition.relative(direction), this.getBlockState().getBlock());
            }
            return true;
        }
        return false;
    }

    private int doPowerCalculation() {
        Direction direction;
        int power = 0;
        Direction[] directionArray = Direction.values();
        int n = directionArray.length;
        for (int i = 0; i < n && (power = Math.max(power, this.getPowerAt(this.worldPosition.relative(direction = directionArray[i]), direction))) < this.MAXIMUM; ++i) {
        }
        return Math.min(power, this.MAXIMUM);
    }

    private int getPowerAt(BlockPos pos, Direction direction) {
        if (this.level != null) {
            BlockEntity tile = this.level.getBlockEntity(pos);
            if (tile instanceof TileEntityExtendedRedstone) {
                return ((TileEntityExtendedRedstone)tile).getExPower();
            }
            return this.level.getSignal(pos, direction) * this.MULTIPLIER;
        }
        return 0;
    }
}

