/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.core.common.setup;

import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.core.Holder;

public class RosterObject<T>
implements Supplier<T> {
    protected final String id;
    protected Supplier<T> value;

    protected RosterObject(String id) {
        this.id = id;
    }

    public String id() {
        return this.id;
    }

    public void wrap(Function<String, Supplier<T>> function) {
        if (this.value == null) {
            this.value = function.apply(this.id);
        }
    }

    public void load(Function<String, T> function) {
        if (this.value == null) {
            Object loaded = function.apply(this.id);
            this.value = () -> loaded;
        }
    }

    @Override
    public T get() {
        return this.value.get();
    }

    public Holder<T> holder() {
        return Holder.direct(this.get());
    }

    public static <T> RosterObject<T> of(String id) {
        return new RosterObject<T>(id);
    }
}

