/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.core.common.setup;

import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.damagesource.DamageType;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.properties.BlockSetType;
import net.minecraft.world.level.block.state.properties.WoodType;

public class RegistryHelper {
    private final String modId;

    public RegistryHelper(String modId) {
        this.modId = modId;
    }

    public ResourceKey<DamageType> addDamageType(String id) {
        return ResourceKey.create((ResourceKey)Registries.DAMAGE_TYPE, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)this.modId, (String)id));
    }

    public BlockSetType addSetType(String id, boolean canOpenByHand, SoundType blockSound, boolean isMetal) {
        BlockSetType BASE = isMetal ? BlockSetType.IRON : BlockSetType.OAK;
        return BlockSetType.register((BlockSetType)new BlockSetType(ResourceLocation.fromNamespaceAndPath((String)this.modId, (String)id).toString(), canOpenByHand, BASE.canOpenByWindCharge(), BASE.canButtonBeActivatedByArrows(), BASE.pressurePlateSensitivity(), blockSound, BASE.doorClose(), BASE.doorOpen(), BASE.trapdoorClose(), BASE.trapdoorOpen(), BASE.pressurePlateClickOff(), BASE.pressurePlateClickOn(), BASE.buttonClickOff(), BASE.buttonClickOn()));
    }

    public WoodType addWoodType(String id, BlockSetType type) {
        return WoodType.register((WoodType)new WoodType(ResourceLocation.fromNamespaceAndPath((String)this.modId, (String)id).toString(), type));
    }
}

