/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.core.common.setup;

import java.lang.reflect.Field;
import java.util.function.Supplier;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import shetiphian.core.common.ITabFiller;

public class CreativeTabHelper {
    protected static CreativeModeTab create(String id, Supplier<ItemStack> icon, CreativeModeTab.DisplayItemsGenerator entries) {
        return CreativeModeTab.builder((CreativeModeTab.Row)CreativeModeTab.Row.TOP, (int)0).title((Component)Component.translatable((String)("itemGroup." + id))).icon(icon).displayItems(entries).build();
    }

    protected static ItemStack getIcon(Object ... icon) {
        for (Object object : icon) {
            if (object instanceof Supplier) {
                object = ((Supplier)object).get();
            }
            if (object instanceof Block) {
                Block block = (Block)object;
                return new ItemStack((ItemLike)block);
            }
            if (object instanceof Item) {
                Item item = (Item)object;
                return new ItemStack((ItemLike)item);
            }
            if (!(object instanceof ItemStack)) continue;
            ItemStack stack = (ItemStack)object;
            return stack;
        }
        return ItemStack.EMPTY;
    }

    protected static void addItem(CreativeModeTab.Output entries, CreativeModeTab.ItemDisplayParameters context, Item item) {
        if (item instanceof ITabFiller) {
            ((ITabFiller)item).fillCreativeTab(entries, context);
        } else {
            entries.accept(new ItemStack((ItemLike)item));
        }
    }

    protected static void addItems(CreativeModeTab.Output entries, CreativeModeTab.ItemDisplayParameters context, Item ... items) {
        for (Item item : items) {
            CreativeTabHelper.addItem(entries, context, item);
        }
    }

    protected static void addItems(CreativeModeTab.Output entries, CreativeModeTab.ItemDisplayParameters context, Supplier<Item> ... items) {
        for (Supplier<Item> item : items) {
            CreativeTabHelper.addItem(entries, context, item.get());
        }
    }

    protected static void addItemsFrom(CreativeModeTab.Output entries, CreativeModeTab.ItemDisplayParameters context, Class<?> holder) {
        for (Field field : holder.getFields()) {
            Class<?> fClass = field.getType();
            if (Supplier.class.isAssignableFrom(fClass)) {
                try {
                    Object object = ((Supplier)field.get(fClass)).get();
                    if (!(object instanceof Item)) continue;
                    Item item = (Item)object;
                    CreativeTabHelper.addItem(entries, context, item);
                }
                catch (Exception exception) {}
                continue;
            }
            if (!Item.class.isAssignableFrom(fClass)) continue;
            try {
                CreativeTabHelper.addItem(entries, context, (Item)field.get(fClass));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

