/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.core.common.setup;

import com.google.common.base.Strings;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.util.concurrent.TimeUnit;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigObject<T>
implements Supplier<T> {
    private final String key;
    private final T defaultValue;
    private T fallbackValue;
    private final Predicate<Object> validator;
    private final String comment;
    private final String langKey;
    private Supplier<T> holder;
    private BiConsumer<Supplier<T>, T> updater;
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"ConfigObject");
    private static final Cache<ConfigObject<?>, Byte> ERROR_COOLDOWN = CacheBuilder.newBuilder().expireAfterWrite(5L, TimeUnit.MINUTES).build();
    private static final Predicate<Object> ACCEPT_ALL = object -> true;

    private ConfigObject(String key, T defaultValue, Predicate<Object> validator, String ... comment_langKey) {
        this.key = key;
        this.defaultValue = defaultValue;
        this.fallbackValue = defaultValue;
        this.validator = validator;
        this.comment = Strings.emptyToNull(comment_langKey.length >= 1 ? comment_langKey[0] : null);
        this.langKey = Strings.emptyToNull(comment_langKey.length >= 2 ? comment_langKey[1] : null);
    }

    public ConfigObject<T> fallbackTo(T value) {
        if (value != null) {
            this.fallbackValue = value;
        }
        return this;
    }

    public String getKey() {
        return this.key;
    }

    public T getDefault() {
        return this.defaultValue;
    }

    public T min() {
        return this.defaultValue;
    }

    public T max() {
        return this.defaultValue;
    }

    public Predicate<Object> validator() {
        return this.validator;
    }

    public String comment() {
        return this.comment;
    }

    public String langKey() {
        return this.langKey;
    }

    public void wrap(Function<ConfigObject<T>, Supplier<T>> function) {
        this.holder = function.apply(this);
    }

    public <S extends Supplier<T>> void wrap(Function<ConfigObject<T>, S> function, BiConsumer<S, T> updater) {
        this.holder = (Supplier)function.apply(this);
        this.updater = updater;
    }

    public void update(T value) {
        if (this.updater != null && this.holder != null) {
            this.updater.accept((Supplier<Supplier<T>>)this.holder, (Supplier<T>)value);
        }
    }

    @Override
    public T get() {
        block3: {
            if (this.holder != null) {
                try {
                    return this.holder.get();
                }
                catch (Exception exception) {
                    if (ERROR_COOLDOWN.getIfPresent((Object)this) != null) break block3;
                    ERROR_COOLDOWN.put((Object)this, (Object)0);
                    LOGGER.warn("Config Error: '{}' accessed before being loaded, falling back to '{}'", (Object)this.key, this.fallbackValue);
                    LOGGER.warn("\tif this happened during load, its likely an intermod race condition and should be fine to ignore");
                }
            }
        }
        return this.fallbackValue;
    }

    public static <T> ConfigObject<T> of(String key, T defaultValue, String ... comment_langKey) {
        return new ConfigObject<T>(key, defaultValue, ACCEPT_ALL, comment_langKey);
    }

    public static <T> ConfigObject<T> of(String key, T defaultValue, Predicate<Object> validator, String ... comment_langKey) {
        return new ConfigObject<T>(key, defaultValue, validator, comment_langKey);
    }

    public static <T> ConfigObject<T> of(String key, T defaultValue, T min, T max, String ... comment_langKey) {
        return new RangedConfigObject<T>(key, defaultValue, min, max, ACCEPT_ALL, comment_langKey);
    }

    public static <T> ConfigObject<T> of(String key, T defaultValue, T min, T max, Predicate<Object> validator, String ... comment_langKey) {
        return new RangedConfigObject<T>(key, defaultValue, min, max, validator, comment_langKey);
    }

    private static class RangedConfigObject<T>
    extends ConfigObject<T> {
        private final T rangeMin;
        private final T rangeMax;

        private RangedConfigObject(String key, T defaultValue, T min, T max, Predicate<Object> validator, String ... comment_langKey) {
            super(key, defaultValue, validator, comment_langKey);
            this.rangeMin = min;
            this.rangeMax = max;
        }

        @Override
        public T min() {
            return this.rangeMin;
        }

        @Override
        public T max() {
            return this.rangeMax;
        }
    }
}

