/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.core.common.rgb16;

import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.CustomData;
import shetiphian.core.common.rgb16.IRGB16;
import shetiphian.core.common.rgb16.IRGB16_Item;
import shetiphian.core.common.rgb16.ImmutableRGB16;
import shetiphian.core.common.rgb16.RGB16Helper;

public class RGB16StackHelper {
    public static ImmutableRGB16 readRGB16(ItemStack stack) {
        return (ImmutableRGB16)stack.get((DataComponentType)RGB16Helper.RGB16_DATA.get());
    }

    public static ImmutableRGB16 readOrDefaultRGB16(ItemStack stack, short defaultIndex) {
        ImmutableRGB16 rgb16 = RGB16StackHelper.readRGB16(stack);
        if (rgb16 == null) {
            rgb16 = new ImmutableRGB16(defaultIndex);
            stack.set((DataComponentType)RGB16Helper.RGB16_DATA.get(), (Object)rgb16);
        }
        return rgb16;
    }

    public static short readColor(ItemStack stack) {
        return RGB16StackHelper.readColor(stack, (short)4095);
    }

    public static short readColor(ItemStack stack, short defaultIndex) {
        return RGB16StackHelper.readOrDefaultRGB16(stack, defaultIndex).getIndex();
    }

    public static byte readSimpleColor(ItemStack stack) {
        return RGB16StackHelper.readSimpleColor(stack, (short)4095);
    }

    public static byte readSimpleColor(ItemStack stack, short defaultIndex) {
        return RGB16Helper.getSimpleColor(RGB16StackHelper.readOrDefaultRGB16(stack, defaultIndex).getIndex());
    }

    public static boolean writeRGB16(ItemStack stack, IRGB16 rgb16) {
        ImmutableRGB16 current = RGB16StackHelper.readRGB16(stack);
        if (current != null && current.getIndex() == rgb16.getIndex()) {
            return false;
        }
        stack.set((DataComponentType)RGB16Helper.RGB16_DATA.get(), (Object)rgb16.immutable());
        return true;
    }

    public static boolean writeColor(ItemStack stack, short rgbIndex) {
        ImmutableRGB16 current = RGB16StackHelper.readRGB16(stack);
        if (current != null && current.getIndex() == rgbIndex) {
            return false;
        }
        stack.set((DataComponentType)RGB16Helper.RGB16_DATA.get(), (Object)new ImmutableRGB16(rgbIndex));
        return true;
    }

    public static boolean isSame(ItemStack stackA, ItemStack stackB) {
        IRGB16 iRGB16;
        IRGB16 iRGB162;
        if (stackA.isEmpty() || stackB.isEmpty()) {
            return false;
        }
        Item item = stackA.getItem();
        if (item instanceof IRGB16_Item) {
            IRGB16_Item itemA = (IRGB16_Item)item;
            iRGB162 = itemA.getRGB16(stackA);
        } else {
            iRGB162 = RGB16StackHelper.readRGB16(stackA);
        }
        ImmutableRGB16 rgb16A = iRGB162;
        Item item2 = stackB.getItem();
        if (item2 instanceof IRGB16_Item) {
            IRGB16_Item itemB = (IRGB16_Item)item2;
            iRGB16 = itemB.getRGB16(stackB);
        } else {
            iRGB16 = RGB16StackHelper.readRGB16(stackB);
        }
        ImmutableRGB16 rgb16B = iRGB16;
        return RGB16StackHelper.isSame(rgb16A, rgb16B);
    }

    public static boolean isSame(IRGB16 rgb16A, IRGB16 rgb16B) {
        return rgb16A == rgb16B || rgb16A != null && rgb16B != null && rgb16A.getIndex() == rgb16B.getIndex();
    }

    public static void migrate(ItemStack stack) {
        if (stack.has(DataComponents.CUSTOM_DATA)) {
            CompoundTag tag = ((CustomData)stack.getOrDefault(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY)).copyTag();
            if (tag.contains("rgb16")) {
                stack.set((DataComponentType)RGB16Helper.RGB16_DATA.get(), (Object)new ImmutableRGB16(tag.getShort("rgb16")));
            }
            tag.remove("rgb16");
            tag.remove("rgbsimple");
            if (tag.isEmpty()) {
                stack.remove(DataComponents.CUSTOM_DATA);
            }
        }
    }
}

