/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.core.common.rgb16;

import java.util.Objects;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import shetiphian.core.common.rgb16.IRGB16;
import shetiphian.core.common.rgb16.ImmutableRGB16;
import shetiphian.core.common.rgb16.RGB16Helper;
import shetiphian.core.self.Configs;

public class RGB16
implements IRGB16 {
    private byte vRed;
    private byte vGreen;
    private byte vBlue;

    public RGB16() {
        this(RGB16Helper.getRandomValues());
    }

    public RGB16(int red, int green, int blue) {
        this(new byte[]{(byte)red, (byte)green, (byte)blue});
    }

    public RGB16(short rgbIndex) {
        this(RGB16Helper.getValuesFrom(rgbIndex));
    }

    public RGB16(String colorName) {
        this(RGB16Helper.getBaseValuesFrom(colorName));
    }

    public RGB16(DyeColor color) {
        this(color.getSerializedName());
    }

    public RGB16(int javaColor) {
        this(RGB16Helper.getValuesFrom(javaColor));
    }

    private RGB16(byte[] values) {
        this.vRed = values[0];
        this.vGreen = values[1];
        this.vBlue = values[2];
    }

    public boolean setRandomValues() {
        return this.setValues(RGB16Helper.getRandomValues());
    }

    public boolean setValues(int red, int green, int blue) {
        return this.setValues(RGB16Helper.clamp(red, green, blue));
    }

    public boolean setValues(short rgbIndex) {
        return this.setValues(RGB16Helper.getValuesFrom(rgbIndex));
    }

    public boolean setValues(String colorName) {
        return this.setValues(RGB16Helper.getBaseValuesFrom(colorName));
    }

    public boolean setValues(DyeColor color) {
        return this.setValues(color.getSerializedName());
    }

    public boolean setValues(int javaColor) {
        return this.setValues(RGB16Helper.getValuesFrom(javaColor));
    }

    private boolean setValues(byte[] values) {
        if (this.vRed != values[0] || this.vGreen != values[1] || this.vBlue != values[2]) {
            this.vRed = values[0];
            this.vGreen = values[1];
            this.vBlue = values[2];
            return true;
        }
        return false;
    }

    public boolean recolor(Player player, String colorName) {
        if (player != null) {
            if (Configs.Synced.getBlendMode(player) == Configs.BlendMode.RYB) {
                return player.isShiftKeyDown() ? this.setValues(colorName) : this.blend(colorName);
            }
            return player.isShiftKeyDown() ? this.subtract(colorName) : this.add(colorName);
        }
        return false;
    }

    public boolean add(int red, int green, int blue) {
        int nRed = this.vRed + red;
        int nGreen = this.vGreen + green;
        int nBlue = this.vBlue + blue;
        if (!(red == green && red == blue || nRed <= 15 && nGreen <= 15 && nBlue <= 15)) {
            int over = Math.max(nRed - 15, Math.max(nGreen - 15, nBlue - 15));
            nRed -= over;
            nGreen -= over;
            nBlue -= over;
        }
        return this.setValues(nRed, nGreen, nBlue);
    }

    public boolean subtract(int red, int green, int blue) {
        return this.setValues(this.vRed - red, this.vGreen - green, this.vBlue - blue);
    }

    public boolean blend(int red, int green, int blue) {
        return this.blend(red, green, blue, 0.25f);
    }

    public boolean blend(int red, int green, int blue, float ratio) {
        return RGB16Helper.blend(this, RGB16Helper.getIndexFor(red, green, blue), ratio);
    }

    public boolean add(Object color) {
        byte[] values = RGB16Helper.getValuesFrom(color);
        return values != null && this.add(values[0], values[1], values[2]);
    }

    public boolean subtract(Object color) {
        byte[] values = RGB16Helper.getValuesFrom(color);
        return values != null && this.subtract(values[0], values[1], values[2]);
    }

    public boolean blend(Object color) {
        return this.blend(color, 0.25f);
    }

    public boolean blend(Object color, float ratio) {
        byte[] values = RGB16Helper.getValuesFrom(color);
        return values != null && RGB16Helper.blend(this, RGB16Helper.getIndexFor(values), ratio);
    }

    @Override
    public byte getRed() {
        return this.vRed;
    }

    @Override
    public byte getGreen() {
        return this.vGreen;
    }

    @Override
    public byte getBlue() {
        return this.vBlue;
    }

    public String toString() {
        return String.format("RGB16[%s]", this.valueString());
    }

    public RGB16 copy() {
        return new RGB16(this.getValues());
    }

    @Override
    public RGB16 mutable() {
        return this;
    }

    @Override
    public ImmutableRGB16 immutable() {
        return new ImmutableRGB16(this.vRed, this.vGreen, this.vBlue);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object obj) {
        if (!(obj instanceof RGB16)) return false;
        RGB16 other = (RGB16)obj;
        if (this.vRed != other.vRed) return false;
        if (this.vGreen != other.vGreen) return false;
        if (this.vBlue != other.vBlue) return false;
        return true;
    }

    public int hashCode() {
        return Objects.hash(this.vRed, this.vGreen, this.vBlue);
    }
}

