/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.core.common.rgb16;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Objects;
import net.minecraft.world.item.DyeColor;
import shetiphian.core.common.rgb16.IRGB16;
import shetiphian.core.common.rgb16.RGB16;
import shetiphian.core.common.rgb16.RGB16Helper;

public record ImmutableRGB16(byte vRed, byte vGreen, byte vBlue) implements IRGB16
{
    public static final Codec<ImmutableRGB16> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.SHORT.fieldOf("index").forGetter(IRGB16::getIndex)).apply((Applicative)instance, ImmutableRGB16::new));

    public ImmutableRGB16 {
        vRed = (byte)Math.min(Math.max(vRed, 0), 15);
        vGreen = (byte)Math.min(Math.max(vGreen, 0), 15);
        vBlue = (byte)Math.min(Math.max(vBlue, 0), 15);
    }

    public ImmutableRGB16() {
        this(RGB16Helper.getRandomValues());
    }

    public ImmutableRGB16(int red, int green, int blue) {
        this(new byte[]{(byte)red, (byte)green, (byte)blue});
    }

    public ImmutableRGB16(short rgbIndex) {
        this(RGB16Helper.getValuesFrom(rgbIndex));
    }

    public ImmutableRGB16(String colorName) {
        this(RGB16Helper.getBaseValuesFrom(colorName));
    }

    public ImmutableRGB16(DyeColor color) {
        this(color.getSerializedName());
    }

    public ImmutableRGB16(int javaColor) {
        this(RGB16Helper.getValuesFrom(javaColor));
    }

    private ImmutableRGB16(byte[] values) {
        this(values[0], values[1], values[2]);
    }

    @Override
    public byte getRed() {
        return this.vRed;
    }

    @Override
    public byte getGreen() {
        return this.vGreen;
    }

    @Override
    public byte getBlue() {
        return this.vBlue;
    }

    @Override
    public String toString() {
        return String.format("ImmutableRGB16[%s]", this.valueString());
    }

    public ImmutableRGB16 copy() {
        return new ImmutableRGB16(this.getValues());
    }

    @Override
    public RGB16 mutable() {
        return new RGB16(this.getIndex());
    }

    @Override
    public ImmutableRGB16 immutable() {
        return this;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof ImmutableRGB16)) return false;
        ImmutableRGB16 other = (ImmutableRGB16)obj;
        if (this.vRed != other.vRed) return false;
        if (this.vGreen != other.vGreen) return false;
        if (this.vBlue != other.vBlue) return false;
        return true;
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.vRed, this.vGreen, this.vBlue);
    }
}

