/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.core.common.rgb16;

import java.util.Arrays;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.block.Block;
import shetiphian.core.SideExecutor;
import shetiphian.core.client.ColorHandler;
import shetiphian.core.common.IColored;
import shetiphian.core.common.rgb16.IRGB16_Item;
import shetiphian.core.common.rgb16.ImmutableRGB16;
import shetiphian.core.common.rgb16.RGB16;
import shetiphian.core.common.rgb16.RGB16Helper;
import shetiphian.core.common.rgb16.RGB16StackHelper;

public class BlockItemRGB16
extends BlockItem
implements IColored,
IRGB16_Item {
    private final short startColor;
    private int[] tintedIndexes;

    public BlockItemRGB16(Block block, Item.Properties properties, DyeColor color) {
        this(block, properties, RGB16Helper.getIndexFor(color));
    }

    public BlockItemRGB16(Block block, Item.Properties properties, RGB16 rgb16) {
        this(block, properties, rgb16.getIndex());
    }

    public BlockItemRGB16(Block block, Item.Properties properties, short index) {
        super(block, properties.component((DataComponentType)RGB16Helper.RGB16_DATA.get(), (Object)new ImmutableRGB16(index)));
        this.startColor = index;
        SideExecutor.runOnClient(() -> () -> ColorHandler.colorize(this));
    }

    public BlockItemRGB16 callback(Consumer<BlockItemRGB16> consumer) {
        consumer.accept(this);
        return this;
    }

    public BlockItemRGB16 tint(int ... indexes) {
        this.tintedIndexes = indexes;
        return this;
    }

    public void verifyComponentsAfterLoad(ItemStack stack) {
        super.verifyComponentsAfterLoad(stack);
        if (SideExecutor.isLogicalServer()) {
            RGB16StackHelper.migrate(stack);
        }
    }

    @Override
    public int getColorFor(IColored.Data data, int index) {
        if (!data.stack.isEmpty() && (this.tintedIndexes == null || Arrays.stream(this.tintedIndexes).anyMatch(value -> value == index))) {
            return RGB16Helper.getColor(this.getRGB16(data.stack).getIndex());
        }
        return -1;
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag flag) {
        tooltip.add((Component)Component.literal((String)RGB16Helper.getTooltip(this.getRGB16(stack).getIndex())));
        super.appendHoverText(stack, context, tooltip, flag);
    }

    @Override
    public short getStartingIndex(ItemStack stack) {
        return this.startColor;
    }

    @Override
    public boolean enableDyeRecipe(ItemStack stack) {
        return true;
    }

    @Override
    public boolean dyeUseChance(ItemStack stack) {
        return true;
    }

    @Override
    public double getDyeUseChance(ItemStack result, ItemStack dye, int dyeCounter) {
        if (result.getItem() == this && this.getRGB16(result).getIndex() == this.getStartingIndex(result)) {
            return 1.0;
        }
        return Math.max(0.0, 1.0 - 0.15 * (double)dyeCounter);
    }
}

