/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.core.common.item;

import com.google.common.base.Strings;
import java.util.List;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.TieredItem;
import net.minecraft.world.item.Tiers;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockState;
import shetiphian.core.SideExecutor;
import shetiphian.core.client.ClientStringUtil;
import shetiphian.core.common.item.ITooltipProvider;
import shetiphian.core.platform.Services;

public class ItemWrench
extends TieredItem {
    private ITooltipProvider tooltipProvider;
    private final String[] tooltipStrings = new String[]{null, null};

    public ItemWrench(Item.Properties properties) {
        super((Tier)Tiers.IRON, properties);
    }

    public ItemWrench(Tier tier, Item.Properties properties) {
        super(tier, properties);
    }

    public ItemWrench tooltip(ITooltipProvider tooltipProvider) {
        this.tooltipProvider = tooltipProvider;
        return this;
    }

    public ItemWrench tooltip(String normal, String shift) {
        this.tooltipStrings[0] = normal;
        this.tooltipStrings[1] = shift;
        return this;
    }

    public InteractionResult useOn(UseOnContext context) {
        Player player = context.getPlayer();
        Rotation direction = player != null && player.isShiftKeyDown() ? Rotation.COUNTERCLOCKWISE_90 : Rotation.CLOCKWISE_90;
        Level world = context.getLevel();
        BlockPos pos = context.getClickedPos();
        BlockState state = world.getBlockState(pos);
        BlockState result = Services.COMMON.rotate(state, (LevelAccessor)world, pos, direction, context);
        if (player != null) {
            player.swing(context.getHand());
        }
        if (result != state) {
            if (result != world.getBlockState(pos)) {
                world.setBlock(pos, result, 11);
            }
            result.handleNeighborChanged(world, pos, result.getBlock(), pos, false);
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag flag) {
        if (this.tooltipProvider == null && SideExecutor.isClient() && (this.tooltipStrings[0] != null || this.tooltipStrings[1] != null)) {
            this.generateTooltipProvider();
        }
        if (this.tooltipProvider != null) {
            this.tooltipProvider.build(stack, context, tooltip, flag);
        }
    }

    private void generateTooltipProvider() {
        boolean hasShift;
        boolean hasNormal = !Strings.isNullOrEmpty((String)this.tooltipStrings[0]);
        boolean bl = hasShift = !Strings.isNullOrEmpty((String)this.tooltipStrings[1]);
        if (hasNormal || hasShift) {
            this.tooltip((stack, world, tooltip, advanced) -> {
                if (hasShift && Screen.hasShiftDown()) {
                    ClientStringUtil.translateAndSplitTooltip(this.tooltipStrings[1], tooltip);
                } else {
                    if (hasNormal) {
                        ClientStringUtil.translateAndSplitTooltip(this.tooltipStrings[0], tooltip);
                    }
                    if (hasShift) {
                        tooltip.add(Component.translatable((String)"info.shetiphian.holdshift"));
                    }
                }
            });
        }
    }
}

