/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.core.common.item;

import java.util.Optional;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundSetEntityMotionPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.stats.Stats;
import net.minecraft.tags.EntityTypeTags;
import net.minecraft.tags.TagKey;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageType;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.boss.EnderDragonPart;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.entity.projectile.ProjectileDeflection;
import net.minecraft.world.item.DiggerItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.phys.Vec3;
import shetiphian.core.common.MyDamageSource;
import shetiphian.core.common.TagHelper;
import shetiphian.core.common.item.IMobDamageControl;
import shetiphian.core.platform.Services;

@Deprecated(forRemoval=true)
public abstract class ItemToolWithDamageSource
extends DiggerItem
implements IMobDamageControl {
    protected final SourceProvider provider;

    public ItemToolWithDamageSource(Tier tier, DamageSource damageSource, Item.Properties properties) {
        this(tier, damageSource, TagHelper.BLOCKS.DUMMY_TAG, properties);
    }

    public ItemToolWithDamageSource(Tier tier, DamageSource damageSource, TagKey<Block> blocks, Item.Properties properties) {
        super(tier, blocks, properties);
        this.provider = new SourceProvider(damageSource);
    }

    @Override
    public DamageSource getDamageSource(Player player, Entity target) {
        return this.provider.getFor((Entity)player);
    }

    public static boolean onLeftClickEntity(Player player, Entity target, DamageSource damageSource, ItemStack extraModifiers) {
        if (target.isAttackable() && !target.skipAttackInteraction((Entity)player)) {
            DamageSource source = new SourceProvider(damageSource).getFor((Entity)player);
            AttackValues values = ItemToolWithDamageSource.calculateBaseValues(player, target, source, extraModifiers);
            ItemToolWithDamageSource.attack(player, target, source, extraModifiers, values);
        }
        return true;
    }

    protected static AttackValues calculateBaseValues(Player player, Entity target, DamageSource damageSource, ItemStack extraModifiers) {
        AttackValues values = new AttackValues();
        values.damage = (float)player.getAttributeValue(Attributes.ATTACK_DAMAGE);
        values.bonusDamage = ItemToolWithDamageSource.getEnchantedDamage(player, target, values.damage, damageSource) - values.damage;
        if (extraModifiers != null) {
            values.bonusDamage += extraModifiers.getItem().getAttackDamageBonus(target, values.damage, damageSource);
        }
        values.strength = player.getAttackStrengthScale(0.5f);
        values.damage *= 0.2f + values.strength * values.strength * 0.8f;
        values.bonusDamage *= values.strength;
        player.resetAttackStrengthTicker();
        if (target instanceof LivingEntity) {
            values.knockback = (float)player.getAttributeValue(Attributes.ATTACK_KNOCKBACK);
            if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                values.knockback = EnchantmentHelper.modifyKnockback((ServerLevel)serverPlayer.serverLevel(), (ItemStack)player.getWeaponItem(), (Entity)target, (DamageSource)damageSource, (float)values.knockback);
                if (extraModifiers != null) {
                    values.knockback = EnchantmentHelper.modifyKnockback((ServerLevel)serverPlayer.serverLevel(), (ItemStack)extraModifiers, (Entity)target, (DamageSource)damageSource, (float)values.knockback);
                }
            }
        }
        return values;
    }

    protected float getBonusDamage(Player player, Entity target, DamageSource source, float damage, float bonusDamage) {
        return bonusDamage;
    }

    protected float getKnockback(Player player, Entity target, DamageSource source, float knockback) {
        return knockback;
    }

    protected static float getEnchantedDamage(Player player, Entity target, float damage, DamageSource damageSource) {
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            return EnchantmentHelper.modifyDamage((ServerLevel)serverPlayer.serverLevel(), (ItemStack)player.getWeaponItem(), (Entity)target, (DamageSource)damageSource, (float)damage);
        }
        return damage;
    }

    protected static boolean attack(Player player, Entity target, DamageSource damageSource, ItemStack extraModifiers, AttackValues values) {
        Projectile projectile;
        if (target.getType().is(EntityTypeTags.REDIRECTABLE_PROJECTILE) && target instanceof Projectile && (projectile = (Projectile)target).deflect(ProjectileDeflection.AIM_DEFLECT, (Entity)player, (Entity)player, true)) {
            player.level().playSound(null, player.getX(), player.getY(), player.getZ(), SoundEvents.PLAYER_ATTACK_NODAMAGE, player.getSoundSource());
            return false;
        }
        if (values.damage > 0.0f || values.bonusDamage > 0.0f) {
            return ItemToolWithDamageSource.preformDamage(player, target, damageSource, extraModifiers, values);
        }
        return false;
    }

    protected static boolean preformDamage(Player player, Entity target, DamageSource damageSource, ItemStack extraModifiers, AttackValues values) {
        ItemStack itemstack;
        Level world = player.level();
        ItemStack weapon = player.getWeaponItem();
        boolean isStrongAttack = values.strength > 0.9f;
        boolean hasKnockback = false;
        if (player.isSprinting() && isStrongAttack) {
            world.playSound(null, player.getX(), player.getY(), player.getZ(), SoundEvents.PLAYER_ATTACK_KNOCKBACK, player.getSoundSource(), 1.0f, 1.0f);
            hasKnockback = true;
        }
        values.damage += weapon.getItem().getAttackDamageBonus(target, values.damage, damageSource);
        boolean doBoostDamage = isStrongAttack && player.fallDistance > 0.0f && !player.onGround() && !player.onClimbable() && !player.isInWater() && !player.hasEffect(MobEffects.BLINDNESS) && !player.isPassenger() && target instanceof LivingEntity && !player.isSprinting();
        Optional<Float> eventResult = Services.COMMON.getCriticalHit(player, target, doBoostDamage, doBoostDamage ? 1.5f : 1.0f);
        if (eventResult.isPresent()) {
            values.damage *= eventResult.get().floatValue();
        } else {
            doBoostDamage = false;
        }
        float f3 = values.damage + values.bonusDamage;
        boolean isSweapAttack = false;
        double walked = player.walkDist - player.walkDistO;
        if (isStrongAttack && !doBoostDamage && !hasKnockback && player.onGround() && walked < (double)player.getSpeed() && (itemstack = player.getItemInHand(InteractionHand.MAIN_HAND)).getItem() instanceof SwordItem) {
            isSweapAttack = true;
        }
        float victimHealthPreAttack = 0.0f;
        if (target instanceof LivingEntity) {
            victimHealthPreAttack = ((LivingEntity)target).getHealth();
        }
        Vec3 vec3d = target.getDeltaMovement();
        boolean victimWasHurt = target.hurt(damageSource, f3);
        if (victimWasHurt) {
            LivingEntity living;
            values.knockback = values.knockback + (hasKnockback ? 1.0f : 0.0f);
            if (values.knockback > 0.0f) {
                if (target instanceof LivingEntity) {
                    ((LivingEntity)target).knockback((double)(values.knockback * 0.5f), (double)Mth.sin((float)(player.getYRot() * ((float)Math.PI / 180))), (double)(-Mth.cos((float)(player.getYRot() * ((float)Math.PI / 180)))));
                } else {
                    target.push((double)(-Mth.sin((float)(player.getYRot() * ((float)Math.PI / 180))) * values.knockback * 0.5f), 0.1, (double)(Mth.cos((float)(player.getYRot() * ((float)Math.PI / 180))) * values.knockback * 0.5f));
                }
                player.setDeltaMovement(player.getDeltaMovement().multiply(0.6, 1.0, 0.6));
                player.setSprinting(false);
            }
            if (isSweapAttack) {
                float f7 = 1.0f + (float)player.getAttributeValue(Attributes.SWEEPING_DAMAGE_RATIO) * values.damage;
                for (LivingEntity livingEntity : world.getEntitiesOfClass(LivingEntity.class, target.getBoundingBox().expandTowards(1.0, 0.25, 1.0))) {
                    if (livingEntity == player || livingEntity == target || player.isAlliedTo((Entity)livingEntity) || !(player.distanceToSqr((Entity)livingEntity) < 9.0)) continue;
                    float f5 = ItemToolWithDamageSource.getEnchantedDamage(player, (Entity)livingEntity, f7, damageSource) * values.strength;
                    livingEntity.knockback((double)0.4f, (double)Mth.sin((float)(player.getYRot() * ((float)Math.PI / 180))), (double)(-Mth.cos((float)(player.getYRot() * ((float)Math.PI / 180)))));
                    livingEntity.hurt(damageSource, f5);
                    ItemToolWithDamageSource.doPostAttackEffects(player, (Entity)livingEntity, damageSource, extraModifiers);
                }
                world.playSound(null, player.getX(), player.getY(), player.getZ(), SoundEvents.PLAYER_ATTACK_SWEEP, player.getSoundSource(), 1.0f, 1.0f);
                player.sweepAttack();
            }
            if (target instanceof ServerPlayer && target.hurtMarked) {
                ((ServerPlayer)target).connection.send((Packet)new ClientboundSetEntityMotionPacket(target));
                target.hurtMarked = false;
                target.setDeltaMovement(vec3d);
            }
            if (doBoostDamage) {
                world.playSound(null, player.getX(), player.getY(), player.getZ(), SoundEvents.PLAYER_ATTACK_CRIT, player.getSoundSource(), 1.0f, 1.0f);
                player.crit(target);
            }
            if (!doBoostDamage && !isSweapAttack) {
                if (isStrongAttack) {
                    world.playSound(null, player.getX(), player.getY(), player.getZ(), SoundEvents.PLAYER_ATTACK_STRONG, player.getSoundSource(), 1.0f, 1.0f);
                } else {
                    world.playSound(null, player.getX(), player.getY(), player.getZ(), SoundEvents.PLAYER_ATTACK_WEAK, player.getSoundSource(), 1.0f, 1.0f);
                }
            }
            if (values.bonusDamage > 0.0f) {
                player.magicCrit(target);
            }
            player.setLastHurtMob(target);
            Entity entity = target;
            if (entity instanceof EnderDragonPart) {
                entity = ((EnderDragonPart)target).parentMob;
            }
            boolean flag5 = false;
            if (world instanceof ServerLevel) {
                if (entity instanceof LivingEntity) {
                    living = (LivingEntity)entity;
                    flag5 = weapon.hurtEnemy(living, player);
                }
                ItemToolWithDamageSource.doPostAttackEffects(player, target, damageSource, extraModifiers);
            }
            if (!world.isClientSide() && !weapon.isEmpty() && entity instanceof LivingEntity) {
                living = (LivingEntity)entity;
                if (flag5) {
                    weapon.postHurtEnemy(living, player);
                }
                if (weapon.isEmpty()) {
                    if (weapon == player.getMainHandItem()) {
                        player.setItemInHand(InteractionHand.MAIN_HAND, ItemStack.EMPTY);
                    } else {
                        player.setItemInHand(InteractionHand.OFF_HAND, ItemStack.EMPTY);
                    }
                }
            }
            if (target instanceof LivingEntity) {
                living = (LivingEntity)target;
                float victimHealthPostAttack = victimHealthPreAttack - living.getHealth();
                player.awardStat(Stats.DAMAGE_DEALT, Math.round(victimHealthPostAttack * 10.0f));
                if (world instanceof ServerLevel && victimHealthPostAttack > 2.0f) {
                    int k = (int)((double)victimHealthPostAttack * 0.5);
                    ((ServerLevel)world).sendParticles((ParticleOptions)ParticleTypes.DAMAGE_INDICATOR, target.getX(), target.getY() + (double)(target.getBbHeight() * 0.5f), target.getZ(), k, 0.1, 0.0, 0.1, 0.2);
                }
            }
            player.causeFoodExhaustion(0.1f);
            return true;
        }
        world.playSound(null, player.getX(), player.getY(), player.getZ(), SoundEvents.PLAYER_ATTACK_NODAMAGE, player.getSoundSource(), 1.0f, 1.0f);
        return false;
    }

    protected static void doPostAttackEffects(Player player, Entity target, DamageSource source, ItemStack extra) {
        Level level = player.level();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            EnchantmentHelper.doPostAttackEffectsWithItemSource((ServerLevel)serverLevel, (Entity)target, (DamageSource)source, (ItemStack)player.getWeaponItem());
            if (extra != null) {
                EnchantmentHelper.doPostAttackEffectsWithItemSource((ServerLevel)serverLevel, (Entity)target, (DamageSource)source, (ItemStack)extra);
            }
        }
    }

    protected void postHurtEntity(Player player, Entity target, DamageSource source) {
    }

    protected record SourceProvider(DamageSource base) {
        DamageSource getFor(Entity attacker) {
            return this.base instanceof MyDamageSource ? new MyDamageSource((Holder<DamageType>)this.base.typeHolder(), attacker) : new DamageSource(this.base.typeHolder(), attacker);
        }

        DamageSource getFor(Entity projectile, Entity attacker) {
            return this.base instanceof MyDamageSource ? new MyDamageSource((Holder<DamageType>)this.base.typeHolder(), projectile, attacker) : new DamageSource(this.base.typeHolder(), projectile, attacker);
        }

        DamageSource getFor(Vec3 damageSourcePosition) {
            return this.base instanceof MyDamageSource ? new MyDamageSource((Holder<DamageType>)this.base.typeHolder(), damageSourcePosition) : new DamageSource(this.base.typeHolder(), damageSourcePosition);
        }
    }

    protected static class AttackValues {
        private float damage;
        private float knockback;
        private float bonusDamage;
        private float strength;

        protected AttackValues() {
        }
    }
}

