/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.core.common.inventory;

import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;

public interface IOutputSlot {
    public boolean canTakeFromOutputSlot(int var1, Player var2);

    @NotNull
    public ItemStack shrinkStackSize(int var1, Player var2, int var3);

    public void onPickupFromOutputSlot(int var1, Player var2, ItemStack var3);

    public static class SlotOutput
    extends Slot {
        private final int slot;
        private final IOutputSlot callback;
        private Player player;

        public SlotOutput(Container inventory, int id, int x, int y, IOutputSlot callback) {
            super(inventory, id, x, y);
            this.slot = id;
            this.callback = callback;
        }

        public int getSlotIndex() {
            return this.slot;
        }

        public void setClicked(Player player) {
            this.player = player;
        }

        public boolean mayPlace(ItemStack itemStack) {
            return false;
        }

        public boolean mayPickup(Player player) {
            return this.callback == null || this.callback.canTakeFromOutputSlot(this.getSlotIndex(), player);
        }

        public void onTake(Player player, ItemStack stack) {
            if (this.callback != null) {
                this.callback.onPickupFromOutputSlot(this.getSlotIndex(), player, stack);
            }
            this.setChanged();
        }

        @NotNull
        public ItemStack remove(int amount) {
            if (this.player != null && this.callback != null) {
                ItemStack stack = this.callback.shrinkStackSize(this.getSlotIndex(), this.player, amount);
                this.player = null;
                if (!stack.isEmpty()) {
                    return stack;
                }
            }
            return super.remove(amount);
        }
    }
}

