/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.core.common.inventory;

import net.minecraft.core.Direction;

public enum AccessSide {
    ANY(null),
    DOWN(Direction.DOWN),
    UP(Direction.UP),
    NORTH(Direction.NORTH),
    SOUTH(Direction.SOUTH),
    WEST(Direction.WEST),
    EAST(Direction.EAST);

    private final Direction direction;

    private AccessSide(Direction direction) {
        this.direction = direction;
    }

    public Direction getDirection() {
        return this.direction;
    }

    public static AccessSide from(Direction direction) {
        AccessSide accessSide;
        if (direction == null) {
            accessSide = ANY;
        } else {
            switch (direction) {
                default: {
                    throw new MatchException(null, null);
                }
                case DOWN: {
                    accessSide = DOWN;
                    break;
                }
                case UP: {
                    accessSide = UP;
                    break;
                }
                case NORTH: {
                    accessSide = NORTH;
                    break;
                }
                case SOUTH: {
                    accessSide = SOUTH;
                    break;
                }
                case WEST: {
                    accessSide = WEST;
                    break;
                }
                case EAST: {
                    accessSide = EAST;
                }
            }
        }
        return accessSide;
    }
}

