/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.core.common;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import shetiphian.core.common.Helpers;

public class UseContext
extends BlockPlaceContext {
    public UseContext(@NotNull Player player, @NotNull ItemStack stack) {
        this(player, stack, Helpers.fakeMOP(new BlockPos(0, 1, 0), Direction.DOWN));
    }

    public UseContext(@NotNull Player player, @NotNull ItemStack stack, @NotNull BlockHitResult rayTraceResult) {
        super(player.level(), player, InteractionHand.MAIN_HAND, stack, rayTraceResult);
    }

    public UseContext(Level world, @Nullable Player player, ItemStack stack) {
        this(world, player, InteractionHand.MAIN_HAND, stack, Helpers.fakeMOP(new BlockPos(0, 1, 0), Direction.DOWN));
    }

    public UseContext(Level world, @Nullable Player player, InteractionHand hand, ItemStack stack, BlockHitResult rayTraceResult) {
        super(world, player, hand, stack, rayTraceResult);
    }

    public static BlockState getBlockPlacementStateFor(@NotNull ItemStack stack, @NotNull Player player) {
        return UseContext.getBlockPlacementStateFor(stack, player, player.level());
    }

    public static BlockState getBlockPlacementStateFor(@NotNull ItemStack stack, Level world) {
        return UseContext.getBlockPlacementStateFor(stack, null, world);
    }

    public static BlockState getBlockPlacementStateFor(@NotNull ItemStack stack, @Nullable Player player, Level world) {
        Block block = null;
        BlockState state = null;
        try {
            block = ((BlockItem)stack.getItem()).getBlock();
            state = block.getStateForPlacement((BlockPlaceContext)new UseContext(world, player, stack));
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (state == null && block != null) {
            state = block.defaultBlockState();
        }
        return state != null ? state : Blocks.AIR.defaultBlockState();
    }

    public static class Item
    extends UseOnContext {
        public Item(@NotNull Player entity, InteractionHand hand, BlockHitResult traceResult) {
            super(entity, hand, traceResult);
        }

        public Item(Level world, @Nullable Player entity, InteractionHand hand, @NotNull ItemStack stack, BlockHitResult traceResult) {
            super(world, entity, hand, stack, traceResult);
        }
    }
}

