/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.core.common;

import com.google.common.base.Strings;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextColor;

public class StringUtil {
    private static final Pattern STYLE_PATTERN = Pattern.compile("\u00a7([0-9a-fk-or])", 2);
    static final Pattern URL_PATTERN = Pattern.compile("((?:[a-z0-9]{2,}:\\/\\/)?(?:(?:[0-9]{1,3}\\.){3}[0-9]{1,3}|(?:[-\\w_]{1,}\\.[a-z]{2,}?))(?::[0-9]{1,5})?.*?(?=[!\"\u00a7 \n]|$))", 2);

    /*
     * WARNING - void declaration
     */
    private static String[] prepAndSplit(String string) {
        string = string.replace("\\t", "    ");
        String[] lines = string.split("(?>\\r\\n|\\r|\\n|%n|<br>)", -1);
        if (STYLE_PATTERN.matcher(string).matches()) {
            String formatting = "";
            for (String string2 : lines) {
                void var6_6;
                if (!Strings.isNullOrEmpty((String)formatting)) {
                    String string3 = formatting + string2;
                }
                formatting = StringUtil.acquireFormattingFrom((String)var6_6);
            }
        }
        return lines;
    }

    public static void multiLineTooltip(String string, List<Component> list) {
        for (String line : StringUtil.prepAndSplit(string)) {
            list.add((Component)Component.literal((String)line));
        }
    }

    public static void multiLine(String string, List<String> list) {
        Collections.addAll(list, StringUtil.prepAndSplit(string));
    }

    public static Style computeStyleFrom(String string) {
        Matcher matcher = STYLE_PATTERN.matcher(string);
        HashSet set = new HashSet();
        matcher.results().forEach(matchResult -> {
            String value = matchResult.group().toLowerCase(Locale.ROOT);
            if (!value.matches("\u00a7[k-o]")) {
                set.clear();
            }
            if (!value.equals("\u00a7r")) {
                set.add(ChatFormatting.getByCode((char)value.charAt(value.length() - 1)));
            }
        });
        set.remove(null);
        if (!set.isEmpty()) {
            return Style.EMPTY.applyFormats(set.toArray(new ChatFormatting[0]));
        }
        return Style.EMPTY;
    }

    public static String acquireFormattingFrom(String string) {
        Matcher matcher = STYLE_PATTERN.matcher(string);
        StringBuilder builder = new StringBuilder();
        matcher.results().forEach(matchResult -> {
            String value = matchResult.group().toLowerCase(Locale.ROOT);
            if (!value.matches("\u00a7[k-o]")) {
                builder.setLength(0);
            }
            if (!value.equals("\u00a7r")) {
                builder.append(value);
            }
        });
        return builder.toString();
    }

    public static Component newChatWithLinks(String string) {
        return StringUtil.newChatWithLinks(string, true);
    }

    public static Component newChatWithLinks(String string, boolean allowMissingHeader) {
        MutableComponent ichat = null;
        Matcher matcher = URL_PATTERN.matcher(string);
        int lastEnd = 0;
        while (matcher.find()) {
            MutableComponent link;
            Object url;
            block13: {
                int start = matcher.start();
                int end = matcher.end();
                String part = string.substring(lastEnd, start);
                if (part.length() > 0) {
                    if (ichat == null) {
                        ichat = Component.literal((String)part);
                    } else {
                        ichat.append(part);
                    }
                }
                lastEnd = end;
                url = string.substring(start, end);
                link = Component.literal((String)url);
                try {
                    if (new URI((String)url).getScheme() != null) break block13;
                    if (!allowMissingHeader) {
                        if (ichat == null) {
                            ichat = Component.literal((String)url);
                            continue;
                        }
                        ichat.append((String)url);
                        continue;
                    }
                    url = "http://" + (String)url;
                }
                catch (URISyntaxException e) {
                    if (ichat == null) {
                        ichat = Component.literal((String)url);
                        continue;
                    }
                    ichat.append((String)url);
                    continue;
                }
            }
            ClickEvent click = new ClickEvent(ClickEvent.Action.OPEN_URL, (String)url);
            link.setStyle(link.getStyle().withClickEvent(click).withUnderlined(Boolean.valueOf(true)).withColor(TextColor.fromLegacyFormat((ChatFormatting)ChatFormatting.BLUE)));
            if (ichat == null) {
                ichat = Component.literal((String)"");
            }
            ichat.append((Component)link);
        }
        String end = string.substring(lastEnd);
        if (ichat == null) {
            ichat = Component.literal((String)end);
        } else if (end.length() > 0) {
            ichat.append((Component)Component.literal((String)string.substring(lastEnd)));
        }
        return ichat;
    }
}

