/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.core.common;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtAccounter;
import net.minecraft.nbt.NbtIo;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;

public class NBTFile {
    public static void write(@NotNull CompoundTag nbtData, @NotNull File saveFile, @NotNull Logger log) {
        try {
            NBTFile.write(nbtData, saveFile);
        }
        catch (IOException error) {
            log.error("Failed to write file " + saveFile.getName() + " ; " + String.valueOf(error));
        }
    }

    private static void write(@NotNull CompoundTag nbtData, @NotNull File saveFile) throws IOException {
        File tempFile = new File(saveFile.getAbsolutePath() + "_tmp");
        if (tempFile.exists()) {
            tempFile.delete();
        }
        try (DataOutputStream dataoutputstream = new DataOutputStream(new FileOutputStream(tempFile));){
            NbtIo.writeCompressed((CompoundTag)nbtData, (OutputStream)dataoutputstream);
        }
        if (saveFile.exists()) {
            saveFile.delete();
        }
        if (saveFile.exists()) {
            throw new IOException("Failed to delete " + String.valueOf(saveFile));
        }
        tempFile.renameTo(saveFile);
    }

    public static CompoundTag read(@NotNull File saveFile, @NotNull Logger log) {
        CompoundTag nbtData = new CompoundTag();
        try {
            nbtData = NBTFile.read(saveFile);
        }
        catch (IOException error) {
            log.error("Failed to read file " + saveFile.getName() + " ; " + String.valueOf(error));
        }
        return nbtData;
    }

    private static CompoundTag read(@NotNull File saveFile) throws IOException {
        if (!saveFile.exists()) {
            throw new FileNotFoundException();
        }
        return NbtIo.readCompressed((InputStream)new DataInputStream(new FileInputStream(saveFile)), (NbtAccounter)NbtAccounter.unlimitedHeap());
    }
}

