/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.core.client.model;

import com.google.common.reflect.TypeToken;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.BufferedReader;
import java.io.Reader;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.MissingTextureAtlasSprite;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.server.packs.resources.ReloadableResourceManager;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.ResourceManagerReloadListener;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import shetiphian.core.ShetiPhianCore;
import shetiphian.core.common.Helpers;

public class PackTextureOverrideHandler
implements ResourceManagerReloadListener {
    private static final PackTextureOverrideHandler INSTANCE = new PackTextureOverrideHandler();
    public static Gson GSON = new GsonBuilder().create();
    private static final Map<Item, ResourceLocation> OVERRIDES = new HashMap<Item, ResourceLocation>();

    public static boolean contains(ItemStack stack) {
        return OVERRIDES.containsKey(stack.getItem());
    }

    public static ResourceLocation get(ItemStack stack) {
        return OVERRIDES.getOrDefault(stack.getItem(), MissingTextureAtlasSprite.getLocation());
    }

    public static void init() {
        ResourceManager manager = Minecraft.getInstance().getResourceManager();
        if (manager instanceof ReloadableResourceManager) {
            ReloadableResourceManager resourceManager = (ReloadableResourceManager)manager;
            resourceManager.registerReloadListener((PreparableReloadListener)INSTANCE);
        }
        INSTANCE.load();
    }

    public void onResourceManagerReload(ResourceManager resourceManager) {
        OVERRIDES.clear();
        this.load();
    }

    private void load() {
        ResourceLocation loc = ResourceLocation.parse((String)"shetiphian:texture_remap.json");
        List resources = Minecraft.getInstance().getResourceManager().getResourceStack(loc);
        Type token = new TypeToken<Map<String, String>>(){}.getType();
        for (Resource resource : resources) {
            Map map;
            try (BufferedReader reader = resource.openAsReader();){
                map = (Map)GSON.fromJson((Reader)reader, token);
            }
            catch (Exception e) {
                ShetiPhianCore.LOGGER.error(String.format("Error loading texture_remap.json form %s\n\t%s", resource.sourcePackId(), e.getLocalizedMessage()));
                break;
            }
            map.forEach((key, value) -> {
                try {
                    ResourceLocation location = ResourceLocation.parse((String)key);
                    ItemStack stack = Helpers.findItemStack(1, location);
                    if (stack.isEmpty()) {
                        throw new Exception(String.format("No registry entry for [%s] found", key));
                    }
                    location = ResourceLocation.parse((String)value);
                    OVERRIDES.put(stack.getItem(), location);
                }
                catch (Exception e) {
                    ShetiPhianCore.LOGGER.error(String.format("Ignoring invalid texture_remap entry ['%s':'%s'] form %s\n\t%s", key, value, resource.sourcePackId(), e.getLocalizedMessage()));
                }
            });
        }
    }
}

