/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.core.client.model;

import java.util.LinkedList;
import java.util.List;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.block.state.BlockState;
import shetiphian.core.ShetiPhianCore;
import shetiphian.core.client.model.BasicBakedModel;
import shetiphian.core.client.model.data.RenderData;
import shetiphian.core.platform.Services;

public abstract class CompositeBakedModel
extends BasicBakedModel {
    private static long TIMER = 0L;

    public List<BakedQuad> getQuads(BlockState state, Direction side, RandomSource rand) {
        if (TIMER + 120000L < System.currentTimeMillis()) {
            TIMER = System.currentTimeMillis();
            StringBuilder message = new StringBuilder("Model requires the rendering method added by ");
            message.append(Services.PLATFORM.getPlatformName()).append(", but something is using the original getQuads method");
            StackTraceElement[] trace = new Throwable("WrongMethodCalled").getStackTrace();
            for (int index = 1; index < Math.min(6, trace.length); ++index) {
                message.append("\n\tat ").append(trace[index].toString());
            }
            ShetiPhianCore.LOGGER.error(message.toString());
            ShetiPhianCore.LOGGER.info("Rendering of this model will be skipped");
        }
        return new LinkedList<BakedQuad>();
    }

    @Override
    public List<BakedQuad> getQuads(BlockState state, Direction side, RandomSource random, RenderData data, RenderType renderType) {
        LinkedList<BakedQuad> quads = new LinkedList<BakedQuad>();
        for (BakedModel model : this.handleBlockState(state, side, random, data, renderType)) {
            if (model == this) continue;
            quads.addAll(CompositeBakedModel.getQuadsFrom(model, state, side, random, null, renderType));
        }
        return quads;
    }

    public abstract List<BakedModel> handleBlockState(BlockState var1, Direction var2, RandomSource var3, RenderData var4, RenderType var5);
}

