/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.core.client.model;

import com.google.common.collect.HashBasedTable;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Table;
import com.mojang.math.Transformation;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.ItemModelShaper;
import net.minecraft.client.renderer.block.model.BlockModel;
import net.minecraft.client.renderer.texture.MissingTextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.BlockModelRotation;
import net.minecraft.client.resources.model.Material;
import net.minecraft.client.resources.model.ModelBaker;
import net.minecraft.client.resources.model.ModelBakery;
import net.minecraft.client.resources.model.ModelState;
import net.minecraft.client.resources.model.UnbakedModel;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.server.packs.resources.ReloadableResourceManager;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.ResourceManagerReloadListener;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.item.ItemStack;
import org.slf4j.Logger;
import shetiphian.core.client.model.IPartData;
import shetiphian.core.client.model.PackTextureOverrideHandler;
import shetiphian.core.client.model.RetexturedBlockModel;

public abstract class AbstractModelCacheBuilder
implements ResourceManagerReloadListener {
    private final Logger LOGGER;
    private final Table<String, String, EnumMap<BlockModelRotation, BakedModel>> PART_CACHE = HashBasedTable.create();
    private final List<String> PART_ERROR = new ArrayList<String>();
    protected ModelBaker BAKERY;
    protected Function<Material, TextureAtlasSprite> SPRITE_GETTER;
    protected ItemModelShaper MESHER;
    private static UnbakedModel MISSING_MODEL;
    public final Map<String, BakedModel> ITEM_CACHE = new HashMap<String, BakedModel>();
    EnumMap<BlockModelRotation, UVLocked> UVLOCKED = new EnumMap(BlockModelRotation.class);

    public AbstractModelCacheBuilder(Logger logger) {
        this.LOGGER = logger;
        ResourceManager manager = Minecraft.getInstance().getResourceManager();
        if (manager instanceof ReloadableResourceManager) {
            ((ReloadableResourceManager)manager).registerReloadListener((PreparableReloadListener)this);
        }
    }

    public void preBakeSetup(ModelBaker bakery, Function<Material, TextureAtlasSprite> spriteGetter) {
        this.BAKERY = bakery;
        this.SPRITE_GETTER = spriteGetter;
    }

    public ModelBaker getModelBaker() {
        return this.BAKERY;
    }

    public final void onResourceManagerReload(ResourceManager manager) {
        this.PART_CACHE.clear();
        this.ITEM_CACHE.clear();
        this.PART_ERROR.clear();
        this.onReload();
    }

    protected abstract void onReload();

    protected BakedModel get(String part, String key, Direction facing, String particle, List<IPartData> models) {
        return this.get(part, key, AbstractModelCacheBuilder.toRotation(facing), particle, models);
    }

    public static BlockModelRotation toRotation(Direction facing) {
        BlockModelRotation blockModelRotation;
        if (facing == null) {
            blockModelRotation = BlockModelRotation.X0_Y0;
        } else {
            switch (facing) {
                default: {
                    throw new MatchException(null, null);
                }
                case NORTH: {
                    blockModelRotation = BlockModelRotation.X0_Y0;
                    break;
                }
                case EAST: {
                    blockModelRotation = BlockModelRotation.X0_Y90;
                    break;
                }
                case SOUTH: {
                    blockModelRotation = BlockModelRotation.X0_Y180;
                    break;
                }
                case WEST: {
                    blockModelRotation = BlockModelRotation.X0_Y270;
                    break;
                }
                case UP: {
                    blockModelRotation = BlockModelRotation.X90_Y0;
                    break;
                }
                case DOWN: {
                    blockModelRotation = BlockModelRotation.X270_Y0;
                }
            }
        }
        return blockModelRotation;
    }

    protected BakedModel get(String part, String key, BlockModelRotation rotation, String particle, List<IPartData> models) {
        Map map;
        if (!this.PART_CACHE.contains((Object)part, (Object)key)) {
            if (this.PART_ERROR.contains(part)) {
                return null;
            }
            this.buildCache(part, key, particle, models);
        }
        if ((map = (Map)this.PART_CACHE.get((Object)part, (Object)key)) == null) {
            map = (Map)this.PART_CACHE.get((Object)part, (Object)"default");
        }
        return map == null ? null : (BakedModel)map.get(rotation == null ? BlockModelRotation.X0_Y0 : rotation);
    }

    protected void buildCache(String part, String key, String particle, List<IPartData> models) {
        IPartData iPartData = null;
        for (IPartData data : models) {
            if (!data.getName().equalsIgnoreCase(part)) continue;
            iPartData = data;
            break;
        }
        if (iPartData == null) {
            return;
        }
        UnbakedModel unbaked = null;
        if (this.BAKERY != null) {
            unbaked = this.getModelOrMissing(iPartData.getLocation());
            try {
                if (unbaked.equals((Object)this.BAKERY.getModel(ModelBakery.MISSING_MODEL_LOCATION)) && !this.PART_ERROR.contains(part)) {
                    unbaked = this.getModelOrMissing(iPartData.getLocation());
                }
                if (unbaked.equals((Object)this.BAKERY.getModel(ModelBakery.MISSING_MODEL_LOCATION))) {
                    unbaked = null;
                }
            }
            catch (IllegalStateException ignored) {
                unbaked = null;
            }
        }
        if (unbaked == null) {
            if (!this.PART_ERROR.contains(part)) {
                if (this.LOGGER != null) {
                    this.LOGGER.error("Unable to retrieve model form the ModelLoaderRegistry, this part may not render correctly: " + part);
                }
                this.PART_ERROR.add(part);
            }
            return;
        }
        if (!this.PART_CACHE.contains((Object)iPartData.getName(), (Object)"default")) {
            if (unbaked instanceof BlockModel) {
                this.PART_CACHE.put((Object)iPartData.getName(), (Object)"default", this.getMap(iPartData, (UnbakedModel)RetexturedBlockModel.from((BlockModel)unbaked).retexture(this.setTextures(iPartData, iPartData.getDefaultTexture(), particle)), iPartData.getLocation()));
            } else {
                this.PART_CACHE.put((Object)iPartData.getName(), (Object)"default", this.getMap(iPartData, unbaked, iPartData.getLocation()));
            }
        }
        if (!key.equals("default")) {
            if (unbaked instanceof BlockModel) {
                this.PART_CACHE.put((Object)iPartData.getName(), (Object)key, this.getMap(iPartData, (UnbakedModel)RetexturedBlockModel.from((BlockModel)unbaked).retexture(this.setTextures(iPartData, key, particle)), iPartData.getLocation()));
            } else {
                this.PART_CACHE.put((Object)iPartData.getName(), (Object)key, this.getMap(iPartData, unbaked, iPartData.getLocation()));
            }
        }
    }

    protected UnbakedModel getModelOrMissing(ResourceLocation location) {
        try {
            return this.BAKERY.getModel(location);
        }
        catch (Exception e) {
            if (MISSING_MODEL == null) {
                try {
                    MISSING_MODEL = this.BAKERY.getModel(ModelBakery.MISSING_MODEL_LOCATION);
                }
                catch (Exception e2) {
                    throw new RuntimeException("Missing the missing model, this should never happen");
                }
            }
            return MISSING_MODEL;
        }
    }

    public String getTexture(ItemStack stack) {
        return this.getTextureSprite(stack).contents().name().toString();
    }

    public TextureAtlasSprite getTextureSprite(ItemStack stack) {
        if (PackTextureOverrideHandler.contains(stack)) {
            return this.getTextureSprite(PackTextureOverrideHandler.get(stack));
        }
        try {
            if (this.MESHER == null) {
                this.MESHER = Minecraft.getInstance().getItemRenderer().getItemModelShaper();
            }
            BakedModel model = this.MESHER.getItemModel(stack);
            return model.getParticleIcon();
        }
        catch (Exception exception) {
            return (TextureAtlasSprite)Minecraft.getInstance().getTextureAtlas(InventoryMenu.BLOCK_ATLAS).apply(MissingTextureAtlasSprite.getLocation());
        }
    }

    public TextureAtlasSprite getTextureSprite(ResourceLocation location) {
        try {
            return (TextureAtlasSprite)Minecraft.getInstance().getTextureAtlas(InventoryMenu.BLOCK_ATLAS).apply(location);
        }
        catch (Exception exception) {
            return (TextureAtlasSprite)Minecraft.getInstance().getTextureAtlas(InventoryMenu.BLOCK_ATLAS).apply(MissingTextureAtlasSprite.getLocation());
        }
    }

    protected abstract ImmutableMap<String, String> setTextures(IPartData var1, String var2, String var3);

    protected EnumMap<BlockModelRotation, BakedModel> getMap(IPartData iPartData, UnbakedModel model, ResourceLocation location) {
        EnumMap<BlockModelRotation, BakedModel> map = new EnumMap<BlockModelRotation, BakedModel>(BlockModelRotation.class);
        if (iPartData.isUvLocked()) {
            for (BlockModelRotation rotation : iPartData.getRotations()) {
                if (!this.UVLOCKED.containsKey(rotation)) {
                    this.UVLOCKED.put(rotation, new UVLocked(rotation));
                }
                map.put(rotation, model.bake(this.BAKERY, this.SPRITE_GETTER, (ModelState)this.UVLOCKED.get(rotation)));
            }
        } else {
            for (BlockModelRotation rotation : iPartData.getRotations()) {
                map.put(rotation, model.bake(this.BAKERY, this.SPRITE_GETTER, (ModelState)rotation));
            }
        }
        return map;
    }

    private static class UVLocked
    implements ModelState {
        private final BlockModelRotation rotation;

        private UVLocked(BlockModelRotation rotation) {
            this.rotation = rotation;
        }

        public boolean isUvLocked() {
            return true;
        }

        public Transformation getRotation() {
            return this.rotation.getRotation();
        }
    }
}

