/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.core.client.gui;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.MeshData;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.util.function.Supplier;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.ShaderInstance;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;

public class GuiHelper {
    public static float zLevel = 0.0f;

    public static void renderItemWithOverlays(GuiGraphics graphics, Font font, ItemStack stack, int posX, int posY) {
        graphics.renderItem(stack, posX, posY);
        graphics.renderItemDecorations(font, stack, posX, posY);
    }

    public static BufferBuilder startCustom(Supplier<ShaderInstance> shader, VertexFormat.Mode mode, VertexFormat format, @Nullable ResourceLocation texture) {
        if (texture != null) {
            RenderSystem.setShaderTexture((int)0, (ResourceLocation)texture);
        }
        RenderSystem.enableBlend();
        RenderSystem.blendFuncSeparate((int)770, (int)771, (int)1, (int)0);
        RenderSystem.setShader(shader);
        return Tesselator.getInstance().begin(mode, format);
    }

    public static void endCustom(BufferBuilder renderer) {
        BufferUploader.drawWithShader((MeshData)renderer.buildOrThrow());
        RenderSystem.disableBlend();
    }

    public static void drawCenteredString(GuiGraphics graphics, Font font, Component text, float posX, float posY, int color, boolean dropShadow) {
        GuiHelper.drawCenteredString(graphics, font, text.getVisualOrderText(), posX, posY, color, dropShadow);
    }

    public static void drawCenteredString(GuiGraphics graphics, Font font, FormattedCharSequence text, float posX, float posY, int color, boolean dropShadow) {
        GuiHelper.drawString(graphics, font, text, posX - (float)font.width(text) / 2.0f, posY, color, dropShadow);
    }

    public static void drawCenteredString(GuiGraphics graphics, Font font, String text, float posX, float posY, int color, boolean dropShadow) {
        GuiHelper.drawString(graphics, font, text, posX - (float)font.width(text) / 2.0f, posY, color, dropShadow);
    }

    public static int drawString(GuiGraphics graphics, Font font, Component text, float posX, float posY, int color, boolean dropShadow) {
        return GuiHelper.drawString(graphics, font, text.getVisualOrderText(), posX, posY, color, dropShadow);
    }

    public static int drawString(GuiGraphics graphics, Font font, FormattedCharSequence text, float posX, float posY, int color, boolean dropShadow) {
        if (text != null) {
            graphics.drawManaged(() -> font.drawInBatch(text, posX, posY, color, dropShadow, graphics.pose().last().pose(), (MultiBufferSource)graphics.bufferSource(), Font.DisplayMode.NORMAL, 0, 0xF000F0));
            return (int)posX + (dropShadow ? 1 : 0);
        }
        return 0;
    }

    public static int drawString(GuiGraphics graphics, Font font, String text, float posX, float posY, int color, boolean dropShadow) {
        if (text != null) {
            graphics.drawManaged(() -> font.drawInBatch(text, posX, posY, color, dropShadow, graphics.pose().last().pose(), (MultiBufferSource)graphics.bufferSource(), Font.DisplayMode.NORMAL, 0, 0xF000F0, font.isBidirectional()));
            return (int)posX + (dropShadow ? 1 : 0);
        }
        return 0;
    }

    public static void drawTexture(GuiGraphics graphics, double posX, double posY, int width, int height, TextureAtlasSprite sprite) {
        GuiHelper.drawTexturedQuad(graphics, posX, posX + (double)width, posY, posY + (double)height, sprite.getU0(), sprite.getU1(), sprite.getV0(), sprite.getV1(), sprite.atlasLocation());
    }

    public static void drawTexture(GuiGraphics graphics, double posX, double posY, int posU, int posV, int sizeU, int sizeV, ResourceLocation texture) {
        GuiHelper.drawTexturedQuad(graphics, posX, posX + (double)sizeU, posY, posY + (double)sizeV, (float)posU / 256.0f, (float)(posU + sizeU) / 256.0f, (float)posV / 256.0f, (float)(posV + sizeV) / 256.0f, texture);
    }

    public static void drawTexture(GuiGraphics graphics, double posX, double posY, int posU, int posV, int sizeU, int sizeV, int textureWidth, int textureHeight, ResourceLocation texture) {
        GuiHelper.drawTexturedQuad(graphics, posX, posX + (double)sizeU, posY, posY + (double)sizeV, (float)posU / (float)textureWidth, (float)(posU + sizeU) / (float)textureWidth, (float)posV / (float)textureHeight, (float)(posV + sizeV) / (float)textureHeight, texture);
    }

    public static void drawTextureScaled(GuiGraphics graphics, double posX, double posY, int posU, int posV, int sizeU, int sizeV, double scale, ResourceLocation texture) {
        GuiHelper.drawTexturedQuad(graphics, posX, posX + (double)sizeU * scale, posY, posY + (double)sizeV * scale, (float)posU / 256.0f, (float)(posU + sizeU) / 256.0f, (float)posV / 256.0f, (float)(posV + sizeV) / 256.0f, texture);
    }

    public static void drawTextureScaled(GuiGraphics graphics, double posX, double posY, int posU, int posV, int sizeU, int sizeV, double scale, int textureWidth, int textureHeight, ResourceLocation texture) {
        GuiHelper.drawTexturedQuad(graphics, posX, posX + (double)sizeU * scale, posY, posY + (double)sizeV * scale, (float)posU / (float)textureWidth, (float)(posU + sizeU) / (float)textureWidth, (float)posV / (float)textureHeight, (float)(posV + sizeV) / (float)textureHeight, texture);
    }

    private static void drawTexturedQuad(GuiGraphics graphics, double x0, double x1, double y0, double y1, float u0, float u1, float v0, float v1, ResourceLocation texture) {
        Matrix4f matrix = graphics.pose().last().pose();
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)texture);
        RenderSystem.enableBlend();
        RenderSystem.blendFuncSeparate((int)770, (int)771, (int)1, (int)0);
        RenderSystem.setShader(GameRenderer::getPositionTexShader);
        BufferBuilder renderer = Tesselator.getInstance().begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_TEX);
        renderer.addVertex(matrix, (float)x0, (float)y1, zLevel).setUv(u0, v1);
        renderer.addVertex(matrix, (float)x1, (float)y1, zLevel).setUv(u1, v1);
        renderer.addVertex(matrix, (float)x1, (float)y0, zLevel).setUv(u1, v0);
        renderer.addVertex(matrix, (float)x0, (float)y0, zLevel).setUv(u0, v0);
        BufferUploader.drawWithShader((MeshData)renderer.buildOrThrow());
        RenderSystem.disableBlend();
    }

    public static void drawTextureMirrored(GuiGraphics graphics, double posX, double posY, int posU, int posV, int sizeU, int sizeV, TextureAtlasSprite sprite) {
        GuiHelper.drawMirroredTexturedQuad(graphics, posX, posX + (double)sizeU, posY, posY + (double)sizeV, sprite.getU0(), sprite.getU1(), sprite.getV0(), sprite.getV1(), sprite.atlasLocation());
    }

    public static void drawTextureMirrored(GuiGraphics graphics, double posX, double posY, int posU, int posV, int sizeU, int sizeV, ResourceLocation texture) {
        GuiHelper.drawMirroredTexturedQuad(graphics, posX, posX + (double)sizeU, posY, posY + (double)sizeV, (float)posU / 256.0f, (float)(posU + sizeU) / 256.0f, (float)posV / 256.0f, (float)(posV + sizeV) / 256.0f, texture);
    }

    public static void drawTextureMirrored(GuiGraphics graphics, double posX, double posY, int posU, int posV, int sizeU, int sizeV, int textureWidth, int textureHeight, ResourceLocation texture) {
        GuiHelper.drawMirroredTexturedQuad(graphics, posX, posX + (double)sizeU, posY, posY + (double)sizeV, (float)posU / (float)textureWidth, (float)(posU + sizeU) / (float)textureWidth, (float)posV / (float)textureHeight, (float)(posV + sizeV) / (float)textureHeight, texture);
    }

    public static void drawTextureMirroredAndScaled(GuiGraphics graphics, double posX, double posY, int posU, int posV, int sizeU, int sizeV, double scale, ResourceLocation texture) {
        GuiHelper.drawMirroredTexturedQuad(graphics, posX, posX + (double)sizeU * scale, posY, posY + (double)sizeV * scale, (float)posU / 256.0f, (float)(posU + sizeU) / 256.0f, (float)posV / 256.0f, (float)(posV + sizeV) / 256.0f, texture);
    }

    public static void drawTextureMirroredAndScaled(GuiGraphics graphics, double posX, double posY, int posU, int posV, int sizeU, int sizeV, double scale, int textureWidth, int textureHeight, ResourceLocation texture) {
        GuiHelper.drawMirroredTexturedQuad(graphics, posX, posX + (double)sizeU * scale, posY, posY + (double)sizeV * scale, (float)posU / (float)textureWidth, (float)(posU + sizeU) / (float)textureWidth, (float)posV / (float)textureHeight, (float)(posV + sizeV) / (float)textureHeight, texture);
    }

    private static void drawMirroredTexturedQuad(GuiGraphics graphics, double x0, double x1, double y0, double y1, float u0, float u1, float v0, float v1, ResourceLocation texture) {
        Matrix4f matrix = graphics.pose().last().pose();
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)texture);
        RenderSystem.enableBlend();
        RenderSystem.blendFuncSeparate((int)770, (int)771, (int)1, (int)0);
        RenderSystem.setShader(GameRenderer::getPositionTexShader);
        BufferBuilder renderer = Tesselator.getInstance().begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_TEX);
        renderer.addVertex(matrix, (float)x0, (float)y1, zLevel).setUv(u1, v1);
        renderer.addVertex(matrix, (float)x1, (float)y1, zLevel).setUv(u0, v1);
        renderer.addVertex(matrix, (float)x1, (float)y0, zLevel).setUv(u0, v0);
        renderer.addVertex(matrix, (float)x0, (float)y0, zLevel).setUv(u1, v0);
        BufferUploader.drawWithShader((MeshData)renderer.buildOrThrow());
        RenderSystem.disableBlend();
    }

    public static void drawTextureInverted(GuiGraphics graphics, double posX, double posY, int posU, int posV, int sizeU, int sizeV, TextureAtlasSprite sprite) {
        GuiHelper.drawInvertedTexturedQuad(graphics, posX, posX + (double)sizeU, posY, posY + (double)sizeV, sprite.getU0(), sprite.getU1(), sprite.getV0(), sprite.getV1(), sprite.atlasLocation());
    }

    public static void drawTextureInverted(GuiGraphics graphics, double posX, double posY, int posU, int posV, int sizeU, int sizeV, ResourceLocation texture) {
        GuiHelper.drawInvertedTexturedQuad(graphics, posX, posX + (double)sizeU, posY, posY + (double)sizeV, (float)posU / 256.0f, (float)(posU + sizeU) / 256.0f, (float)posV / 256.0f, (float)(posV + sizeV) / 256.0f, texture);
    }

    public static void drawTextureInverted(GuiGraphics graphics, double posX, double posY, int posU, int posV, int sizeU, int sizeV, int textureWidth, int textureHeight, ResourceLocation texture) {
        GuiHelper.drawInvertedTexturedQuad(graphics, posX, posX + (double)sizeU, posY, posY + (double)sizeV, (float)posU / (float)textureWidth, (float)(posU + sizeU) / (float)textureWidth, (float)posV / (float)textureHeight, (float)(posV + sizeV) / (float)textureHeight, texture);
    }

    public static void drawTextureInvertedAndScaled(GuiGraphics graphics, double posX, double posY, int posU, int posV, int sizeU, int sizeV, double scale, ResourceLocation texture) {
        GuiHelper.drawInvertedTexturedQuad(graphics, posX, posX + (double)sizeU * scale, posY, posY + (double)sizeV * scale, (float)posU / 256.0f, (float)(posU + sizeU) / 256.0f, (float)posV / 256.0f, (float)(posV + sizeV) / 256.0f, texture);
    }

    public static void drawTextureInvertedAndScaled(GuiGraphics graphics, double posX, double posY, int posU, int posV, int sizeU, int sizeV, double scale, int textureWidth, int textureHeight, ResourceLocation texture) {
        GuiHelper.drawInvertedTexturedQuad(graphics, posX, posX + (double)sizeU * scale, posY, posY + (double)sizeV * scale, (float)posU / (float)textureWidth, (float)(posU + sizeU) / (float)textureWidth, (float)posV / (float)textureHeight, (float)(posV + sizeV) / (float)textureHeight, texture);
    }

    private static void drawInvertedTexturedQuad(GuiGraphics graphics, double x0, double x1, double y0, double y1, float u0, float u1, float v0, float v1, ResourceLocation texture) {
        Matrix4f matrix = graphics.pose().last().pose();
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)texture);
        RenderSystem.enableBlend();
        RenderSystem.blendFuncSeparate((int)770, (int)771, (int)1, (int)0);
        RenderSystem.setShader(GameRenderer::getPositionTexShader);
        BufferBuilder renderer = Tesselator.getInstance().begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_TEX);
        renderer.addVertex(matrix, (float)x0, (float)y1, zLevel).setUv(u0, v0);
        renderer.addVertex(matrix, (float)x1, (float)y1, zLevel).setUv(u1, v0);
        renderer.addVertex(matrix, (float)x1, (float)y0, zLevel).setUv(u1, v1);
        renderer.addVertex(matrix, (float)x0, (float)y0, zLevel).setUv(u0, v1);
        BufferUploader.drawWithShader((MeshData)renderer.buildOrThrow());
        RenderSystem.disableBlend();
    }

    public static void drawHorizontalGradient(GuiGraphics graphics, double left, double top, double right, double bottom, int colorRight, int colorLeft) {
        GuiHelper.drawGradientRect(graphics, left, top, right, bottom, colorRight, colorLeft, colorLeft, colorRight);
    }

    public static void drawGradientRect(GuiGraphics graphics, double left, double top, double right, double bottom, int colorTop, int colorBottom) {
        GuiHelper.drawGradientRect(graphics, left, top, right, bottom, colorTop, colorTop, colorBottom, colorBottom);
    }

    public static void drawRect(GuiGraphics graphics, double left, double top, double right, double bottom, int color) {
        GuiHelper.drawGradientRect(graphics, left, top, right, bottom, color, color, color, color);
    }

    public static void drawGradientRect(GuiGraphics graphics, double left, double top, double right, double bottom, int colorTopRight, int colorTopLeft, int colorBottomLeft, int colorBottomRight) {
        Matrix4f matrix = graphics.pose().last().pose();
        RenderSystem.enableBlend();
        RenderSystem.blendFuncSeparate((int)770, (int)771, (int)1, (int)0);
        RenderSystem.setShader(GameRenderer::getPositionColorShader);
        BufferBuilder renderer = Tesselator.getInstance().begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_COLOR);
        renderer.addVertex(matrix, (float)right, (float)top, zLevel).setColor(colorTopRight);
        renderer.addVertex(matrix, (float)left, (float)top, zLevel).setColor(colorTopLeft);
        renderer.addVertex(matrix, (float)left, (float)bottom, zLevel).setColor(colorBottomLeft);
        renderer.addVertex(matrix, (float)right, (float)bottom, zLevel).setColor(colorBottomRight);
        BufferUploader.drawWithShader((MeshData)renderer.buildOrThrow());
        RenderSystem.disableBlend();
    }

    public static void drawLine(GuiGraphics graphics, double x1, double y1, double x2, double y2, float width, int color) {
        GuiHelper.drawLine(graphics, x1, y1, x2, y2, width, color, color);
    }

    public static void drawLine(GuiGraphics graphics, double x1, double y1, double x2, double y2, float width, int color1, int color2) {
        width /= 2.0f;
        Matrix4f matrix = graphics.pose().last().pose();
        RenderSystem.disableCull();
        RenderSystem.enableBlend();
        RenderSystem.blendFuncSeparate((int)770, (int)771, (int)1, (int)0);
        RenderSystem.setShader(GameRenderer::getPositionColorShader);
        BufferBuilder renderer = Tesselator.getInstance().begin(VertexFormat.Mode.TRIANGLE_STRIP, DefaultVertexFormat.POSITION_COLOR);
        if (y1 == y2) {
            renderer.addVertex(matrix, (float)x1, (float)y1 - width, zLevel).setColor(color1);
            renderer.addVertex(matrix, (float)x2, (float)y2 - width, zLevel).setColor(color2);
            renderer.addVertex(matrix, (float)x1, (float)y1 + width, zLevel).setColor(color1);
            renderer.addVertex(matrix, (float)x2, (float)y2 + width, zLevel).setColor(color2);
        } else if (x1 == x2) {
            renderer.addVertex(matrix, (float)x1 - width, (float)y1, zLevel).setColor(color1);
            renderer.addVertex(matrix, (float)x2 - width, (float)y2, zLevel).setColor(color2);
            renderer.addVertex(matrix, (float)x1 + width, (float)y1, zLevel).setColor(color1);
            renderer.addVertex(matrix, (float)x2 + width, (float)y2, zLevel).setColor(color2);
        } else {
            double angle = Math.abs(Math.atan2(y2 - y1, x2 - x1));
            double percentage = angle % 0.7853981633974483 / 0.7853981633974483;
            int sector = (int)(angle / 0.7853981633974483);
            float xWidth = (float)((double)width * (sector == 0 ? percentage : (sector == 3 ? 1.0 - percentage : 1.0)));
            float yWidth = (float)((double)width * (sector == 1 ? 1.0 - percentage : (sector == 2 ? percentage : 1.0)));
            if (y1 < y2 && x1 < x2 || y1 > y2 && x1 > x2) {
                renderer.addVertex(matrix, (float)x1 + xWidth, (float)y1 - yWidth, zLevel).setColor(color1);
                renderer.addVertex(matrix, (float)x2 + xWidth, (float)y2 - yWidth, zLevel).setColor(color2);
                renderer.addVertex(matrix, (float)x1 - xWidth, (float)y1 + yWidth, zLevel).setColor(color1);
                renderer.addVertex(matrix, (float)x2 - xWidth, (float)y2 + yWidth, zLevel).setColor(color2);
            } else {
                renderer.addVertex(matrix, (float)x1 - xWidth, (float)y1 - yWidth, zLevel).setColor(color1);
                renderer.addVertex(matrix, (float)x2 - xWidth, (float)y2 - yWidth, zLevel).setColor(color2);
                renderer.addVertex(matrix, (float)x1 + xWidth, (float)y1 + yWidth, zLevel).setColor(color1);
                renderer.addVertex(matrix, (float)x2 + xWidth, (float)y2 + yWidth, zLevel).setColor(color2);
            }
        }
        BufferUploader.drawWithShader((MeshData)renderer.buildOrThrow());
        RenderSystem.disableBlend();
        RenderSystem.enableCull();
    }
}

