/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.core.client.gui;

import com.google.common.base.Strings;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import shetiphian.core.client.gui.GuiHelper;

public abstract class ButtonIcon
extends Button {
    private final ResourceLocation texture;
    private final int[] normal;
    private final int[] hover;
    private final int[] pressed;
    protected String displayString;
    private Button.OnPress iPressable;

    public ButtonIcon(int posX, int posY, int sizeX, int sizeY) {
        this(posX, posY, sizeX, sizeY, null, 0, 0, 0, 0, 0, 0);
    }

    public ButtonIcon(int posX, int posY, int sizeX, int sizeY, ResourceLocation texture, int nU, int nV, int hU, int hV, int pU, int pV) {
        this(posX, posY, sizeX, sizeY, texture, new int[]{nU, nV}, new int[]{hU, hV}, new int[]{pU, pV});
    }

    public ButtonIcon(int posX, int posY, int sizeX, int sizeY, ResourceLocation texture, int[] normal, int[] hover, int[] pressed) {
        super(posX, posY, sizeX, sizeY, (Component)Component.empty(), null, Button.DEFAULT_NARRATION);
        this.texture = texture;
        this.normal = normal;
        this.hover = hover;
        this.pressed = pressed;
    }

    public ButtonIcon setText(String text) {
        this.displayString = text;
        return this;
    }

    public ButtonIcon setPress(Button.OnPress iPressable) {
        this.iPressable = iPressable;
        return this;
    }

    public void onPress() {
        if (this.iPressable != null) {
            this.iPressable.onPress((Button)this);
        }
    }

    public void renderWidget(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        if (!this.visible) {
            return;
        }
        Minecraft mc = Minecraft.getInstance();
        int x = this.getX();
        int y = this.getY();
        boolean bl = this.isHovered = mouseX >= x && mouseY >= y && mouseX < x + this.width && mouseY < y + this.height;
        if (this.texture != null) {
            if (this.isHovered && mc.mouseHandler.isLeftPressed()) {
                GuiHelper.drawTexture(graphics, x, y, this.pressed[0], this.pressed[1], this.width, this.height, this.texture);
            } else if (this.isHovered) {
                GuiHelper.drawTexture(graphics, x, y, this.hover[0], this.hover[1], this.width, this.height, this.texture);
            } else {
                GuiHelper.drawTexture(graphics, x, y, this.normal[0], this.normal[1], this.width, this.height, this.texture);
            }
        }
        if (!Strings.isNullOrEmpty((String)this.displayString)) {
            graphics.drawCenteredString(mc.font, this.displayString, x + this.width / 2, y + (this.height - 8) / 2, -1);
        }
    }
}

