/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.core.client;

import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Table;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.client.renderer.item.ItemPropertyFunction;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.BlockState;
import shetiphian.core.client.model.BasicBakedModel;
import shetiphian.core.client.model.data.RenderData;
import shetiphian.core.common.Helpers;
import shetiphian.core.platform.Services;

public class ClientHelpers
extends Helpers {
    private static Table<Item, String, ItemPropertyFunction> ITEM_PROPERTIES = HashBasedTable.create();

    public static void addProperty(Item item, String id, ItemPropertyFunction function) {
        ITEM_PROPERTIES.put((Object)item, (Object)id, (Object)function);
    }

    public static void internal_registerProperties(Consumer<Table.Cell<Item, String, ItemPropertyFunction>> consumer) {
        ITEM_PROPERTIES.cellSet().forEach(consumer);
        ITEM_PROPERTIES.clear();
    }

    public static List<RenderType> getLayers(BlockState state) {
        BakedModel model = Minecraft.getInstance().getBlockRenderer().getBlockModel(state);
        RandomSource random = RandomSource.create((long)42L);
        if (model instanceof BasicBakedModel) {
            BasicBakedModel basicBakedModel = (BasicBakedModel)model;
            return basicBakedModel.getBlockLayersOrDefaults(state, random, RenderData.EMPTY);
        }
        return Services.CLIENT.getLayers(model, state, random, RenderData.EMPTY);
    }

    public static boolean isOf(BlockState state, RenderType layer) {
        return ClientHelpers.getLayers(state).contains(layer);
    }

    public static boolean isTranslucent(BlockState state) {
        List<RenderType> layers = ClientHelpers.getLayers(state);
        return layers.contains(RenderType.translucent()) || layers.contains(Sheets.translucentCullBlockSheet()) || layers.contains(Sheets.translucentItemSheet());
    }

    public static boolean isCutout(BlockState state) {
        List<RenderType> layers = ClientHelpers.getLayers(state);
        return layers.contains(RenderType.cutout()) || layers.contains(RenderType.cutoutMipped()) || layers.contains(Sheets.cutoutBlockSheet());
    }

    public static boolean isSolid(BlockState state) {
        List<RenderType> layers = ClientHelpers.getLayers(state);
        return layers.contains(RenderType.solid()) || layers.contains(Sheets.solidBlockSheet());
    }

    public static boolean canRenderIn(ItemStack stack, RenderType layer) {
        Item item = stack.getItem();
        if (item instanceof BlockItem) {
            BlockItem blockItem = (BlockItem)item;
            return ClientHelpers.getLayers(blockItem.getBlock().defaultBlockState()).contains(layer);
        }
        return ItemBlockRenderTypes.getRenderType((ItemStack)stack, (boolean)false).equals(layer);
    }
}

