/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.core;

import java.util.Optional;
import java.util.concurrent.Callable;
import java.util.function.Supplier;
import shetiphian.core.ShetiPhianCore;
import shetiphian.core.platform.Services;

public class SideExecutor {
    public static boolean isClient() {
        return Services.PLATFORM.isClient();
    }

    public static boolean isServer() {
        return Services.PLATFORM.isServer();
    }

    public static boolean isLogicalClient() {
        return SideExecutor.isClient() && SideExecutor.isClientThread();
    }

    public static boolean isLogicalServer() {
        return SideExecutor.isServer() || SideExecutor.isServerThread();
    }

    public static boolean isClientThread() {
        return Services.PLATFORM.isClientThread();
    }

    public static boolean isServerThread() {
        return Services.PLATFORM.isServerThread();
    }

    public static <T> Optional<T> callOnClient(Supplier<Callable<T>> toCall) {
        return SideExecutor.isClient() ? SideExecutor.preformCall(toCall, "Client") : Optional.empty();
    }

    public static <T> Optional<T> callOnServer(Supplier<Callable<T>> toCall) {
        return SideExecutor.isServer() ? SideExecutor.preformCall(toCall, "Server") : Optional.empty();
    }

    public static <T> Optional<T> callOnLogicalClient(Supplier<Callable<T>> toCall) {
        return SideExecutor.isLogicalClient() ? SideExecutor.preformCall(toCall, "Logical Client") : Optional.empty();
    }

    public static <T> Optional<T> callOnLogicalServer(Supplier<Callable<T>> toCall) {
        return SideExecutor.isLogicalServer() ? SideExecutor.preformCall(toCall, "Logical Server") : Optional.empty();
    }

    private static <T> Optional<T> preformCall(Supplier<Callable<T>> toCall, String side) {
        try {
            return Optional.of(toCall.get().call());
        }
        catch (Exception exception) {
            ShetiPhianCore.LOGGER.error("SideExecutor; {} Call Failed: ", (Object)side, (Object)exception);
            return Optional.empty();
        }
    }

    public static boolean runOnClient(Supplier<Runnable> toRun) {
        return SideExecutor.isClient() && SideExecutor.preformRun(toRun, "Client");
    }

    public static boolean runOnServer(Supplier<Runnable> toRun) {
        return SideExecutor.isServer() && SideExecutor.preformRun(toRun, "Server");
    }

    public static boolean runOnLogicalClient(Supplier<Runnable> toRun) {
        return SideExecutor.isLogicalClient() && SideExecutor.preformRun(toRun, "Logical Client");
    }

    public static boolean runOnLogicalServer(Supplier<Runnable> toRun) {
        return SideExecutor.isLogicalServer() && SideExecutor.preformRun(toRun, "Logical Server");
    }

    private static boolean preformRun(Supplier<Runnable> toRun, String side) {
        try {
            toRun.get().run();
            return true;
        }
        catch (Exception exception) {
            ShetiPhianCore.LOGGER.error("SideExecutor; {} Run Failed: ", (Object)side, (Object)exception);
            return false;
        }
    }

    public static <T> T executeOn(Supplier<Supplier<T>> client, Supplier<Supplier<T>> server) {
        return SideExecutor.isClient() ? SideExecutor.preformExecute(client, "Client") : SideExecutor.preformExecute(server, "Server");
    }

    public static <T> T executeOnLogical(Supplier<Supplier<T>> client, Supplier<Supplier<T>> server) {
        return SideExecutor.isLogicalServer() ? SideExecutor.preformExecute(server, "Server") : SideExecutor.preformExecute(client, "Client");
    }

    private static <T> T preformExecute(Supplier<Supplier<T>> supplier, String side) {
        try {
            return supplier.get().get();
        }
        catch (Exception exception) {
            ShetiPhianCore.LOGGER.error("SideExecutor; {} Execute Failed: ", (Object)side, (Object)exception);
            return null;
        }
    }
}

